/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.security.config.oauth;

import com.trigyn.jws.usermanagement.entities.JwsAuthenticationType;
import com.trigyn.jws.usermanagement.repository.JwsAuthenticationTypeRepository;
import com.trigyn.jws.usermanagement.utils.Constants;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class OAuthDetails {
    private String oAuthClient = null;
    private String oAuthClientId = null;
    private String oAuthClientSecret = null;

    public OAuthDetails() {
    }

    public OAuthDetails(JwsAuthenticationTypeRepository authenticationTypeRepository) throws JSONException {
        JwsAuthenticationType oAuthType = (JwsAuthenticationType)authenticationTypeRepository.findById(Constants.AuthType.OAUTH.getAuthType()).get();
        JSONObject jsonObject = null;
        if (oAuthType.getAuthenticationProperties() != null) {
            JSONArray jsonArray = new JSONArray(oAuthType.getAuthenticationProperties());
            jsonObject = this.getActiveOAuthJsonObjectFromPropertyValue(jsonObject, jsonArray);
            this.oAuthClient = jsonObject.getString("name");
            this.oAuthClientId = jsonObject.getString("client-id");
            this.oAuthClientSecret = jsonObject.getString("client-secret");
        }
    }

    public JSONObject getActiveOAuthJsonObjectFromPropertyValue(JSONObject jsonObject, JSONArray jsonArray) throws JSONException {
        String propertyName = "selected";
        for (int i = 0; i < jsonArray.length() && !(jsonObject = jsonArray.getJSONObject(i)).get(propertyName).toString().equalsIgnoreCase("true"); ++i) {
            jsonObject = null;
        }
        return jsonObject;
    }

    public String getOAuthClient() {
        return this.oAuthClient;
    }

    public String getOAuthClientId() {
        return this.oAuthClientId;
    }

    public String getOAuthClientSecret() {
        return this.oAuthClientSecret;
    }

    public String getoAuthClient() {
        return this.oAuthClient;
    }

    public void setoAuthClient(String oAuthClient) {
        this.oAuthClient = oAuthClient;
    }

    public String getoAuthClientId() {
        return this.oAuthClientId;
    }

    public void setoAuthClientId(String oAuthClientId) {
        this.oAuthClientId = oAuthClientId;
    }

    public String getoAuthClientSecret() {
        return this.oAuthClientSecret;
    }

    public void setoAuthClientSecret(String oAuthClientSecret) {
        this.oAuthClientSecret = oAuthClientSecret;
    }
}

