/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.service;

import com.trigyn.jws.usermanagement.security.config.ApplicationSecurityDetails;
import com.trigyn.jws.usermanagement.utils.Constants;
import com.trigyn.jws.usermanagement.vo.DropDownData;
import com.trigyn.jws.usermanagement.vo.JwsAuthAdditionalProperty;
import com.trigyn.jws.usermanagement.vo.JwsAuthConfiguration;
import com.trigyn.jws.usermanagement.vo.JwsAuthVerificationType;
import com.trigyn.jws.usermanagement.vo.JwsUserLoginVO;
import com.trigyn.jws.usermanagement.vo.MultiAuthSecurityDetailsVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserConfigService {
    @Autowired
    private ApplicationSecurityDetails applicationSecurityDetails = null;

    public void getConfigurableDetails(Map<String, Object> mapDetails) throws Exception, JSONException {
        if (this.applicationSecurityDetails.getAuthenticationDetails() != null) {
            List multiAuthSecurityDetails;
            Map<String, Object> authenticationDetails = this.applicationSecurityDetails.getAuthenticationDetails();
            Boolean isAuthenticationEnabled = this.applicationSecurityDetails.getIsAuthenticationEnabled();
            mapDetails.put("isAuthenticationEnabled", isAuthenticationEnabled);
            mapDetails.put("enableGoogleAuthenticator", false);
            ArrayList<JwsUserLoginVO> userLoginDetails = new ArrayList<JwsUserLoginVO>();
            if (!authenticationDetails.isEmpty() && isAuthenticationEnabled.booleanValue() && (multiAuthSecurityDetails = (List)authenticationDetails.get("authenticationDetails")) != null) {
                for (MultiAuthSecurityDetailsVO securityAuthDetail : multiAuthSecurityDetails) {
                    JwsAuthVerificationType verificationType = securityAuthDetail.getVerificationTypeVO().getVerificationType();
                    if (!verificationType.getValue().equalsIgnoreCase("true")) continue;
                    HashMap<String, Object> authDetail = new HashMap<String, Object>();
                    JwsUserLoginVO jwsUserLoginVO = new JwsUserLoginVO();
                    jwsUserLoginVO.setAuthenticationType(securityAuthDetail.getAuthenticationTypeVO().getId());
                    jwsUserLoginVO.setVerificationType(0);
                    authDetail.put(verificationType.getName(), verificationType.getValue());
                    mapDetails.put(verificationType.getName(), verificationType.getValue());
                    List<JwsAuthConfiguration> configurations = securityAuthDetail.getVerificationTypeVO().getConfigurations();
                    if (configurations != null) {
                        for (JwsAuthConfiguration authConfiguration : configurations) {
                            if (verificationType.getConfigurationType().equalsIgnoreCase("single")) {
                                authDetail.put(authConfiguration.getName(), authConfiguration.getValue());
                                mapDetails.put(authConfiguration.getName(), authConfiguration.getValue());
                                List<JwsAuthAdditionalProperty> additionalProperties = authConfiguration.getAdditionalProperties();
                                if (additionalProperties == null) continue;
                                JwsAuthAdditionalProperty verficationType = additionalProperties.stream().filter(config -> config.getName().equals("verificationType")).findFirst().orElse(null);
                                if (verficationType != null) {
                                    jwsUserLoginVO.setVerificationType(Integer.valueOf(verficationType.getValue()));
                                    if (Constants.VerificationType.TOTP.getVerificationType().equals(verficationType.getValue())) {
                                        mapDetails.put("enableGoogleAuthenticator", true);
                                    }
                                }
                                for (JwsAuthAdditionalProperty additionalProperty : additionalProperties) {
                                    if (additionalProperty == null) continue;
                                    authDetail.put(additionalProperty.getName(), additionalProperty.getValue());
                                    mapDetails.put(additionalProperty.getName(), additionalProperty.getValue());
                                }
                                continue;
                            }
                            List<DropDownData> dropDownDatas = authConfiguration.getDropDownData();
                            if (dropDownDatas == null) continue;
                            for (DropDownData dropDownData : dropDownDatas) {
                                if (dropDownData == null || !dropDownData.getSelected().booleanValue()) continue;
                                authDetail.put(dropDownData.getName(), dropDownData.getSelected());
                                mapDetails.put(dropDownData.getName(), dropDownData.getSelected());
                                List<JwsAuthAdditionalProperty> additionalProperties = dropDownData.getAdditionalProperties();
                                if (additionalProperties == null) continue;
                                for (JwsAuthAdditionalProperty additionalProperty : additionalProperties) {
                                    if (additionalProperty == null) continue;
                                    authDetail.put(additionalProperty.getName(), additionalProperty.getValue());
                                    mapDetails.put(additionalProperty.getName(), additionalProperty.getValue());
                                }
                            }
                        }
                    }
                    jwsUserLoginVO.setLoginAttributes(authDetail);
                    userLoginDetails.add(jwsUserLoginVO);
                }
            }
            mapDetails.put("activeAutenticationDetails", userLoginDetails);
            mapDetails.put("authDetails", mapDetails);
        }
    }

    public JSONObject getJsonObjectFromPropertyValue(JSONObject jsonObject, JSONArray jsonArray, String propertyName) throws JSONException {
        for (int i = 0; i < jsonArray.length() && !(jsonObject = jsonArray.getJSONObject(i)).get("name").toString().equalsIgnoreCase(propertyName); ++i) {
            jsonObject = null;
        }
        return jsonObject;
    }
}

