/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.usermanagement.utils;

import java.util.UUID;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public final class SessionCounter
implements HttpSessionListener {
    private static final Logger logger = LogManager.getLogger(SessionCounter.class);
    private static Vector<String> httpSessionVector = new Vector();
    public static final String COUNTER = "session-counter";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        logger.info("SessionCounter.sessionCreated");
        String jqUserId = UUID.randomUUID().toString();
        HttpSession httpSession = httpSessionEvent.getSession();
        httpSession.getServletContext().setAttribute("jqUserId", (Object)jqUserId);
        Vector<String> vector = httpSessionVector;
        synchronized (vector) {
            httpSessionVector.add(jqUserId);
        }
        logger.info("After session created. jqUserId{}:- httpSessionVectorSize:{}- ", (Object)jqUserId, (Object)httpSessionVector.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        logger.info("SessionCounter.sessionDestroyed");
        HttpSession httpSession = httpSessionEvent.getSession();
        String jqUserId = (String)httpSession.getServletContext().getAttribute("jqUserId");
        Vector<String> vector = httpSessionVector;
        synchronized (vector) {
            httpSessionVector.remove(jqUserId);
        }
        logger.info("After session destroyed. jqUserId{}:- httpSessionVectorSize:{}- ", (Object)jqUserId, (Object)httpSessionVector.size());
    }

    public int getActiveSessionCount() {
        return httpSessionVector.size();
    }
}

