SET FOREIGN_KEY_CHECKS=0;

DROP PROCEDURE IF EXISTS manageEntityRoleListing;
CREATE PROCEDURE `manageEntityRoleListing`(entityName varchar(50), moduleId varchar(50),forCount INT, limitFrom INT, limitTo INT
,sortIndex VARCHAR(100),sortOrder VARCHAR(20))
BEGIN

  SET @selectRoleQuery  =  (SELECT GROUP_CONCAT(CONCAT ('GROUP_CONCAT(CASE WHEN jr.role_name="',jr.role_name,'" THEN CONCAT(jera.role_id,"@::@",jera.is_active) END)  AS `',jr.role_name,'`')) FROM jq_role AS jr ORDER BY jr.role_name);

  SET @resultQuery = CONCAT(" SELECT jera.entity_role_id AS entityRoleId,jera.entity_id AS entityId,jera.entity_name AS entityName,jera.module_id AS moduleId,jmm.module_name AS moduleName, "
  ,@selectRoleQuery ) ;
  SET @fromString  = ' FROM  jq_role jr RIGHT OUTER JOIN jq_entity_role_association  jera ON jera.role_id = jr.role_id INNER JOIN jq_master_modules jmm ON jmm.module_id = jera.module_id ';
  SET @whereString = ' WHERE jr.is_active=1  AND jera.module_type_id=0 ';
  
  IF NOT moduleId IS NULL THEN
    SET @moduleId= REPLACE(moduleId,"'","''");
    SET @whereString = CONCAT(@whereString,' AND jera.module_id like ''%',@moduleId,'%''');
  END IF;
  
  IF NOT entityName IS NULL THEN
    SET @entityName= REPLACE(entityName,"'","''");
    SET @whereString = CONCAT(@whereString,' AND entity_name like ''%',@entityName,'%''');
  END IF;
  
  
  
  SET @limitString = CONCAT(' LIMIT ','',CONCAT(limitFrom,',',limitTo));
  
  IF NOT sortIndex IS NULL THEN
      SET @orderBy = CONCAT(' ORDER BY ' ,sortIndex,' ',sortOrder);
    ELSE
      SET @orderBy = CONCAT(' ORDER BY last_updated_date DESC');
  END IF;
  
  SET @groupByString = CONCAT(' GROUP BY jera.entity_id ');
  
	IF forCount=1 THEN
  	SET @queryString=CONCAT('SELECT COUNT(*) FROM ( ',@resultQuery, @fromString, @whereString, @groupByString,@orderBy,' ) AS cnt');
  ELSE
  	SET @queryString=CONCAT(@resultQuery, @fromString, @whereString, @groupByString, @orderBy, @limitString);
  END IF;


  
 PREPARE stmt FROM @queryString;
 EXECUTE stmt;
 DEALLOCATE PREPARE stmt;
 
END;

REPLACE  INTO  jq_property_master (
property_master_id
  ,owner_type
  ,owner_id
  ,property_name
  ,property_value
  ,is_deleted
  ,last_modified_date
  ,modified_by
  ,app_version
  ,comments
) VALUES (
	'51849604-1a8f-11eb-98d3-f48e38ab8cd7'
  ,'system'
  ,'system'
  ,'enable-user-management'
  ,'false'
  ,0
  ,now()
  ,'admin'
  ,'1.000'
  ,'By default user management will be disabled' 
);


   REPLACE  INTO  jq_property_master (
  property_master_id
  ,owner_type
  ,owner_id
  ,property_name
  ,property_value
  ,is_deleted
  ,last_modified_date
  ,modified_by
  ,app_version
  ,comments
) VALUES (
   '3b2838cc-1a8f-11eb-98d3-f48e38ab8cd7'
  ,'system'
  ,'system'
  ,'authentication-type'
  ,'1'
  ,0
  ,now()
  ,'admin'
  ,'1.000'
  ,'Authentication type - default in memory authentication' 
);

REPLACE INTO jq_property_master(property_master_id, owner_type, owner_id, property_name, property_value, is_deleted, last_modified_date, modified_by, app_version, comments)
VALUES ('006d0d5a-3c9d-11ec-88bb-9840bb1e8144', 'system', 'system', 'base-url', 'http://localhost:8080', 0, NOW(), 'admin', 1.00, 'Base url of application');

SET FOREIGN_KEY_CHECKS=1;