/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.CMS;
import com.twitter.algebird.CMSFunctions$;
import com.twitter.algebird.CMSHash;
import com.twitter.algebird.CMSInstance;
import com.twitter.algebird.CMSItem;
import com.twitter.algebird.CMSParams;
import com.twitter.algebird.CMSZero;
import com.twitter.algebird.SparseCMS;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.compat.TraversableOnceExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorIterator;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114A\u0001D\u0007\u0001)!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003-\u0001\u0011\u0005Q\u0006\u0003\u00041\u0001\u0001\u0006I!\r\u0005\u0007o\u0001\u0001\u000b\u0011\u0002\u001d\t\rm\u0002\u0001\u0015!\u00039\u0011\u0019a\u0004\u0001)A\u0005{!1\u0011\t\u0001Q!\nyBQA\u0011\u0001\u0005\u0006\rCQa\u0013\u0001\u0005\u00021CQA\u0018\u0001\u0005\u0002}CQA\u0019\u0001\u0005\u0002\r\u0014AbQ'T'VlW.\u0019;j_:T!AD\b\u0002\u0011\u0005dw-\u001a2je\u0012T!\u0001E\t\u0002\u000fQ<\u0018\u000e\u001e;fe*\t!#A\u0002d_6\u001c\u0001!\u0006\u0002\u0016GM\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rA\f'/Y7t!\rqr$I\u0007\u0002\u001b%\u0011\u0001%\u0004\u0002\n\u00076\u001b\u0006+\u0019:b[N\u0004\"AI\u0012\r\u0001\u0011)A\u0005\u0001b\u0001K\t\t1*\u0005\u0002'SA\u0011qcJ\u0005\u0003Qa\u0011qAT8uQ&tw\r\u0005\u0002\u0018U%\u00111\u0006\u0007\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\b\u0006\u0002/_A\u0019a\u0004A\u0011\t\u000bq\u0011\u0001\u0019A\u000f\u0002\r!\f7\u000f[3t!\r9\"\u0007N\u0005\u0003ga\u0011Q!\u0011:sCf\u00042AH\u001b\"\u0013\t1TBA\u0004D\u001bNC\u0015m\u001d5\u0002\r!,\u0017n\u001a5u!\t9\u0012(\u0003\u0002;1\t\u0019\u0011J\u001c;\u0002\u000b]LG\r\u001e5\u0002\u000b\r,G\u000e\\:\u0011\u0007]\u0011d\b\u0005\u0002\u0018\u007f%\u0011\u0001\t\u0007\u0002\u0005\u0019>tw-\u0001\u0006u_R\fGnQ8v]R\fa!\u001b8tKJ$Hc\u0001#H\u0013B\u0011q#R\u0005\u0003\rb\u0011A!\u00168ji\")\u0001\n\u0003a\u0001C\u0005\t1\u000eC\u0003K\u0011\u0001\u0007a(A\u0003d_VtG/A\u0005va\u0012\fG/Z!mYR\u0011A)\u0014\u0005\u0006\u001d&\u0001\raT\u0001\tg.,Go\u00195fgB\u0019\u0001\u000bW.\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+\u0014\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002X1\u00059\u0001/Y2lC\u001e,\u0017BA-[\u0005=!&/\u0019<feN\f'\r\\3P]\u000e,'BA,\u0019!\rqB,I\u0005\u0003;6\u00111aQ'T\u0003))\b\u000fZ1uK&sGo\u001c\u000b\u0003\t\u0002DQ!\u0019\u0006A\u0002m\u000b1aY7t\u0003\u0019\u0011Xm];miV\t1\f")
public class CMSSummation<K> {
    private final CMSParams<K> params;
    private final CMSHash<K>[] hashes;
    private final int height;
    private final int width;
    private final long[] cells;
    private long totalCount;

    public final void insert(K k, long count) {
        int offset = 0;
        CMSHash<K>[] hs = this.hashes;
        for (int row = 0; row < hs.length; ++row) {
            int n = offset + hs[row].apply(k);
            this.cells[n] = this.cells[n] + count;
            offset += this.width;
        }
        this.totalCount += count;
    }

    public void updateAll(TraversableOnce<CMS<K>> sketches) {
        TraversableOnceExtensionMethods$.MODULE$.iterator$extension(package$.MODULE$.toTraversableOnceExtensionMethods(sketches)).foreach((Function1 & Serializable & scala.Serializable)cms -> {
            this.updateInto(cms);
            return BoxedUnit.UNIT;
        });
    }

    public void updateInto(CMS<K> cms) {
        if (!(cms instanceof CMSZero)) {
            if (cms instanceof CMSItem) {
                CMSItem cMSItem = (CMSItem)cms;
                Object item = cMSItem.item();
                long count = cMSItem.totalCount();
                this.insert(item, count);
                return;
            }
            if (cms instanceof SparseCMS) {
                ((SparseCMS)cms).exactCountTable().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    CMSSummation.$anonfun$updateInto$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (cms instanceof CMSInstance) {
                CMSInstance cMSInstance = (CMSInstance)cms;
                CMSInstance.CountsTable countsTable = cMSInstance.countsTable();
                long count = cMSInstance.totalCount();
                if (countsTable != null) {
                    Vector<Vector<Object>> matrix = countsTable.counts();
                    int offset = 0;
                    VectorIterator rit = matrix.iterator();
                    while (rit.hasNext()) {
                        int col = 0;
                        VectorIterator cit = ((Vector)rit.next()).iterator();
                        while (cit.hasNext()) {
                            int n = offset + col;
                            this.cells[n] = this.cells[n] + BoxesRunTime.unboxToLong((Object)cit.next());
                            ++col;
                        }
                        offset += this.width;
                    }
                    this.totalCount += count;
                    return;
                }
            }
            throw new MatchError(cms);
        }
    }

    public CMS<K> result() {
        if (this.totalCount == 0L) {
            return new CMSZero<K>(this.params);
        }
        Builder b = scala.package$.MODULE$.Vector().newBuilder();
        for (int row = 0; row < this.height; ++row) {
            b.$plus$eq((Object)this.vectorize$1(row));
        }
        return new CMSInstance(new CMSInstance.CountsTable((Vector<Vector<Object>>)((Vector)b.result())), this.totalCount, this.params);
    }

    public static final /* synthetic */ void $anonfun$updateInto$1(CMSSummation $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            Object item = x0$1._1();
            long c = x0$1._2$mcJ$sp();
            $this.insert(item, c);
            return;
        }
        throw new MatchError(null);
    }

    private final Vector vectorize$1(int row) {
        int offset = row * this.width;
        Builder b = scala.package$.MODULE$.Vector().newBuilder();
        for (int col = 0; col < this.width; ++col) {
            b.$plus$eq((Object)BoxesRunTime.boxToLong((long)this.cells[offset + col]));
        }
        return (Vector)b.result();
    }

    public CMSSummation(CMSParams<K> params) {
        this.params = params;
        this.hashes = (CMSHash[])params.hashes().toArray(ClassTag$.MODULE$.apply(CMSHash.class));
        this.height = CMSFunctions$.MODULE$.depth(params.delta());
        this.width = CMSFunctions$.MODULE$.width(params.eps());
        this.cells = new long[this.height * this.width];
        this.totalCount = 0L;
    }
}

