/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.Approximate;
import com.twitter.algebird.BitSetLite;
import com.twitter.algebird.Bytes;
import com.twitter.algebird.DenseHLL;
import com.twitter.algebird.HLL;
import com.twitter.algebird.Hash128$;
import com.twitter.algebird.Max;
import com.twitter.algebird.SparseHLL;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class HyperLogLog$ {
    public static HyperLogLog$ MODULE$;
    private final int hashSize;
    private final double[] negativePowersOfTwo;

    static {
        new HyperLogLog$();
    }

    public int hashSize() {
        return this.hashSize;
    }

    public double[] negativePowersOfTwo() {
        return this.negativePowersOfTwo;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] hash(byte[] input) {
        void var5_4;
        void var3_3;
        Tuple2<Object, Object> tuple2 = Hash128$.MODULE$.arrayByteHash().hash(input);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long l0 = tuple2._1$mcJ$sp();
        long l1 = tuple2._2$mcJ$sp();
        return this.pairLongs2Bytes((long)var3_3, (long)var5_4);
    }

    public byte[] pairLongs2Bytes(long l0, long l1) {
        byte[] buf = new byte[16];
        ByteBuffer.wrap(buf).putLong(l0).putLong(l1);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] int2Bytes(int i) {
        void var2_2;
        byte[] buf = new byte[4];
        ByteBuffer.wrap(buf).putInt(i);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] long2Bytes(long i) {
        void var3_2;
        byte[] buf = new byte[8];
        ByteBuffer.wrap(buf).putLong(i);
        return var3_2;
    }

    public double twopow(int i) {
        return Math.pow(2.0, i);
    }

    public int j(BitSetLite bsl, int bits) {
        return this.j(bsl.in(), bits);
    }

    public int j(byte[] bytes, int bits) {
        int i = 0;
        int sum = 0;
        for (int need = bits; i < bytes.length && need > 0; need -= 8, ++i) {
            int n = bytes[i] & 0xFF;
            int limit = Math.min(8, need);
            for (int j = 0; j < limit; ++j) {
                sum += (n >>> 7 - j & 1) << i * 8 + j;
            }
        }
        return sum;
    }

    public byte rhoW(BitSetLite bsl, int bits) {
        return this.rhoW(bsl.in(), bits);
    }

    public byte rhoW(byte[] bytes, int bits) {
        int j = 7 - bits % 8;
        int zeros = 1;
        for (int i = bits / 8; i < bytes.length; ++i) {
            while (j >= 0) {
                if ((bytes[i] >>> j & 1) == 1) {
                    return (byte)zeros;
                }
                ++zeros;
                --j;
            }
            j = 7;
        }
        return (byte)0;
    }

    public Tuple2<Object, Object> jRhoW(byte[] in, int bits) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.j(in, bits)), (Object)BoxesRunTime.boxToByte((byte)this.rhoW(in, bits)));
    }

    public byte[] toBytes(HLL h) {
        byte[] byArray;
        if (h instanceof SparseHLL) {
            SparseHLL sparseHLL = (SparseHLL)h;
            int bits = sparseHLL.bits();
            Map<Object, Max<Object>> maxRhow = sparseHLL.maxRhow();
            int jLen = (bits + 7) / 8;
            Predef$.MODULE$.assert(jLen >= 1);
            Predef$.MODULE$.assert(jLen <= 3);
            byte[] buf = new byte[2 + (jLen + 1) * maxRhow.size()];
            ByteBuffer byteBuf = ByteBuffer.wrap(buf).put((byte)3).put((byte)bits);
            maxRhow.foldLeft((Object)byteBuf, (Function2 & Serializable & scala.Serializable)(bb, jrhow) -> {
                void var4_4;
                void var3_3;
                if (jrhow == null) {
                    throw new MatchError(null);
                }
                int j = jrhow._1$mcI$sp();
                Max rhow = (Max)jrhow._2();
                bb.put((byte)(var3_3 & 0xFF));
                if (jLen >= 2) {
                    bb.put((byte)(var3_3 >> 8 & 0xFF));
                }
                if (jLen >= 3) {
                    bb.put((byte)(var3_3 >> 16 & 0xFF));
                }
                return bb.put(BoxesRunTime.unboxToByte(var4_4.get()));
            });
            byArray = buf;
        } else if (h instanceof DenseHLL) {
            DenseHLL denseHLL = (DenseHLL)h;
            int bits = denseHLL.bits();
            Bytes v = denseHLL.v();
            ByteBuffer bb2 = ByteBuffer.allocate(v.size() + 2);
            bb2.put((byte)2);
            bb2.put((byte)bits);
            bb2.put(v.array());
            byArray = bb2.array();
        } else {
            throw new MatchError((Object)h);
        }
        return byArray;
    }

    public HLL fromBytes(byte[] bytes) {
        return this.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    public HLL fromByteBuffer(ByteBuffer bb) {
        byte by = bb.get();
        switch (by) {
            case 2: {
                byte bits = bb.get();
                byte[] buf = new byte[bb.remaining()];
                bb.get(buf);
                return new DenseHLL(bits, new Bytes(buf));
            }
            case 3: {
                return this.sparseFromByteBuffer(bb);
            }
        }
        throw new Exception(new StringBuilder(23).append("Unrecognized HLL type: ").append(by).toString());
    }

    private SparseHLL sparseFromByteBuffer(ByteBuffer bb) {
        byte bits = bb.get();
        int jLen = (bits + 7) / 8;
        Predef$.MODULE$.assert(bb.remaining() % (jLen + 1) == 0, (Function0 & Serializable & scala.Serializable)() -> "Invalid byte array");
        Map maxRhow = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), bb.remaining() / (jLen + 1)).map((Function1 & Serializable & scala.Serializable)x$3 -> HyperLogLog$.$anonfun$sparseFromByteBuffer$2(jLen, bb, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new SparseHLL(bits, (Map<Object, Max<Object>>)maxRhow);
    }

    public double alpha(int bits) {
        switch (bits) {
            case 4: {
                return 0.673;
            }
            case 5: {
                return 0.697;
            }
            case 6: {
                return 0.709;
            }
        }
        return 0.7213 / (1.0 + 1.079 / (double)(1 << bits));
    }

    public double error(int bits) {
        return 1.04 / package$.MODULE$.sqrt(Math.pow(2.0, bits));
    }

    public int bitsForError(double err) {
        Predef$.MODULE$.require(err >= 3.0E-5 && err < 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Error must be in (0.00003, 1.0): ").append(err).toString());
        return (int)package$.MODULE$.ceil(2.0 * package$.MODULE$.log(1.04 / err) / package$.MODULE$.log(2.0));
    }

    public double initialEstimate(int bits, int size, int zeroCnt, double z) {
        double sizeDouble = size;
        double smallE = (double)5 * sizeDouble / 2.0;
        double e = this.alpha(bits) * sizeDouble * sizeDouble * z;
        if (e > smallE || zeroCnt == 0) {
            return e;
        }
        return (double)size * package$.MODULE$.log((double)size / (double)zeroCnt);
    }

    public Approximate<Object> asApprox(int bits, double v) {
        double stdev = 1.04 / package$.MODULE$.sqrt(Math.pow(2.0, bits));
        long lowerBound = (long)Math.floor(package$.MODULE$.max(v * (1.0 - (double)3 * stdev), 0.0));
        long upperBound = (long)Math.ceil(v * (1.0 + (double)3 * stdev));
        double prob3StdDev = 0.9972;
        return new Approximate<Object>(BoxesRunTime.boxToLong((long)lowerBound), BoxesRunTime.boxToLong((long)((long)v)), BoxesRunTime.boxToLong((long)upperBound), prob3StdDev, (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$);
    }

    public Approximate<Object> approximateSize(int bits, int size, int zeroCnt, double z) {
        return this.asApprox(bits, this.initialEstimate(bits, size, zeroCnt, z));
    }

    public static final /* synthetic */ Tuple2 $anonfun$sparseFromByteBuffer$2(int jLen$2, ByteBuffer bb$1, int x$3) {
        int n;
        switch (jLen$2) {
            case 1: {
                n = bb$1.get() & 0xFF;
                break;
            }
            case 2: {
                n = (bb$1.get() & 0xFF) + ((bb$1.get() & 0xFF) << 8);
                break;
            }
            case 3: {
                n = (bb$1.get() & 0xFF) + ((bb$1.get() & 0xFF) << 8) + ((bb$1.get() & 0xFF) << 16);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)jLen$2));
            }
        }
        int j = n;
        byte rhow = bb$1.get();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)j)), new Max<Byte>(BoxesRunTime.boxToByte((byte)rhow)));
    }

    private HyperLogLog$() {
        MODULE$ = this;
        this.hashSize = 128;
        this.negativePowersOfTwo = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.hashSize()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> package$.MODULE$.pow(2.0, (double)(-i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }
}

