/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.Group;
import com.twitter.algebird.Monoid;
import com.twitter.algebird.Monoid$;
import com.twitter.algebird.Operators$;
import com.twitter.algebird.Priority;
import com.twitter.algebird.Window;
import com.twitter.algebird.WindowMonoid;
import com.twitter.algebird.WindowMonoidFromGroup;
import com.twitter.algebird.WindowMonoidFromMonoid;
import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;

public final class Window$
implements Serializable {
    public static Window$ MODULE$;

    static {
        new Window$();
    }

    public <T> Window<T> apply(T v) {
        return new Window<T>(v, Queue$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
    }

    public <T> Window<T> fromIterable(Iterable<T> ts, WindowMonoid<T> m) {
        return m.fromIterable(ts);
    }

    public <T> WindowMonoid<T> monoid(int size, Priority<Group<T>, Monoid<T>> p) {
        WindowMonoid<T> windowMonoid;
        if (p instanceof Priority.Preferred) {
            Group grp = (Group)((Priority.Preferred)p).get();
            windowMonoid = this.monoidFromGroup(size, grp);
        } else if (p instanceof Priority.Fallback) {
            Monoid mon = (Monoid)((Priority.Fallback)p).get();
            windowMonoid = this.monoidFromMonoid(size, mon);
        } else {
            throw new MatchError(p);
        }
        return windowMonoid;
    }

    public <T> WindowMonoid<T> monoidFromGroup(int size, Group<T> evidence$1) {
        return new WindowMonoidFromGroup<T>(size, evidence$1);
    }

    public <T> WindowMonoid<T> monoidFromMonoid(int size, Monoid<T> evidence$2) {
        return new WindowMonoidFromMonoid<T>(size, evidence$2);
    }

    public <T> Window<T> combineWithGroup(int windowSize, Window<T> a, Window<T> b, Group<T> evidence$3) {
        if (b.items().size() >= windowSize) {
            Object total = b.total();
            Queue q = b.items();
            while (q.size() > windowSize) {
                total = Operators$.MODULE$.toMinus(total, evidence$3).$minus(q.head());
                q = q.tail();
            }
            return new Window<T>(total, q);
        }
        Queue truncA = a.items();
        Object totalA = a.total();
        int truncTo = windowSize - b.size();
        while (truncA.size() > truncTo) {
            totalA = Operators$.MODULE$.toMinus(totalA, evidence$3).$minus(truncA.head());
            truncA = truncA.tail();
        }
        Queue items = (Queue)truncA.$plus$plus(b.items(), Queue$.MODULE$.canBuildFrom());
        T total = Operators$.MODULE$.toPlus(totalA, evidence$3).$plus(b.total());
        return new Window<T>(total, items);
    }

    public <T> Window<T> combineWithMonoid(int windowSize, Window<T> a, Window<T> b, Monoid<T> evidence$4) {
        if (b.items().size() >= windowSize) {
            Queue items = (Queue)b.items().takeRight(windowSize);
            T total = Monoid$.MODULE$.sum(items, evidence$4);
            return new Window<T>(total, items);
        }
        Queue fromA = (Queue)a.items().takeRight(windowSize - b.items().size());
        Queue items = (Queue)fromA.$plus$plus(b.items(), Queue$.MODULE$.canBuildFrom());
        T total = Operators$.MODULE$.toPlus(Monoid$.MODULE$.sum(fromA, evidence$4), evidence$4).$plus(b.total());
        return new Window<T>(total, items);
    }

    public <T> Window<T> apply(T total, Queue<T> items) {
        return new Window<T>(total, items);
    }

    public <T> Option<Tuple2<T, Queue<T>>> unapply(Window<T> x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.total(), x$0.items()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Window$() {
        MODULE$ = this;
    }
}

