/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.example.memcache;

import com.twitter.common.args.Flags$;
import com.twitter.concurrent.NamedPoolThreadFactory;
import com.twitter.finagle.CodecFactory;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.builder.ClientBuilder$;
import com.twitter.finagle.builder.ClientConfigEvidence;
import com.twitter.finagle.example.memcache.MemcacheStress;
import com.twitter.finagle.example.memcache.MemcacheStress$Config$;
import com.twitter.finagle.example.memcache.PersistentService;
import com.twitter.finagle.memcached.Client;
import com.twitter.finagle.memcached.Client$;
import com.twitter.finagle.memcached.protocol.text.Memcached$;
import com.twitter.finagle.stats.OstrichStatsReceiver;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.tracing.Trace$;
import com.twitter.ostrich.admin.AdminHttpService;
import com.twitter.ostrich.admin.RuntimeEnvironment;
import com.twitter.ostrich.admin.RuntimeEnvironment$;
import com.twitter.util.Duration;
import com.twitter.util.Stopwatch$;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MemcacheStress$ {
    public static final MemcacheStress$ MODULE$;
    private final AtomicLong count;

    static {
        new MemcacheStress$();
    }

    public AtomicLong count() {
        return this.count;
    }

    public void proc(Client client2, String key, ChannelBuffer value) {
        client2.set(key, (Object)value).ensure((Function0)new Serializable(client2, key, value){
            public static final long serialVersionUID = 0L;
            private final Client client$1;
            private final String key$1;
            private final ChannelBuffer value$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MemcacheStress$.MODULE$.count().incrementAndGet();
                MemcacheStress$.MODULE$.proc(this.client$1, this.key$1, this.value$1);
            }
            {
                this.client$1 = client$1;
                this.key$1 = key$1;
                this.value$1 = value$1;
            }
        });
    }

    public void main(String[] args2) {
        MemcacheStress.Config config = (MemcacheStress.Config)Flags$.MODULE$.apply((Object)new MemcacheStress.Config(MemcacheStress$Config$.MODULE$.apply$default$1(), MemcacheStress$Config$.MODULE$.apply$default$2(), MemcacheStress$Config$.MODULE$.apply$default$3(), MemcacheStress$Config$.MODULE$.apply$default$4(), MemcacheStress$Config$.MODULE$.apply$default$5(), MemcacheStress$Config$.MODULE$.apply$default$6(), MemcacheStress$Config$.MODULE$.apply$default$7()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])args2));
        ClientBuilder builder = ClientBuilder$.MODULE$.apply().name("mc").codec((CodecFactory)Memcached$.MODULE$.apply(Memcached$.MODULE$.apply$default$1())).hostConnectionLimit(config.concurrency()).hosts(config.hosts());
        if (config.nworkers() > 0) {
            builder = builder.channelFactory((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool((ThreadFactory)new NamedPoolThreadFactory("memcacheboss")), (Executor)Executors.newCachedThreadPool((ThreadFactory)new NamedPoolThreadFactory("memcacheIO")), config.nworkers()));
        }
        if (config.stats()) {
            builder = builder.reportTo((StatsReceiver)new OstrichStatsReceiver());
        }
        if (config.tracing()) {
            Trace$.MODULE$.enable();
        } else {
            Trace$.MODULE$.disable();
        }
        String key = new StringOps(Predef$.MODULE$.augmentString("x")).$times(config.keysize());
        ChannelBuffer value = ChannelBuffers.wrappedBuffer((byte[])new StringOps(Predef$.MODULE$.augmentString("y")).$times(config.valuesize()).getBytes());
        RuntimeEnvironment runtime = RuntimeEnvironment$.MODULE$.apply((Object)this, (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        AdminHttpService adminService = new AdminHttpService(2000, 100, runtime);
        adminService.start();
        Predef$.MODULE$.println((Object)builder);
        ServiceFactory factory = builder.buildFactory((ClientConfigEvidence)ClientConfigEvidence.FullyConfigured$.MODULE$);
        Function0 elapsed = Stopwatch$.MODULE$.start();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.concurrency()).foreach$mVc$sp((Function1)new Serializable(key, value, factory){
            public static final long serialVersionUID = 0L;
            private final String key$2;
            private final ChannelBuffer value$2;
            private final ServiceFactory factory$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int v1) {
                PersistentService<Req, Rep> svc = new PersistentService<Req, Rep>(this.factory$1);
                Client client2 = Client$.MODULE$.apply(svc);
                MemcacheStress$.MODULE$.proc(client2, this.key$2, this.value$2);
            }
            {
                this.key$2 = key$2;
                this.value$2 = value$2;
                this.factory$1 = factory$1;
            }
        });
        while (true) {
            Thread.sleep(5000L);
            Duration howlong = (Duration)elapsed.apply();
            long howmuch = this.count().get();
            Predef$.MODULE$.assert(howmuch > 0L);
            Predef$.MODULE$.printf("%d QPS\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(howmuch / (long)howlong.inSeconds()))}));
        }
    }

    private MemcacheStress$() {
        MODULE$ = this;
        this.count = new AtomicLong();
    }
}

