/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.exp;

import com.twitter.finagle.exp.WindowedAdder$;
import com.twitter.jsr166e.LongAdder;
import com.twitter.util.Duration;
import com.twitter.util.Stopwatch;
import com.twitter.util.TimeLike;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.math.Ordered;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\t-\u0011QbV5oI><X\rZ!eI\u0016\u0014(BA\u0002\u0005\u0003\r)\u0007\u0010\u001d\u0006\u0003\u000b\u0019\tqAZ5oC\u001edWM\u0003\u0002\b\u0011\u00059Ao^5ui\u0016\u0014(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011m\u0001!\u0011!Q\u0001\nq\tQA]1oO\u0016\u0004\"!\b\u0011\u000e\u0003yQ!a\b\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003Cy\u0011\u0001\u0002R;sCRLwN\u001c\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u000511\u000f\\5dKN\u0004\"!F\u0013\n\u0005\u00192\"aA%oi\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&A\u0005ti>\u0004x/\u0019;dQB\u0011QDK\u0005\u0003Wy\u0011\u0011b\u0015;pa^\fGo\u00195\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\u0011y\u0013GM\u001a\u0011\u0005A\u0002Q\"\u0001\u0002\t\u000bma\u0003\u0019\u0001\u000f\t\u000b\rb\u0003\u0019\u0001\u0013\t\u000f!b\u0003\u0013!a\u0001S!1Q\u0007\u0001Q\u0001\nq\taa^5oI><\bBB\u001c\u0001A\u0003%A%A\u0001O\u0011\u0019I\u0004\u0001)A\u0005u\u00051qO]5uKJ\u0004\"a\u000f \u000e\u0003qR!!\u0010\u0004\u0002\u000f)\u001c(/\r\u001c7K&\u0011q\b\u0010\u0002\n\u0019>tw-\u00113eKJDa!\u0011\u0001!B\u0013!\u0013aA4f]\"\u0012\u0001i\u0011\t\u0003+\u0011K!!\u0012\f\u0003\u0011Y|G.\u0019;jY\u0016Daa\u0012\u0001!\u0002\u0013A\u0015AC3ya&\u0014X\rZ$f]B\u0011\u0011jT\u0007\u0002\u0015*\u00111\nT\u0001\u0007CR|W.[2\u000b\u00055s\u0015AC2p]\u000e,(O]3oi*\u0011q\u0004E\u0005\u0003!*\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bB\u0002*\u0001A\u0003%1+A\u0002ck\u001a\u00042!\u0006+W\u0013\t)fCA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0016/&\u0011\u0001L\u0006\u0002\u0005\u0019>tw\r\u0003\u0004[\u0001\u0001\u0006K\u0001J\u0001\u0002S\"\u0012\u0011l\u0011\u0005\u0007;\u0002\u0001\u000b\u0015\u00020\u0002\u000f\u0015d\u0017\r]:fIB\u0011q,\u0019\b\u0003A\u001ej\u0011\u0001A\u0005\u0003E*\u0012q!\u00127baN,G\r\u000b\u0002]\u0007\"1Q\r\u0001Q\u0005\n\u0019\fq!\u001a=qSJ,G\rF\u0001h!\t)\u0002.\u0003\u0002j-\t!QK\\5u\u0011\u0015Y\u0007\u0001\"\u0001g\u0003\u0015\u0011Xm]3u\u0011\u0015i\u0007\u0001\"\u0001g\u0003\u0011Ign\u0019:\t\u000b=\u0004A\u0011\u00019\u0002\u0007\u0005$G\r\u0006\u0002hc\")!O\u001ca\u0001I\u0005\t\u0001\u0010C\u0003u\u0001\u0011\u0005Q/A\u0002tk6$\u0012AV\u0004\bo\n\t\t\u0011#\u0004y\u000359\u0016N\u001c3po\u0016$\u0017\t\u001a3feB\u0011\u0001'\u001f\u0004\b\u0003\t\t\t\u0011#\u0004{'\rIH\u0002\u0006\u0005\u0006[e$\t\u0001 \u000b\u0002q\"9a0_I\u0001\n\u0003y\u0018AD5oSR$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0003Q3!KA\u0002W\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\b-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0011\u0011\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class WindowedAdder
implements ScalaObject {
    private final Stopwatch stopwatch;
    private final Duration window;
    private final int N;
    private final LongAdder writer;
    private volatile int gen;
    private final AtomicInteger expiredGen;
    private final long[] buf;
    private volatile int i;
    private volatile Function0<Duration> elapsed;

    public static final Stopwatch init$default$3() {
        return WindowedAdder$.MODULE$.init$default$3();
    }

    private void expired() {
        if (this.expiredGen.compareAndSet(this.gen, this.gen + 1)) {
            this.buf[this.i] = this.writer.sumThenReset();
            this.i = (this.i + 1) % this.N;
            int nskip = Predef$.MODULE$.intWrapper((int)(((TimeLike)this.elapsed.apply()).inMilliseconds() / this.window.inMilliseconds() - 1L)).min(this.N);
            if (nskip > 0) {
                int r = Predef$.MODULE$.intWrapper(nskip).min(this.N - this.i);
                Arrays.fill(this.buf, this.i, this.i + r, 0L);
                Arrays.fill(this.buf, 0, nskip - r, 0L);
                this.i = (this.i + nskip) % this.N;
            }
            this.elapsed = this.stopwatch.start();
            ++this.gen;
            return;
        }
    }

    public void reset() {
        Arrays.fill(this.buf, 0, this.N, 0L);
        this.writer.reset();
        this.elapsed = this.stopwatch.start();
    }

    public void incr() {
        this.add(1);
    }

    public void add(int x) {
        if (((Ordered)this.elapsed.apply()).$greater$eq((Object)this.window)) {
            this.expired();
        }
        this.writer.add((long)x);
    }

    /*
     * WARNING - void declaration
     */
    public long sum() {
        void var2_2;
        if (((Ordered)this.elapsed.apply()).$greater$eq((Object)this.window)) {
            this.expired();
        }
        int _ = this.gen;
        long sum = this.writer.sum();
        for (int i = 0; i < this.N; ++i) {
            sum += this.buf[i];
        }
        return (long)var2_2;
    }

    public WindowedAdder(Duration range, int slices, Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
        Predef$.MODULE$.require(slices > 1);
        this.window = range.$div((long)slices);
        this.N = slices - 1;
        this.writer = new LongAdder();
        this.gen = 0;
        this.expiredGen = new AtomicInteger(this.gen);
        this.buf = new long[this.N];
        this.i = 0;
        this.elapsed = stopwatch.start();
    }
}

