/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.StreamingStatsFilter$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.ExceptionStatsHandler;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.io.Buf;
import com.twitter.io.Reader;
import com.twitter.util.Future;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ms!\u0002\r\u001a\u0011\u0003!c!\u0002\u0014\u001a\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002!\u0002#\u0003%\t!\u0011\u0004\u0005Me\u0001!\u000b\u0003\u0005W\u000b\t\u0005\t\u0015!\u0003X\u0011!aVA!A!\u0002\u0013i\u0006\u0002\u00031\u0006\u0005\u0003\u0005\u000b\u0011B\"\t\u000b9*A\u0011A1\t\r\u0019,\u0001\u0015!\u0003h\u0011\u0019\u0019X\u0001)A\u0005O\"1A/\u0002Q\u0001\n]Ca!^\u0003!\u0002\u00131\bBB=\u0006A\u0003%!\u0010\u0003\u0004~\u000b\u0001\u0006IA\u001f\u0005\u0007}\u0016\u0001\u000b\u0011B@\t\u000f\u0005\u0015Q\u0001)A\u0005/\"9\u0011qA\u0003!\u0002\u00131\bbBA\u0005\u000b\u0001\u0006IA\u001f\u0005\b\u0003\u0017)\u0001\u0015!\u0003{\u0011\u001d\ti!\u0002Q\u0001\n}Dq!a\u0004\u0006\t\u0003\t\t\u0002C\u0004\u0002,\u0015!I!!\f\u0002)M#(/Z1nS:<7\u000b^1ug\u001aKG\u000e^3s\u0015\tQ2$\u0001\u0004gS2$XM\u001d\u0006\u00039u\tA\u0001\u001b;ua*\u0011adH\u0001\bM&t\u0017m\u001a7f\u0015\t\u0001\u0013%A\u0004uo&$H/\u001a:\u000b\u0003\t\n1aY8n\u0007\u0001\u0001\"!J\u0001\u000e\u0003e\u0011Ac\u0015;sK\u0006l\u0017N\\4Ti\u0006$8OR5mi\u0016\u00148CA\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001J\u0001\u0007[>$W\u000f\\3\u0016\u0003I\u00022a\r\u001b7\u001b\u0005i\u0012BA\u001b\u001e\u0005%\u0019F/Y2lC\ndW\r\u0005\u00034oej\u0014B\u0001\u001d\u001e\u00059\u0019VM\u001d<jG\u00164\u0015m\u0019;pef\u0004\"AO\u001e\u000e\u0003mI!\u0001P\u000e\u0003\u000fI+\u0017/^3tiB\u0011!HP\u0005\u0003\u007fm\u0011\u0001BU3ta>t7/Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003\tS#aQ%\u0011\u0007%\"e)\u0003\u0002FU\tIa)\u001e8di&|g\u000e\r\t\u0003S\u001dK!\u0001\u0013\u0016\u0003\t1{gnZ\u0016\u0002\u0015B\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u0014\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002R\u0019\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0014\u0005\u0015\u0019\u0006\u0003B\u001aUsuJ!!V\u000f\u0003\u0019MKW\u000e\u001d7f\r&dG/\u001a:\u0002\u000bM$\u0018\r^:\u0011\u0005aSV\"A-\u000b\u0005Yk\u0012BA.Z\u00055\u0019F/\u0019;t%\u0016\u001cW-\u001b<fe\u0006)R\r_2faRLwN\\*uCR\u001c\b*\u00198eY\u0016\u0014\bC\u0001-_\u0013\ty\u0016LA\u000bFq\u000e,\u0007\u000f^5p]N#\u0018\r^:IC:$G.\u001a:\u0002\u00139|w/T5mY&\u001cH\u0003\u00022dI\u0016\u0004\"!J\u0003\t\u000bYK\u0001\u0019A,\t\u000bqK\u0001\u0019A/\t\u000f\u0001L\u0001\u0013!a\u0001\u0007\u0006Q\u0002/\u001a8eS:<'+Z9vKN$8\u000b\u001e:fC6\u001c8i\\;oiB\u0011\u0001.]\u0007\u0002S*\u0011!n[\u0001\u0007CR|W.[2\u000b\u00051l\u0017AC2p]\u000e,(O]3oi*\u0011an\\\u0001\u0005kRLGNC\u0001q\u0003\u0011Q\u0017M^1\n\u0005IL'!\u0003'p]\u001e\fE\rZ3s\u0003m\u0001XM\u001c3j]\u001e\u0014Vm\u001d9p]N,7\u000b\u001e:fC6\u001c8i\\;oi\u0006\t\"/Z9vKN$8\u000b\u001e:fC6\u001cF/\u0019;\u0002/I,\u0017/^3tiN#(/Z1n\tV\u0014\u0018\r^5p]6\u001b\bC\u0001-x\u0013\tA\u0018L\u0001\u0003Ti\u0006$\u0018aE8qK:,GMU3rk\u0016\u001cHo\u0015;sK\u0006l\u0007C\u0001-|\u0013\ta\u0018LA\u0004D_VtG/\u001a:\u0002'\rdwn]3e%\u0016\fX/Z:u'R\u0014X-Y7\u0002)A,g\u000eZ5oOJ+\u0017/^3tiN#(/Z1n!\rA\u0016\u0011A\u0005\u0004\u0003\u0007I&!B$bk\u001e,\u0017A\u0005:fgB|gn]3TiJ,\u0017-\\*uCR\f\u0001D]3ta>t7/Z*ue\u0016\fW\u000eR;sCRLwN\\'t\u0003Qy\u0007/\u001a8fIJ+7\u000f]8og\u0016\u001cFO]3b[\u0006!2\r\\8tK\u0012\u0014Vm\u001d9p]N,7\u000b\u001e:fC6\fQ\u0003]3oI&twMU3ta>t7/Z*ue\u0016\fW.A\u0003baBd\u0017\u0010\u0006\u0004\u0002\u0014\u0005u\u0011\u0011\u0005\t\u0006\u0003+\tI\"P\u0007\u0003\u0003/Q!A\\\u0010\n\t\u0005m\u0011q\u0003\u0002\u0007\rV$XO]3\t\r\u0005}a\u00031\u0001:\u0003\u001d\u0011X-];fgRDq!a\t\u0017\u0001\u0004\t)#A\u0004tKJ4\u0018nY3\u0011\u000bM\n9#O\u001f\n\u0007\u0005%RDA\u0004TKJ4\u0018nY3\u0002%U\u0004H-\u0019;f\u00072|7/\u001a3TiJ,\u0017-\u001c\u000b\r\u0003_\t)$a\u0013\u0002P\u0005M\u0013q\u000b\t\u0004S\u0005E\u0012bAA\u001aU\t!QK\\5u\u0011\u001d\t9d\u0006a\u0001\u0003s\taA]3bI\u0016\u0014\bCBA\u001e\u0003\u0003\n)%\u0004\u0002\u0002>)\u0019\u0011qH\u0010\u0002\u0005%|\u0017\u0002BA\"\u0003{\u0011aAU3bI\u0016\u0014\b\u0003BA\u001e\u0003\u000fJA!!\u0013\u0002>\t\u0019!)\u001e4\t\r\u00055s\u00031\u0001X\u00035\u0019H/\u0019;t%\u0016\u001cW-\u001b<fe\"1\u0011\u0011K\fA\u0002i\f1c\u00197pg\u0016$7\u000b\u001e:fC6\u001cu.\u001e8uKJDa!!\u0016\u0018\u0001\u00049\u0017A\u00059f]\u0012LgnZ*ue\u0016\fWnQ8v]RDa!!\u0017\u0018\u0001\u00041\u0018AE:ue\u0016\fW\u000eR;sCRLwN\\*uCR\u0004")
public class StreamingStatsFilter
extends SimpleFilter<Request, Response> {
    private final ExceptionStatsHandler exceptionStatsHandler;
    private final Function0<Object> nowMillis;
    private final LongAdder pendingRequestStreamsCount;
    private final LongAdder pendingResponseStreamsCount;
    private final StatsReceiver requestStreamStat;
    private final Stat requestStreamDurationMs;
    private final Counter openedRequestStream;
    private final Counter closedRequestStream;
    private final Gauge pendingRequestStream;
    private final StatsReceiver responseStreamStat;
    private final Stat responseStreamDurationMs;
    private final Counter openedResponseStream;
    private final Counter closedResponseStream;
    private final Gauge pendingResponseStream;

    public static Function0<Object> $lessinit$greater$default$3() {
        return StreamingStatsFilter$.MODULE$.$lessinit$greater$default$3();
    }

    public static Stackable<ServiceFactory<Request, Response>> module() {
        return StreamingStatsFilter$.MODULE$.module();
    }

    public Future<Response> apply(Request request, Service<Request, Response> service) {
        block0: {
            if (!request.isChunked()) break block0;
            this.openedRequestStream.incr();
            this.pendingRequestStreamsCount.increment();
            this.updateClosedStream((Reader<Buf>)request.reader(), this.requestStreamStat, this.closedRequestStream, this.pendingRequestStreamsCount, this.requestStreamDurationMs);
        }
        return service.apply((Object)request).respond((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StreamingStatsFilter.$anonfun$apply$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void updateClosedStream(Reader<Buf> reader, StatsReceiver statsReceiver, Counter closedStreamCounter, LongAdder pendingStreamCount, Stat streamDurationStat) {
        long streamingStart = this.nowMillis.apply$mcJ$sp();
        reader.onClose().respond((Function1 & Serializable & scala.Serializable)closeP -> {
            StreamingStatsFilter.$anonfun$updateClosedStream$1(this, closedStreamCounter, pendingStreamCount, streamDurationStat, streamingStart, statsReceiver, closeP);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(StreamingStatsFilter $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Return) {
            BoxedUnit boxedUnit;
            Return return_ = (Return)try_;
            Response response = (Response)return_.r();
            if (response.isChunked()) {
                $this.openedResponseStream.incr();
                $this.pendingResponseStreamsCount.increment();
                $this.updateClosedStream((Reader<Buf>)response.reader(), $this.responseStreamStat, $this.closedResponseStream, $this.pendingResponseStreamsCount, $this.responseStreamDurationMs);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$updateClosedStream$1(StreamingStatsFilter $this, Counter closedStreamCounter$1, LongAdder pendingStreamCount$1, Stat streamDurationStat$1, long streamingStart$1, StatsReceiver statsReceiver$1, Try closeP) {
        closedStreamCounter$1.incr();
        pendingStreamCount$1.decrement();
        long streamingEnd = $this.nowMillis.apply$mcJ$sp();
        streamDurationStat$1.add((float)(streamingEnd - streamingStart$1));
        Try try_ = closeP;
        if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable exception = throw_.e();
            $this.exceptionStatsHandler.record(statsReceiver$1, exception);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public StreamingStatsFilter(StatsReceiver stats, ExceptionStatsHandler exceptionStatsHandler, Function0<Object> nowMillis) {
        this.exceptionStatsHandler = exceptionStatsHandler;
        this.nowMillis = nowMillis;
        this.pendingRequestStreamsCount = new LongAdder();
        this.pendingResponseStreamsCount = new LongAdder();
        this.requestStreamStat = stats.scope((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stream", "request"}));
        this.requestStreamDurationMs = this.requestStreamStat.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"duration_ms"}));
        this.openedRequestStream = this.requestStreamStat.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"opened"}));
        this.closedRequestStream = this.requestStreamStat.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closed"}));
        this.pendingRequestStream = this.requestStreamStat.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pending"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> $this.pendingRequestStreamsCount.sum());
        this.responseStreamStat = stats.scope((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stream", "response"}));
        this.responseStreamDurationMs = this.responseStreamStat.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"duration_ms"}));
        this.openedResponseStream = this.responseStreamStat.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"opened"}));
        this.closedResponseStream = this.responseStreamStat.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closed"}));
        this.pendingResponseStream = this.responseStreamStat.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pending"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> $this.pendingResponseStreamsCount.sum());
    }
}

