package com.twitter.finagle.httpx

case class Status(code: Int)

object Status {
  val Continue = Status(100)
  val SwitchingProtocols = Status(101)
  val Processing = Status(102)
  val Ok = Status(200)
  val Created = Status(201)
  val Accepted = Status(202)
  val NonAuthoritativeInformation = Status(203)
  val NoContent = Status(204)
  val ResetContent = Status(205)
  val PartialContent = Status(206)
  val MultiStatus = Status(207)
  val MultipleChoices = Status(300)
  val MovedPermanently = Status(301)
  val Found = Status(302)
  val SeeOther = Status(303)
  val NotModified = Status(304)
  val UseProxy = Status(305)
  val TemporaryRedirect = Status(307)
  val BadRequest = Status(400)
  val Unauthorized = Status(401)
  val PaymentRequired = Status(402)
  val Forbidden = Status(403)
  val NotFound = Status(404)
  val MethodNotAllowed = Status(405)
  val NotAcceptable = Status(406)
  val ProxyAuthenticationRequired = Status(407)
  val RequestTimeout = Status(408)
  val Conflict = Status(409)
  val Gone = Status(410)
  val LengthRequired = Status(411)
  val PreconditionFailed = Status(412)
  val RequestEntityTooLarge = Status(413)
  val RequestURITooLong = Status(414)
  val UnsupportedMediaType = Status(415)
  val RequestedRangeNotSatisfiable = Status(416)
  val ExpectationFailed = Status(417)
  val UnprocessableEntity = Status(422)
  val Locked = Status(423)
  val FailedDependency = Status(424)
  val UnorderedCollection = Status(425)
  val UpgradeRequired = Status(426)
  val RequestHeaderFieldsTooLarge = Status(431)
  val ClientClosedRequest = Status(499)
  val InternalServerError = Status(500)
  val NotImplemented = Status(501)
  val BadGateway = Status(502)
  val ServiceUnavailable = Status(503)
  val GatewayTimeout = Status(504)
  val HttpVersionNotSupported = Status(505)
  val VariantAlsoNegotiates = Status(506)
  val InsufficientStorage = Status(507)
  val NotExtended = Status(510)

  def fromCode(n: Int) = n match {
    case 100 => Continue
    case 101 => SwitchingProtocols
    case 102 => Processing
    case 200 => Ok
    case 201 => Created
    case 202 => Accepted
    case 203 => NonAuthoritativeInformation
    case 204 => NoContent
    case 205 => ResetContent
    case 206 => PartialContent
    case 207 => MultiStatus
    case 300 => MultipleChoices
    case 301 => MovedPermanently
    case 302 => Found
    case 303 => SeeOther
    case 304 => NotModified
    case 305 => UseProxy
    case 307 => TemporaryRedirect
    case 400 => BadRequest
    case 401 => Unauthorized
    case 402 => PaymentRequired
    case 403 => Forbidden
    case 404 => NotFound
    case 405 => MethodNotAllowed
    case 406 => NotAcceptable
    case 407 => ProxyAuthenticationRequired
    case 408 => RequestTimeout
    case 409 => Conflict
    case 410 => Gone
    case 411 => LengthRequired
    case 412 => PreconditionFailed
    case 413 => RequestEntityTooLarge
    case 414 => RequestURITooLong
    case 415 => UnsupportedMediaType
    case 416 => RequestedRangeNotSatisfiable
    case 417 => ExpectationFailed
    case 422 => UnprocessableEntity
    case 423 => Locked
    case 424 => FailedDependency
    case 425 => UnorderedCollection
    case 426 => UpgradeRequired
    case 431 => RequestHeaderFieldsTooLarge
    case 499 => ClientClosedRequest
    case 500 => InternalServerError
    case 501 => NotImplemented
    case 502 => BadGateway
    case 503 => ServiceUnavailable
    case 504 => GatewayTimeout
    case 505 => HttpVersionNotSupported
    case 506 => VariantAlsoNegotiates
    case 507 => InsufficientStorage
    case 510 => NotExtended
    case _ => Status(n)
  }
}
