/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.exp.mysql.protocol;

import com.twitter.finagle.exp.mysql.ClientError;
import com.twitter.finagle.exp.mysql.protocol.Buffer$;
import com.twitter.finagle.exp.mysql.protocol.Buffer$CorruptBufferException$;
import com.twitter.finagle.exp.mysql.protocol.BufferReader;
import com.twitter.finagle.exp.mysql.protocol.Charset$;
import java.nio.charset.Charset;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class BufferReader$class {
    public static int capacity(BufferReader $this) {
        return Predef$.MODULE$.byteArrayOps($this.array()).size();
    }

    public static byte[] takeRest(BufferReader $this) {
        return $this.take($this.capacity() - $this.offset());
    }

    public static int readLengthCodedBinary(BufferReader $this) {
        int n;
        int firstByte = $this.readUnsignedByte();
        if (firstByte < 251) {
            n = firstByte;
        } else {
            int n2 = firstByte;
            switch (n2) {
                default: {
                    throw Buffer$CorruptBufferException$.MODULE$;
                }
                case 254: {
                    throw new ClientError("BufferReader: LONG_BLOB is not supported!");
                }
                case 253: {
                    n = $this.readUnsignedInt24();
                    break;
                }
                case 252: {
                    n = $this.readUnsignedShort();
                    break;
                }
                case 251: {
                    n = Buffer$.MODULE$.NULL_LENGTH();
                }
            }
        }
        return n;
    }

    public static String readNullTerminatedString(BufferReader $this, Charset charset) {
        int start = $this.offset();
        int length = 0;
        while ($this.readByte() != 0) {
            ++length;
        }
        return $this.toString(start, length, charset);
    }

    public static Charset readNullTerminatedString$default$1(BufferReader $this) {
        return Charset$.MODULE$.defaultCharset();
    }

    public static byte[] readNullTerminatedBytes(BufferReader $this) {
        Buffer cur = (Buffer)scala.collection.mutable.Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        do {
            cur.$plus$eq((Object)BoxesRunTime.boxToByte((byte)$this.readByte()));
        } while (BoxesRunTime.unboxToByte((Object)cur.last()) != 0);
        return (byte[])((TraversableOnce)cur.init()).toArray(ClassTag$.MODULE$.Byte());
    }

    public static String readLengthCodedString(BufferReader $this, Charset charset) {
        String string;
        int length = $this.readLengthCodedBinary();
        if (length == Buffer$.MODULE$.NULL_LENGTH()) {
            string = null;
        } else if (length == 0) {
            string = Buffer$.MODULE$.EMPTY_STRING();
        } else {
            int start = $this.offset();
            $this.skip(length);
            string = $this.toString(start, length, charset);
        }
        return string;
    }

    public static Charset readLengthCodedString$default$1(BufferReader $this) {
        return Charset$.MODULE$.defaultCharset();
    }

    public static byte[] readLengthCodedBytes(BufferReader $this) {
        int len = $this.readLengthCodedBinary();
        return len == Buffer$.MODULE$.NULL_LENGTH() ? null : (len == 0 ? Buffer$.MODULE$.EMPTY_BYTE_ARRAY() : $this.take(len));
    }

    public static String toString(BufferReader $this, int start, int length, Charset charset) {
        return new String($this.array(), start, length, charset);
    }

    public static void $init$(BufferReader $this) {
    }
}

