/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql;

import com.twitter.finagle.mysql.AuthInfo;
import com.twitter.finagle.mysql.AuthMoreDataFromServer;
import com.twitter.finagle.mysql.AuthNegotiation;
import com.twitter.finagle.mysql.AuthSwitchResponse;
import com.twitter.finagle.mysql.MysqlCharset$;
import com.twitter.finagle.mysql.NeedPublicKey$;
import com.twitter.finagle.mysql.PasswordAuthMoreDataToServer;
import com.twitter.finagle.mysql.PasswordUtils$;
import com.twitter.finagle.mysql.PerformFullAuth$;
import com.twitter.finagle.mysql.PlainAuthMoreDataToServer;
import java.nio.charset.StandardCharsets;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public final class AuthNegotiation$ {
    public static AuthNegotiation$ MODULE$;

    static {
        new AuthNegotiation$();
    }

    public AuthSwitchResponse com$twitter$finagle$mysql$AuthNegotiation$$makeAuthSwitchResponse(short seqNum, byte[] salt, AuthInfo authInfo) {
        return new AuthSwitchResponse(seqNum, this.getPasswordForSwitchResponse(authInfo), salt, authInfo.settings().charset(), true);
    }

    private Option<String> getPasswordForSwitchResponse(AuthInfo authInfo) {
        Some some = authInfo.settings().password();
        Some some2 = some instanceof Some && authInfo.settings().causeAuthCacheMiss() ? new Some((Object)"wrong-password") : (None$.MODULE$.equals(some) ? None$.MODULE$ : some);
        return some2;
    }

    public PasswordAuthMoreDataToServer com$twitter$finagle$mysql$AuthNegotiation$$makeAuthMoreDataWithServersSentRsaKey(AuthMoreDataFromServer authMoreData, AuthInfo authInfo) {
        Option<byte[]> option = authMoreData.authData();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new AuthNegotiation.NegotiationFailure("RSA public key is missing from the AuthMoreData packet sent from the server.");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        byte[] rsaKey = (byte[])some.value();
        PasswordAuthMoreDataToServer passwordAuthMoreDataToServer = this.com$twitter$finagle$mysql$AuthNegotiation$$makeAuthMoreDataWithRsaKeyEncryptedPassword(authMoreData, authInfo, new String(rsaKey, StandardCharsets.UTF_8));
        return passwordAuthMoreDataToServer;
    }

    public PasswordAuthMoreDataToServer com$twitter$finagle$mysql$AuthNegotiation$$makeAuthMoreDataWithPlaintextPassword(AuthMoreDataFromServer authMoreData, AuthInfo authInfo) {
        Option<String> option = authInfo.settings().password();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("Null passwords should complete authentication after sending the AuthSwitchResponse");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        String password = (String)some.value();
        byte[] passwordBytes = PasswordUtils$.MODULE$.addNullByteToPassword(password.getBytes(MysqlCharset$.MODULE$.apply(authInfo.settings().charset()).displayName()));
        PasswordAuthMoreDataToServer passwordAuthMoreDataToServer = new PasswordAuthMoreDataToServer((short)(authMoreData.seqNum() + 1), PerformFullAuth$.MODULE$, passwordBytes);
        return passwordAuthMoreDataToServer;
    }

    public PasswordAuthMoreDataToServer com$twitter$finagle$mysql$AuthNegotiation$$makeAuthMoreDataWithRsaKeyEncryptedPassword(AuthMoreDataFromServer authMoreData, AuthInfo authInfo, String rsaKey) {
        Option<String> option = authInfo.settings().password();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("Null passwords should complete authentication after sending the AuthSwitchResponse");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        String password = (String)some.value();
        PasswordAuthMoreDataToServer passwordAuthMoreDataToServer = new PasswordAuthMoreDataToServer((short)(authMoreData.seqNum() + 1), NeedPublicKey$.MODULE$, PasswordUtils$.MODULE$.encryptPasswordWithRsaPublicKey(password, rsaKey, authInfo.salt(), authInfo.settings().charset(), authInfo.serverVersion()));
        return passwordAuthMoreDataToServer;
    }

    public PlainAuthMoreDataToServer com$twitter$finagle$mysql$AuthNegotiation$$makePublicKeyRequestToServer(AuthMoreDataFromServer authMoreData) {
        return new PlainAuthMoreDataToServer((short)(authMoreData.seqNum() + 1), NeedPublicKey$.MODULE$);
    }

    private AuthNegotiation$() {
        MODULE$ = this;
    }
}

