/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql;

import com.twitter.finagle.mysql.BigIntTooLongException;
import com.twitter.finagle.mysql.BigIntValue;
import com.twitter.finagle.mysql.ByteValue;
import com.twitter.finagle.mysql.CanBeParameter;
import com.twitter.finagle.mysql.CanBeParameter$;
import com.twitter.finagle.mysql.DateValue$;
import com.twitter.finagle.mysql.DoubleValue;
import com.twitter.finagle.mysql.EmptyValue$;
import com.twitter.finagle.mysql.FloatValue;
import com.twitter.finagle.mysql.IntValue;
import com.twitter.finagle.mysql.LongValue;
import com.twitter.finagle.mysql.MysqlCharset$;
import com.twitter.finagle.mysql.NullValue$;
import com.twitter.finagle.mysql.RawValue;
import com.twitter.finagle.mysql.ShortValue;
import com.twitter.finagle.mysql.StringValue;
import com.twitter.finagle.mysql.TimestampValue$;
import com.twitter.finagle.mysql.Type$;
import com.twitter.finagle.mysql.Value;
import com.twitter.finagle.mysql.transport.MysqlBuf$;
import com.twitter.finagle.mysql.transport.MysqlBufWriter;
import com.twitter.util.Time;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Timestamp;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

public final class CanBeParameter$ {
    public static CanBeParameter$ MODULE$;
    private final CanBeParameter<String> stringCanBeParameter;
    private final CanBeParameter<Object> booleanCanBeParameter;
    private final CanBeParameter<Boolean> javaLangBooleanCanBeParameter;
    private final CanBeParameter<Object> byteCanBeParameter;
    private final CanBeParameter<Byte> javaLangByteCanBeParameter;
    private final CanBeParameter<Object> shortCanBeParameter;
    private final CanBeParameter<Short> javaLangShortCanBeParameter;
    private final CanBeParameter<Object> intCanBeParameter;
    private final CanBeParameter<Integer> javaLangIntCanBeParameter;
    private final CanBeParameter<Object> longCanBeParameter;
    private final CanBeParameter<Long> javaLangLongCanBeParameter;
    private final CanBeParameter<BigInt> bigIntCanBeParameter;
    private final CanBeParameter<Object> floatCanBeParameter;
    private final CanBeParameter<Float> javaLangFloatCanBeParameter;
    private final CanBeParameter<Object> doubleCanBeParameter;
    private final CanBeParameter<Double> javaLangDoubleCanBeParameter;
    private final CanBeParameter<BigDecimal> bigDecimalCanBeParameter;
    private final CanBeParameter<byte[]> byteArrayCanBeParameter;
    private final CanBeParameter<Value> valueCanBeParameter;
    private final CanBeParameter<java.util.Date> dateCanBeParameter;
    private final CanBeParameter<Time> ctuTimeCanBeParameter;
    private final CanBeParameter<Null$> nullCanBeParameter;

    static {
        new CanBeParameter$();
    }

    public int com$twitter$finagle$mysql$CanBeParameter$$arrayLength(byte[] bytes) {
        return MysqlBuf$.MODULE$.sizeOfLen(bytes.length) + bytes.length;
    }

    public CanBeParameter<String> stringCanBeParameter() {
        return this.stringCanBeParameter;
    }

    public CanBeParameter<Object> booleanCanBeParameter() {
        return this.booleanCanBeParameter;
    }

    public CanBeParameter<Boolean> javaLangBooleanCanBeParameter() {
        return this.javaLangBooleanCanBeParameter;
    }

    public CanBeParameter<Object> byteCanBeParameter() {
        return this.byteCanBeParameter;
    }

    public CanBeParameter<Byte> javaLangByteCanBeParameter() {
        return this.javaLangByteCanBeParameter;
    }

    public CanBeParameter<Object> shortCanBeParameter() {
        return this.shortCanBeParameter;
    }

    public CanBeParameter<Short> javaLangShortCanBeParameter() {
        return this.javaLangShortCanBeParameter;
    }

    public CanBeParameter<Object> intCanBeParameter() {
        return this.intCanBeParameter;
    }

    public CanBeParameter<Integer> javaLangIntCanBeParameter() {
        return this.javaLangIntCanBeParameter;
    }

    public CanBeParameter<Object> longCanBeParameter() {
        return this.longCanBeParameter;
    }

    public CanBeParameter<Long> javaLangLongCanBeParameter() {
        return this.javaLangLongCanBeParameter;
    }

    public CanBeParameter<BigInt> bigIntCanBeParameter() {
        return this.bigIntCanBeParameter;
    }

    public CanBeParameter<Object> floatCanBeParameter() {
        return this.floatCanBeParameter;
    }

    public CanBeParameter<Float> javaLangFloatCanBeParameter() {
        return this.javaLangFloatCanBeParameter;
    }

    public CanBeParameter<Object> doubleCanBeParameter() {
        return this.doubleCanBeParameter;
    }

    public CanBeParameter<Double> javaLangDoubleCanBeParameter() {
        return this.javaLangDoubleCanBeParameter;
    }

    public CanBeParameter<BigDecimal> bigDecimalCanBeParameter() {
        return this.bigDecimalCanBeParameter;
    }

    public CanBeParameter<byte[]> byteArrayCanBeParameter() {
        return this.byteArrayCanBeParameter;
    }

    public CanBeParameter<Value> valueCanBeParameter() {
        return this.valueCanBeParameter;
    }

    public CanBeParameter<java.util.Date> dateCanBeParameter() {
        return this.dateCanBeParameter;
    }

    public CanBeParameter<Time> ctuTimeCanBeParameter() {
        return this.ctuTimeCanBeParameter;
    }

    public CanBeParameter<Null$> nullCanBeParameter() {
        return this.nullCanBeParameter;
    }

    private CanBeParameter$() {
        MODULE$ = this;
        this.stringCanBeParameter = new CanBeParameter<String>(){

            public int sizeOf(String param) {
                byte[] bytes = param.getBytes(MysqlCharset$.MODULE$.defaultCharset());
                return CanBeParameter$.MODULE$.com$twitter$finagle$mysql$CanBeParameter$$arrayLength(bytes);
            }

            public short typeCode(String param) {
                return Type$.MODULE$.VarChar();
            }

            public void write(MysqlBufWriter writer, String param) {
                writer.writeLengthCodedString(param, MysqlCharset$.MODULE$.defaultCharset());
            }
        };
        this.booleanCanBeParameter = new CanBeParameter<Object>(){

            public int sizeOf(boolean param) {
                return 1;
            }

            public short typeCode(boolean param) {
                return Type$.MODULE$.Tiny();
            }

            public void write(MysqlBufWriter writer, boolean param) {
                writer.writeByte(param ? 1 : 0);
            }
        };
        this.javaLangBooleanCanBeParameter = new CanBeParameter<Boolean>(){

            public int sizeOf(Boolean param) {
                return CanBeParameter$.MODULE$.booleanCanBeParameter().sizeOf(BoxesRunTime.boxToBoolean((boolean)param));
            }

            public short typeCode(Boolean param) {
                return CanBeParameter$.MODULE$.booleanCanBeParameter().typeCode(BoxesRunTime.boxToBoolean((boolean)param));
            }

            public void write(MysqlBufWriter writer, Boolean param) {
                CanBeParameter$.MODULE$.booleanCanBeParameter().write(writer, BoxesRunTime.boxToBoolean((boolean)param));
            }
        };
        this.byteCanBeParameter = new CanBeParameter<Object>(){

            public int sizeOf(byte param) {
                return 1;
            }

            public short typeCode(byte param) {
                return Type$.MODULE$.Tiny();
            }

            public void write(MysqlBufWriter writer, byte param) {
                writer.writeByte(param);
            }
        };
        this.javaLangByteCanBeParameter = new CanBeParameter<Byte>(){

            public int sizeOf(Byte param) {
                return CanBeParameter$.MODULE$.byteCanBeParameter().sizeOf(BoxesRunTime.boxToByte((byte)param));
            }

            public short typeCode(Byte param) {
                return CanBeParameter$.MODULE$.byteCanBeParameter().typeCode(BoxesRunTime.boxToByte((byte)param));
            }

            public void write(MysqlBufWriter writer, Byte param) {
                CanBeParameter$.MODULE$.byteCanBeParameter().write(writer, BoxesRunTime.boxToByte((byte)param));
            }
        };
        this.shortCanBeParameter = new CanBeParameter<Object>(){

            public int sizeOf(short param) {
                return 2;
            }

            public short typeCode(short param) {
                return Type$.MODULE$.Short();
            }

            public void write(MysqlBufWriter writer, short param) {
                writer.writeShortLE(param);
            }
        };
        this.javaLangShortCanBeParameter = new CanBeParameter<Short>(){

            public int sizeOf(Short param) {
                return CanBeParameter$.MODULE$.shortCanBeParameter().sizeOf(BoxesRunTime.boxToShort((short)param));
            }

            public short typeCode(Short param) {
                return CanBeParameter$.MODULE$.shortCanBeParameter().typeCode(BoxesRunTime.boxToShort((short)param));
            }

            public void write(MysqlBufWriter writer, Short param) {
                CanBeParameter$.MODULE$.shortCanBeParameter().write(writer, BoxesRunTime.boxToShort((short)param));
            }
        };
        this.intCanBeParameter = new CanBeParameter<Object>(){

            public int sizeOf(int param) {
                return 4;
            }

            public short typeCode(int param) {
                return Type$.MODULE$.Long();
            }

            public void write(MysqlBufWriter writer, int param) {
                writer.writeIntLE(param);
            }
        };
        this.javaLangIntCanBeParameter = new CanBeParameter<Integer>(){

            public int sizeOf(Integer param) {
                return CanBeParameter$.MODULE$.intCanBeParameter().sizeOf(BoxesRunTime.boxToInteger((int)param));
            }

            public short typeCode(Integer param) {
                return CanBeParameter$.MODULE$.intCanBeParameter().typeCode(BoxesRunTime.boxToInteger((int)param));
            }

            public void write(MysqlBufWriter writer, Integer param) {
                CanBeParameter$.MODULE$.intCanBeParameter().write(writer, BoxesRunTime.boxToInteger((int)param));
            }
        };
        this.longCanBeParameter = new CanBeParameter<Object>(){

            public int sizeOf(long param) {
                return 8;
            }

            public short typeCode(long param) {
                return Type$.MODULE$.LongLong();
            }

            public void write(MysqlBufWriter writer, long param) {
                writer.writeLongLE(param);
            }
        };
        this.javaLangLongCanBeParameter = new CanBeParameter<Long>(){

            public int sizeOf(Long param) {
                return CanBeParameter$.MODULE$.longCanBeParameter().sizeOf(BoxesRunTime.boxToLong((long)param));
            }

            public short typeCode(Long param) {
                return CanBeParameter$.MODULE$.longCanBeParameter().typeCode(BoxesRunTime.boxToLong((long)param));
            }

            public void write(MysqlBufWriter writer, Long param) {
                CanBeParameter$.MODULE$.longCanBeParameter().write(writer, BoxesRunTime.boxToLong((long)param));
            }
        };
        this.bigIntCanBeParameter = new CanBeParameter<BigInt>(){

            public int sizeOf(BigInt param) {
                return 8;
            }

            public short typeCode(BigInt param) {
                return Type$.MODULE$.LongLong();
            }

            public void write(MysqlBufWriter writer, BigInt param) {
                byte[] byteArray = param.toByteArray();
                int lengthOfByteArray = byteArray.length;
                if (lengthOfByteArray > 8) {
                    throw new BigIntTooLongException(lengthOfByteArray);
                }
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(lengthOfByteArray - 1), 0).by(-1).foreach((Function1 & Serializable & scala.Serializable)i -> anon.12.$anonfun$write$1(writer, byteArray, BoxesRunTime.unboxToInt((Object)i)));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(lengthOfByteArray), 8).foreach((Function1 & Serializable & scala.Serializable)i -> anon.12.$anonfun$write$2(writer, BoxesRunTime.unboxToInt((Object)i)));
            }

            public static final /* synthetic */ MysqlBufWriter $anonfun$write$1(MysqlBufWriter writer$1, byte[] byteArray$1, int i) {
                return (MysqlBufWriter)writer$1.writeByte(byteArray$1[i]);
            }

            public static final /* synthetic */ MysqlBufWriter $anonfun$write$2(MysqlBufWriter writer$1, int i) {
                return (MysqlBufWriter)writer$1.writeByte(0);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$write$1$adapted(com.twitter.finagle.mysql.transport.MysqlBufWriter byte[] java.lang.Object ), $anonfun$write$2$adapted(com.twitter.finagle.mysql.transport.MysqlBufWriter java.lang.Object )}, serializedLambda);
            }
        };
        this.floatCanBeParameter = new CanBeParameter<Object>(){

            public int sizeOf(float param) {
                return 4;
            }

            public short typeCode(float param) {
                return Type$.MODULE$.Float();
            }

            public void write(MysqlBufWriter writer, float param) {
                writer.writeFloatLE(param);
            }
        };
        this.javaLangFloatCanBeParameter = new CanBeParameter<Float>(){

            public int sizeOf(Float param) {
                return CanBeParameter$.MODULE$.floatCanBeParameter().sizeOf(BoxesRunTime.boxToFloat((float)param.floatValue()));
            }

            public short typeCode(Float param) {
                return CanBeParameter$.MODULE$.floatCanBeParameter().typeCode(BoxesRunTime.boxToFloat((float)param.floatValue()));
            }

            public void write(MysqlBufWriter writer, Float param) {
                CanBeParameter$.MODULE$.floatCanBeParameter().write(writer, BoxesRunTime.boxToFloat((float)param.floatValue()));
            }
        };
        this.doubleCanBeParameter = new CanBeParameter<Object>(){

            public int sizeOf(double param) {
                return 8;
            }

            public short typeCode(double param) {
                return Type$.MODULE$.Double();
            }

            public void write(MysqlBufWriter writer, double param) {
                writer.writeDoubleLE(param);
            }
        };
        this.javaLangDoubleCanBeParameter = new CanBeParameter<Double>(){

            public int sizeOf(Double param) {
                return CanBeParameter$.MODULE$.doubleCanBeParameter().sizeOf(BoxesRunTime.boxToDouble((double)param));
            }

            public short typeCode(Double param) {
                return CanBeParameter$.MODULE$.doubleCanBeParameter().typeCode(BoxesRunTime.boxToDouble((double)param));
            }

            public void write(MysqlBufWriter writer, Double param) {
                CanBeParameter$.MODULE$.doubleCanBeParameter().write(writer, BoxesRunTime.boxToDouble((double)param));
            }
        };
        this.bigDecimalCanBeParameter = new CanBeParameter<BigDecimal>(){
            private final Charset binaryCharset;

            private byte[] asBytes(BigDecimal bd) {
                return bd.toString().getBytes(this.binaryCharset);
            }

            public int sizeOf(BigDecimal param) {
                return CanBeParameter$.MODULE$.com$twitter$finagle$mysql$CanBeParameter$$arrayLength(this.asBytes(param));
            }

            public short typeCode(BigDecimal param) {
                return Type$.MODULE$.NewDecimal();
            }

            public void write(MysqlBufWriter writer, BigDecimal param) {
                writer.writeLengthCodedBytes(this.asBytes(param));
            }
            {
                this.binaryCharset = MysqlCharset$.MODULE$.apply(MysqlCharset$.MODULE$.Binary());
            }
        };
        this.byteArrayCanBeParameter = new CanBeParameter<byte[]>(){

            public int sizeOf(byte[] param) {
                return CanBeParameter$.MODULE$.com$twitter$finagle$mysql$CanBeParameter$$arrayLength(param);
            }

            public short typeCode(byte[] param) {
                return (short)(param.length <= 255 ? Type$.MODULE$.TinyBlob() : (int)(param.length <= 65535 ? Type$.MODULE$.Blob() : (param.length <= 0xFFFFFF ? (int)Type$.MODULE$.MediumBlob() : -1)));
            }

            public void write(MysqlBufWriter writer, byte[] param) {
                writer.writeLengthCodedBytes(param);
            }
        };
        this.valueCanBeParameter = new CanBeParameter<Value>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public int sizeOf(Value param) {
                Value value = param;
                if (value instanceof RawValue) {
                    RawValue rawValue = (RawValue)value;
                    boolean bl = rawValue.isBinary();
                    byte[] b = rawValue.bytes();
                    if (bl) {
                        return CanBeParameter$.MODULE$.com$twitter$finagle$mysql$CanBeParameter$$arrayLength(b);
                    }
                }
                if (value instanceof StringValue) {
                    StringValue stringValue = (StringValue)value;
                    String s = stringValue.s();
                    byte[] bytes = s.getBytes(MysqlCharset$.MODULE$.defaultCharset());
                    return CanBeParameter$.MODULE$.com$twitter$finagle$mysql$CanBeParameter$$arrayLength(bytes);
                }
                if (value instanceof ByteValue) {
                    return 1;
                }
                if (value instanceof ShortValue) {
                    return 2;
                }
                if (value instanceof IntValue) {
                    return 4;
                }
                if (value instanceof LongValue) {
                    return 8;
                }
                if (value instanceof BigIntValue) {
                    return 8;
                }
                if (value instanceof FloatValue) {
                    return 4;
                }
                if (value instanceof DoubleValue) {
                    return 8;
                }
                if (!NullValue$.MODULE$.equals(value)) throw new IllegalArgumentException(new StringBuilder(26).append("Cannot determine size of ").append(param).append(".").toString());
                return 0;
            }

            public short typeCode(Value param) {
                int n;
                Value value = param;
                if (value instanceof RawValue) {
                    int typ;
                    RawValue rawValue = (RawValue)value;
                    n = typ = rawValue.typ();
                } else if (value instanceof StringValue) {
                    n = Type$.MODULE$.VarChar();
                } else if (value instanceof ByteValue) {
                    n = Type$.MODULE$.Tiny();
                } else if (value instanceof ShortValue) {
                    n = Type$.MODULE$.Short();
                } else if (value instanceof IntValue) {
                    n = Type$.MODULE$.Long();
                } else if (value instanceof LongValue) {
                    n = Type$.MODULE$.LongLong();
                } else if (value instanceof BigIntValue) {
                    n = Type$.MODULE$.LongLong();
                } else if (value instanceof FloatValue) {
                    n = Type$.MODULE$.Float();
                } else if (value instanceof DoubleValue) {
                    n = Type$.MODULE$.Double();
                } else if (EmptyValue$.MODULE$.equals(value)) {
                    n = -1;
                } else if (NullValue$.MODULE$.equals(value)) {
                    n = Type$.MODULE$.Null();
                } else {
                    throw new MatchError((Object)value);
                }
                return (short)n;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void write(MysqlBufWriter writer, Value param) {
                Value value = param;
                if (value instanceof RawValue) {
                    RawValue rawValue = (RawValue)value;
                    boolean bl = rawValue.isBinary();
                    byte[] bytes = rawValue.bytes();
                    if (bl) {
                        writer.writeLengthCodedBytes(bytes);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                if (value instanceof ByteValue) {
                    ByteValue byteValue = (ByteValue)value;
                    byte b = byteValue.b();
                    writer.writeByte(b);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (value instanceof ShortValue) {
                    ShortValue shortValue = (ShortValue)value;
                    short s = shortValue.s();
                    writer.writeShortLE(s);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (value instanceof IntValue) {
                    IntValue intValue = (IntValue)value;
                    int i = intValue.i();
                    writer.writeIntLE(i);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (value instanceof LongValue) {
                    LongValue longValue = (LongValue)value;
                    long l = longValue.l();
                    writer.writeLongLE(l);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (value instanceof BigIntValue) {
                    BigIntValue bigIntValue = (BigIntValue)value;
                    BigInt b = bigIntValue.bi();
                    CanBeParameter$.MODULE$.bigIntCanBeParameter().write(writer, b);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (value instanceof FloatValue) {
                    FloatValue floatValue = (FloatValue)value;
                    float f = floatValue.f();
                    writer.writeFloatLE(f);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (value instanceof DoubleValue) {
                    DoubleValue doubleValue = (DoubleValue)value;
                    double d = doubleValue.d();
                    writer.writeDoubleLE(d);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (!(value instanceof StringValue)) throw new IllegalArgumentException(new StringBuilder(43).append("Type ").append(param).append(" is not supported, cannot write value.").toString());
                StringValue stringValue = (StringValue)value;
                String s = stringValue.s();
                writer.writeLengthCodedString(s, MysqlCharset$.MODULE$.defaultCharset());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        };
        this.dateCanBeParameter = new CanBeParameter<java.util.Date>(){

            public int sizeOf(java.util.Date param) {
                java.util.Date date = param;
                int n = date instanceof Date ? 5 : (date instanceof Timestamp ? 12 : 12);
                return n;
            }

            public short typeCode(java.util.Date param) {
                java.util.Date date = param;
                short s = date instanceof Date ? Type$.MODULE$.Date() : (date instanceof Timestamp ? Type$.MODULE$.Timestamp() : Type$.MODULE$.DateTime());
                return s;
            }

            public void write(MysqlBufWriter writer, java.util.Date param) {
                java.util.Date date = param;
                if (date instanceof Date) {
                    Date date2 = (Date)date;
                    CanBeParameter$.MODULE$.valueCanBeParameter().write(writer, DateValue$.MODULE$.apply(date2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (date instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)date;
                    CanBeParameter$.MODULE$.valueCanBeParameter().write(writer, TimestampValue$.MODULE$.apply(timestamp));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    CanBeParameter$.MODULE$.valueCanBeParameter().write(writer, TimestampValue$.MODULE$.apply(new Timestamp(date.getTime())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        };
        this.ctuTimeCanBeParameter = new CanBeParameter<Time>(){

            public int sizeOf(Time param) {
                return 12;
            }

            public short typeCode(Time param) {
                return Type$.MODULE$.Timestamp();
            }

            public void write(MysqlBufWriter writer, Time param) {
                CanBeParameter$.MODULE$.valueCanBeParameter().write(writer, TimestampValue$.MODULE$.apply(new Timestamp(param.inMillis())));
            }
        };
        this.nullCanBeParameter = new CanBeParameter<Null$>(){

            public int sizeOf(Null$ param) {
                return 0;
            }

            public short typeCode(Null$ param) {
                return Type$.MODULE$.Null();
            }

            public void write(MysqlBufWriter writer, Null$ param) {
            }
        };
    }
}

