/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql;

import com.twitter.finagle.mysql.Capability;
import com.twitter.finagle.mysql.Capability$;
import com.twitter.finagle.mysql.Decoder;
import com.twitter.finagle.mysql.HandshakeInit;
import com.twitter.finagle.mysql.MysqlCharset$;
import com.twitter.finagle.mysql.transport.MysqlBuf$;
import com.twitter.finagle.mysql.transport.MysqlBufReader;
import com.twitter.finagle.mysql.transport.Packet;
import com.twitter.finagle.mysql.transport.Packet$;
import com.twitter.io.Buf;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HandshakeInit$
implements Decoder<HandshakeInit>,
scala.Serializable {
    public static HandshakeInit$ MODULE$;

    static {
        new HandshakeInit$();
    }

    @Override
    public Try<HandshakeInit> apply(Packet packet) {
        return Decoder.apply$(this, packet);
    }

    public boolean apply$mcZD$sp(double v1) {
        return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
    }

    public double apply$mcDD$sp(double v1) {
        return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
    }

    public float apply$mcFD$sp(double v1) {
        return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
    }

    public int apply$mcID$sp(double v1) {
        return Function1.apply$mcID$sp$((Function1)this, (double)v1);
    }

    public long apply$mcJD$sp(double v1) {
        return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
    }

    public void apply$mcVD$sp(double v1) {
        Function1.apply$mcVD$sp$((Function1)this, (double)v1);
    }

    public boolean apply$mcZF$sp(float v1) {
        return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
    }

    public double apply$mcDF$sp(float v1) {
        return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
    }

    public float apply$mcFF$sp(float v1) {
        return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
    }

    public int apply$mcIF$sp(float v1) {
        return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
    }

    public long apply$mcJF$sp(float v1) {
        return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
    }

    public void apply$mcVF$sp(float v1) {
        Function1.apply$mcVF$sp$((Function1)this, (float)v1);
    }

    public boolean apply$mcZI$sp(int v1) {
        return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
    }

    public double apply$mcDI$sp(int v1) {
        return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
    }

    public float apply$mcFI$sp(int v1) {
        return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
    }

    public int apply$mcII$sp(int v1) {
        return Function1.apply$mcII$sp$((Function1)this, (int)v1);
    }

    public long apply$mcJI$sp(int v1) {
        return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
    }

    public void apply$mcVI$sp(int v1) {
        Function1.apply$mcVI$sp$((Function1)this, (int)v1);
    }

    public boolean apply$mcZJ$sp(long v1) {
        return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
    }

    public double apply$mcDJ$sp(long v1) {
        return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
    }

    public float apply$mcFJ$sp(long v1) {
        return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
    }

    public int apply$mcIJ$sp(long v1) {
        return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
    }

    public long apply$mcJJ$sp(long v1) {
        return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
    }

    public void apply$mcVJ$sp(long v1) {
        Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
    }

    public <A> Function1<A, Try<HandshakeInit>> compose(Function1<A, Packet> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A> Function1<Packet, A> andThen(Function1<Try<HandshakeInit>, A> g) {
        return Function1.andThen$((Function1)this, g);
    }

    public String toString() {
        return Function1.toString$((Function1)this);
    }

    @Override
    public HandshakeInit decode(Packet packet) {
        HandshakeInit handshakeInit;
        try (MysqlBufReader br = MysqlBuf$.MODULE$.reader(packet.body());){
            HandshakeInit handshakeInit2;
            byte by = br.readByte();
            if (Packet$.MODULE$.ErrorByte() == by) {
                short code = br.readShortLE();
                throw new Exception(new StringBuilder(41).append("Exception in MySQL handshake, error code ").append(code).toString());
            }
            byte[] bytesVersion = br.readNullTerminatedBytes();
            int threadId = br.readIntLE();
            byte[] salt1 = Buf.ByteArray$.Owned$.MODULE$.extract(br.readBytes(8));
            br.skip(1);
            int capLow = br.remaining() >= 2 ? br.readUnsignedShortLE() : 0;
            Predef$.MODULE$.require(by == 10 && (capLow & Capability$.MODULE$.Protocol41()) != 0, (Function0 & Serializable & scala.Serializable)() -> "unsupported protocol version");
            short charset = br.readUnsignedByte();
            short status = br.readShortLE();
            int capHigh = br.readUnsignedShortLE() << 16;
            Capability serverCap = Capability$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{capHigh, capLow}));
            boolean hasPluginAuthCap = serverCap.has(Capability$.MODULE$.PluginAuth());
            short authPluginDataLen = br.readUnsignedByte();
            br.readBytes(10);
            byte[] salt2 = hasPluginAuthCap && authPluginDataLen != 0 ? br.readNullTerminatedBytes() : (!serverCap.has(Capability$.MODULE$.SecureConnection()) ? (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()) : br.readNullTerminatedBytes());
            handshakeInit = handshakeInit2 = new HandshakeInit(by, new String(bytesVersion, MysqlCharset$.MODULE$.apply(charset)), threadId, (byte[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{salt1, salt2}), ClassTag$.MODULE$.Byte()), serverCap, charset, status);
        }
        return handshakeInit;
    }

    public HandshakeInit apply(byte protocol, String version, int threadId, byte[] salt, Capability serverCapabilities, short charset, short status) {
        return new HandshakeInit(protocol, version, threadId, salt, serverCapabilities, charset, status);
    }

    public Option<Tuple7<Object, String, Object, byte[], Capability, Object, Object>> unapply(HandshakeInit x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)BoxesRunTime.boxToByte((byte)x$0.protocol()), (Object)x$0.version(), (Object)BoxesRunTime.boxToInteger((int)x$0.threadId()), (Object)x$0.salt(), (Object)x$0.serverCapabilities(), (Object)BoxesRunTime.boxToShort((short)x$0.charset()), (Object)BoxesRunTime.boxToShort((short)x$0.status())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HandshakeInit$() {
        MODULE$ = this;
        Function1.$init$((Function1)this);
        Decoder.$init$(this);
    }
}

