/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql;

import com.twitter.finagle.mysql.Capability;
import com.twitter.finagle.mysql.Capability$;
import com.twitter.finagle.mysql.PasswordUtils$;
import com.twitter.finagle.mysql.ProtocolMessage;
import com.twitter.finagle.mysql.transport.MysqlBuf$;
import com.twitter.finagle.mysql.transport.MysqlBufWriter;
import com.twitter.finagle.mysql.transport.Packet;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00194a!\u0004\b\u0002\"91\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011E\u0002!\u0011!Q\u0001\n\rB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u00035\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011\u001d\u0003!\u0011!Q\u0001\n!CQa\u0013\u0001\u0005\u00021C\u0001b\u0016\u0001\t\u0006\u0004%\t\u0001\u0017\u0005\u00063\u0002!\tA\u0017\u0002\u0012\u0011\u0006tGm\u001d5bW\u0016\u0014Vm\u001d9p]N,'BA\b\u0011\u0003\u0015i\u0017p]9m\u0015\t\t\"#A\u0004gS:\fw\r\\3\u000b\u0005M!\u0012a\u0002;xSR$XM\u001d\u0006\u0002+\u0005\u00191m\\7\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011AD\u0005\u0003A9\u0011q\u0002\u0015:pi>\u001cw\u000e\\'fgN\fw-Z\u0001\tkN,'O\\1nK\u000e\u0001\u0001c\u0001\r%M%\u0011Q%\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001drcB\u0001\u0015-!\tI\u0013$D\u0001+\u0015\tY#%\u0001\u0004=e>|GOP\u0005\u0003[e\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q&G\u0001\ta\u0006\u001c8o^8sI\u0006AA-\u0019;bE\u0006\u001cX-\u0001\ndY&,g\u000e^\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\bC\u0001\u00106\u0013\t1dB\u0001\u0006DCB\f'-\u001b7jif\fAa]1miB\u0019\u0001$O\u001e\n\u0005iJ\"!B!se\u0006L\bC\u0001\r=\u0013\ti\u0014D\u0001\u0003CsR,\u0017AE:feZ,'oQ1qC\nLG.\u001b;jKN\fqa\u00195beN,G\u000f\u0005\u0002\u0019\u0003&\u0011!)\u0007\u0002\u0006'\"|'\u000f^\u0001\u000e[\u0006D\b+Y2lKR\u001c\u0016N_3\u0011\u0005a)\u0015B\u0001$\u001a\u0005\rIe\u000e^\u0001\u001eK:\f'\r\\3DC\u000eD\u0017N\\4TQ\u0006\u0014\u0004+Y:to>\u0014H-Q;uQB\u0011\u0001$S\u0005\u0003\u0015f\u0011qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u000b\u001b:{\u0005+\u0015*T)V3\u0006C\u0001\u0010\u0001\u0011\u0015\t#\u00021\u0001$\u0011\u0015\t$\u00021\u0001$\u0011\u0015\u0011$\u00021\u0001$\u0011\u0015\u0019$\u00021\u00015\u0011\u00159$\u00021\u00019\u0011\u0015q$\u00021\u00015\u0011\u0015y$\u00021\u0001A\u0011\u0015\u0019%\u00021\u0001E\u0011\u00159%\u00021\u0001I\u00031A\u0017m\u001d5QCN\u001cxo\u001c:e+\u0005A\u0014\u0001\u0003;p!\u0006\u001c7.\u001a;\u0016\u0003m\u0003\"\u0001X0\u000e\u0003uS!A\u0018\b\u0002\u0013Q\u0014\u0018M\\:q_J$\u0018B\u00011^\u0005\u0019\u0001\u0016mY6fi&\u001a\u0001A\u00193\n\u0005\rt!A\u0006)mC&t\u0007*\u00198eg\"\f7.\u001a*fgB|gn]3\n\u0005\u0015t!aF*fGV\u0014X\rS1oIND\u0017m[3SKN\u0004xN\\:f\u0001")
public abstract class HandshakeResponse
implements ProtocolMessage {
    private byte[] hashPassword;
    private final Option<String> username;
    private final Option<String> password;
    private final Option<String> database;
    private final Capability clientCapabilities;
    private final byte[] salt;
    private final Capability serverCapabilities;
    private final short charset;
    private final int maxPacketSize;
    private final boolean enableCachingSha2PasswordAuth;
    private volatile boolean bitmap$0;

    private byte[] hashPassword$lzycompute() {
        HandshakeResponse handshakeResponse = this;
        synchronized (handshakeResponse) {
            if (!this.bitmap$0) {
                byte[] byArray;
                Option<String> option = this.password;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String pword = (String)some.value();
                    byArray = this.enableCachingSha2PasswordAuth ? PasswordUtils$.MODULE$.encryptPasswordWithSha256(pword, this.salt, this.charset) : PasswordUtils$.MODULE$.encryptPasswordWithSha1(pword, this.salt, this.charset);
                } else if (None$.MODULE$.equals(option)) {
                    byArray = Array$.MODULE$.emptyByteArray();
                } else {
                    throw new MatchError(option);
                }
                this.hashPassword = byArray;
                this.bitmap$0 = true;
            }
        }
        return this.hashPassword;
    }

    public byte[] hashPassword() {
        return !this.bitmap$0 ? this.hashPassword$lzycompute() : this.hashPassword;
    }

    @Override
    public Packet toPacket() {
        int fixedBodySize = 34;
        int dbStrSize = BoxesRunTime.unboxToInt((Object)this.database.map((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)HandshakeResponse.$anonfun$toPacket$1(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
        int packetBodySize = ((String)this.username.getOrElse((Function0 & java.io.Serializable & Serializable)() -> "")).length() + this.hashPassword().length + dbStrSize + fixedBodySize;
        MysqlBufWriter bw = MysqlBuf$.MODULE$.writer(new byte[packetBodySize]);
        bw.writeIntLE(this.clientCapabilities.mask());
        bw.writeIntLE(this.maxPacketSize);
        bw.writeByte(this.charset);
        bw.fill(23, (byte)0);
        bw.writeNullTerminatedString((String)this.username.getOrElse((Function0 & java.io.Serializable & Serializable)() -> ""));
        bw.writeLengthCodedBytes(this.hashPassword());
        Object object = this.clientCapabilities.has(Capability$.MODULE$.ConnectWithDB()) && this.serverCapabilities.has(Capability$.MODULE$.ConnectWithDB()) ? bw.writeNullTerminatedString((String)this.database.get()) : BoxedUnit.UNIT;
        return new Packet(this.seq(), bw.owned());
    }

    public static final /* synthetic */ int $anonfun$toPacket$1(String x$1) {
        return x$1.length() + 1;
    }

    public HandshakeResponse(Option<String> username, Option<String> password, Option<String> database, Capability clientCapabilities, byte[] salt, Capability serverCapabilities, short charset, int maxPacketSize, boolean enableCachingSha2PasswordAuth) {
        this.username = username;
        this.password = password;
        this.database = database;
        this.clientCapabilities = clientCapabilities;
        this.salt = salt;
        this.serverCapabilities = serverCapabilities;
        this.charset = charset;
        this.maxPacketSize = maxPacketSize;
        this.enableCachingSha2PasswordAuth = enableCachingSha2PasswordAuth;
    }
}

