/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql;

import com.twitter.finagle.mysql.FailedToEncryptPasswordException;
import com.twitter.finagle.mysql.MysqlCharset$;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class PasswordUtils$ {
    public static PasswordUtils$ MODULE$;

    static {
        new PasswordUtils$();
    }

    public byte[] encryptPasswordWithSha1(String password, byte[] salt, short charset) {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] hash1 = md.digest(password.getBytes(MysqlCharset$.MODULE$.apply(charset).displayName()));
        md.reset();
        byte[] hash2 = md.digest(hash1);
        md.reset();
        md.update(salt);
        md.update(hash2);
        byte[] digest = md.digest();
        return this.xor(hash1, digest);
    }

    public byte[] encryptPasswordWithSha256(String password, byte[] salt, short charset) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hash1 = md.digest(password.getBytes(MysqlCharset$.MODULE$.apply(charset).displayName()));
        md.reset();
        byte[] hash2 = md.digest(hash1);
        md.reset();
        md.update(hash2);
        md.update(salt);
        byte[] hashAndSaltDigest = md.digest();
        return this.xor(hash1, hashAndSaltDigest);
    }

    public byte[] encryptPasswordWithRsaPublicKey(String password, String rsaKey, Option<byte[]> nonce, short charset, String serverVersion) {
        byte[] byArray;
        Option<byte[]> option = nonce;
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] serverSalt = (byte[])some.value();
            try {
                byte[] passwordWithNullByte = this.addNullByteToPassword(password.getBytes(MysqlCharset$.MODULE$.apply(charset).displayName()));
                byte[] xorResult = this.xor(passwordWithNullByte, serverSalt);
                Cipher cipher = Cipher.getInstance(this.getCipherTransformation(serverVersion));
                RSAPublicKey key = this.decodeRsaPublicKey(rsaKey);
                cipher.init(1, key);
                byArray = cipher.doFinal(xorResult);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof FailedToEncryptPasswordException) {
                    FailedToEncryptPasswordException failedToEncryptPasswordException = (FailedToEncryptPasswordException)throwable2;
                    throw failedToEncryptPasswordException;
                }
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (!option2.isEmpty()) {
                    Throwable e = (Throwable)option2.get();
                    throw new FailedToEncryptPasswordException(e);
                }
                throw throwable;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new FailedToEncryptPasswordException("Nonce not provided by the server.");
            }
            throw new MatchError(option);
        }
        byte[] byArray2 = byArray;
        return byArray2;
    }

    public String readFromPath(String path) {
        String string;
        try (BufferedSource bufferedSource = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec());){
            try {
                string = bufferedSource.getLines().mkString("\n");
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new FailedToEncryptPasswordException(e);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (throwable3 instanceof FailedToEncryptPasswordException) {
                FailedToEncryptPasswordException failedToEncryptPasswordException = (FailedToEncryptPasswordException)throwable3;
                throw failedToEncryptPasswordException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new FailedToEncryptPasswordException(e);
            }
            throw throwable;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] xor(byte[] password, byte[] scramble) {
        void var3_3;
        byte[] returnedArray = new byte[password.length];
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(password)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            returnedArray$1[i] = (byte)(password[i] ^ scramble[i % scramble.length]);
        });
        return var3_3;
    }

    public byte[] addNullByteToPassword(byte[] password) {
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(password)).$colon$plus((Object)BoxesRunTime.boxToByte((byte)((byte)0)), ClassTag$.MODULE$.Byte());
    }

    public RSAPublicKey decodeRsaPublicKey(String rsaKey) {
        RSAPublicKey rSAPublicKey;
        try {
            String trimmedRsaKey = this.trimRsaKey(rsaKey);
            byte[] certBytes = Base64.getDecoder().decode(trimmedRsaKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(certBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new FailedToEncryptPasswordException(e);
            }
            throw throwable;
        }
        return rSAPublicKey;
    }

    public String trimRsaKey(String rsaKey) {
        int endOfHeader = rsaKey.indexOf("\n") + 1;
        int beginningOfFooter = rsaKey.indexOf("-----END PUBLIC KEY-----");
        return rsaKey.substring(endOfHeader, beginningOfFooter).replaceAll("[\n|\r]", "");
    }

    public String getCipherTransformation(String version) {
        String string;
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("^(\\d+)\\.(\\d+)\\.(\\d+)(.*)?$")).r();
        Option option = pattern.unapplySeq((CharSequence)(string = version));
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) {
            throw new FailedToEncryptPasswordException("The MySQL version does not match the expected pattern.");
        }
        String major = (String)((LinearSeqOptimized)option.get()).apply(0);
        String minor = (String)((LinearSeqOptimized)option.get()).apply(1);
        String patch = (String)((LinearSeqOptimized)option.get()).apply(2);
        String string2 = new StringOps(Predef$.MODULE$.augmentString(major)).toInt() >= 8 && new StringOps(Predef$.MODULE$.augmentString(minor)).toInt() >= 0 && new StringOps(Predef$.MODULE$.augmentString(patch)).toInt() >= 5 ? "RSA/ECB/OAEPWithSHA-1AndMGF1Padding" : "RSA/ECB/PKCS1Padding";
        return string2;
    }

    private PasswordUtils$() {
        MODULE$ = this;
    }
}

