/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql;

import com.twitter.finagle.Stack;
import com.twitter.finagle.mysql.AuthInfo;
import com.twitter.finagle.mysql.AuthInfo$;
import com.twitter.finagle.mysql.AuthNegotiation;
import com.twitter.finagle.mysql.Capability;
import com.twitter.finagle.mysql.Capability$;
import com.twitter.finagle.mysql.Handshake;
import com.twitter.finagle.mysql.HandshakeInit;
import com.twitter.finagle.mysql.HandshakeResponse;
import com.twitter.finagle.mysql.HandshakeStackModifier;
import com.twitter.finagle.mysql.HandshakeStackModifier$;
import com.twitter.finagle.mysql.InsufficientServerCapabilitiesException;
import com.twitter.finagle.mysql.InsufficientServerCapabilitiesException$;
import com.twitter.finagle.mysql.PlainHandshakeResponse;
import com.twitter.finagle.mysql.Result;
import com.twitter.finagle.mysql.SecureHandshakeResponse;
import com.twitter.finagle.mysql.SslConnectionRequest;
import com.twitter.finagle.mysql.transport.Packet;
import com.twitter.finagle.netty4.ssl.client.Netty4ClientSslChannelInitializer;
import com.twitter.finagle.netty4.transport.ChannelTransportContext;
import com.twitter.finagle.param.OppTls;
import com.twitter.finagle.param.OppTls$;
import com.twitter.finagle.ssl.OpportunisticTls;
import com.twitter.finagle.ssl.OpportunisticTls$Required$;
import com.twitter.finagle.transport.Transport;
import com.twitter.finagle.transport.TransportContext;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Promise;
import com.twitter.util.Try;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y4Q!\u0004\b\u0003\u001dYA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)\u0001\u0007\u0001C\u0001c!1Q\u0007\u0001Q\u0001\nYBa\u0001\u0011\u0001!\n\u0013\t\u0005B\u0002,\u0001\t\u0003\u0001r\u000b\u0003\u0004_\u0001\u0001&Ia\u0018\u0005\u0007I\u0002\u0001K\u0011B3\t\r\u001d\u0004\u0001\u0015\"\u0003i\u0011\u0019i\u0007\u0001)C\u0005]\"1\u0001\u000f\u0001Q\u0005\nEDQ\u0001 \u0001\u0005\u0002u\u0014qbU3dkJ,\u0007*\u00198eg\"\f7.\u001a\u0006\u0003\u001fA\tQ!\\=tc2T!!\u0005\n\u0002\u000f\u0019Lg.Y4mK*\u00111\u0003F\u0001\bi^LG\u000f^3s\u0015\u0005)\u0012aA2p[N\u0011\u0001a\u0006\t\u00031ei\u0011AD\u0005\u000359\u0011\u0011\u0002S1oIND\u0017m[3\u0002\rA\f'/Y7t\u0007\u0001\u0001\"A\b\u0012\u000f\u0005}\u0001S\"\u0001\t\n\u0005\u0005\u0002\u0012!B*uC\u000e\\\u0017BA\u0012%\u0005\u0019\u0001\u0016M]1ng*\u0011\u0011\u0005E\u0001\niJ\fgn\u001d9peR\u0004BaJ\u0015,W5\t\u0001F\u0003\u0002&!%\u0011!\u0006\u000b\u0002\n)J\fgn\u001d9peR\u0004\"\u0001\f\u0018\u000e\u00035R!!\n\b\n\u0005=j#A\u0002)bG.,G/\u0001\u0004=S:LGO\u0010\u000b\u0004eM\"\u0004C\u0001\r\u0001\u0011\u0015Y2\u00011\u0001\u001e\u0011\u0015)3\u00011\u0001'\u0003!!Hn\u001d'fm\u0016d\u0007CA\u001c>\u001d\tA4(D\u0001:\u0015\tQ\u0004#A\u0002tg2L!\u0001P\u001d\u0002!=\u0003\bo\u001c:uk:L7\u000f^5d)2\u001c\u0018B\u0001 @\u0005\u0015aUM^3m\u0015\ta\u0014(A\np]\"\u000bg\u000eZ:iC.,7i\\7qY\u0016$X\r\u0006\u0002C#R\u00111)\u0013\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0005+:LG\u000fC\u0003K\u000b\u0001\u00071*\u0001\u0004sKN,H\u000e\u001e\t\u0004\u0019>\u001bU\"A'\u000b\u00059\u0013\u0012\u0001B;uS2L!\u0001U'\u0003\u0007Q\u0013\u0018\u0010C\u0003S\u000b\u0001\u00071+A\u0001q!\raEkQ\u0005\u0003+6\u0013q\u0001\u0015:p[&\u001cX-\u0001\u0007hKR$Fn\u001d)be\u0006l7\u000fF\u0002\u001e1vCQ!\u0017\u0004A\u0002i\u000bQ\u0002[1oIND\u0017m[3J]&$\bC\u0001\r\\\u0013\tafBA\u0007IC:$7\u000f[1lK&s\u0017\u000e\u001e\u0005\u0006%\u001a\u0001\raU\u0001\r]\u0016<w\u000e^5bi\u0016$Fn\u001d\u000b\u0003A\u000e\u00042\u0001T1D\u0013\t\u0011WJ\u0001\u0004GkR,(/\u001a\u0005\u00063\u001e\u0001\rAW\u0001\u001aoJLG/Z*tY\u000e{gN\\3di&|gNU3rk\u0016\u001cH\u000f\u0006\u0002aM\")\u0011\f\u0003a\u00015\u0006YR.Y6f'\u0016\u001cWO]3IC:$7\u000f[1lKJ+7\u000f]8og\u0016$\"!\u001b7\u0011\u0005aQ\u0017BA6\u000f\u0005EA\u0015M\u001c3tQ\u0006\\WMU3ta>t7/\u001a\u0005\u00063&\u0001\rAW\u0001\u001b[\u0006\\W\r\u00157bS:D\u0015M\u001c3tQ\u0006\\WMU3ta>t7/\u001a\u000b\u0003S>DQ!\u0017\u0006A\u0002i\u000bq#\u001b8ji&\fG/Z!vi\"tUmZ8uS\u0006$\u0018n\u001c8\u0015\u0007I4x\u000fE\u0002MCN\u0004\"\u0001\u0007;\n\u0005Ut!A\u0002*fgVdG\u000fC\u0003Z\u0017\u0001\u0007!\fC\u0003y\u0017\u0001\u0007\u00110\u0001\u0004tK\u000e,(/\u001a\t\u0003\tjL!a_#\u0003\u000f\t{w\u000e\\3b]\u0006y1m\u001c8oK\u000e$\u0018n\u001c8QQ\u0006\u001cX\rF\u0001s\u0001")
public final class SecureHandshake
extends Handshake {
    private final Stack.Params params;
    private final Transport<Packet, Packet> transport;
    private final OpportunisticTls.Level tlsLevel;

    private void onHandshakeComplete(Promise<BoxedUnit> p, Try<BoxedUnit> result) {
        p.updateIfEmpty(result);
    }

    public Stack.Params getTlsParams(HandshakeInit handshakeInit, Promise<BoxedUnit> p) {
        return ((Stack.Params)((HandshakeStackModifier)this.params.apply(HandshakeStackModifier$.MODULE$.param())).modifyParams().apply((Object)this.params, (Object)handshakeInit)).$plus((Object)new Netty4ClientSslChannelInitializer.OnSslHandshakeComplete((Function1 & Serializable & scala.Serializable)result -> {
            this.onHandshakeComplete((Promise<BoxedUnit>)p, (Try<BoxedUnit>)result);
            return BoxedUnit.UNIT;
        }), Netty4ClientSslChannelInitializer.OnSslHandshakeComplete$.MODULE$.param());
    }

    private Future<BoxedUnit> negotiateTls(HandshakeInit handshakeInit) {
        Future future;
        Promise p = new Promise();
        Stack.Params tlsParams = this.getTlsParams(handshakeInit, (Promise<BoxedUnit>)p);
        TransportContext context = this.transport.context();
        TransportContext transportContext = context;
        if (transportContext instanceof ChannelTransportContext) {
            ChannelTransportContext channelTransportContext = (ChannelTransportContext)transportContext;
            Channel channel = channelTransportContext.ch();
            channel.pipeline().addFirst("mysqlSslInit", (ChannelHandler)new Netty4ClientSslChannelInitializer(tlsParams));
            future = p;
        } else {
            future = Future$.MODULE$.exception((Throwable)new IllegalStateException(new StringBuilder(64).append("SecureHandshake requires a channel to negotiate SSL/TLS. Found: ").append(transportContext).toString()));
        }
        return future;
    }

    private Future<BoxedUnit> writeSslConnectionRequest(HandshakeInit handshakeInit) {
        SslConnectionRequest request = new SslConnectionRequest(this.settings().sslCalculatedClientCapabilities(), this.settings().charset(), (int)this.settings().maxPacketSize().inBytes());
        return this.transport.write((Object)request.toPacket());
    }

    private HandshakeResponse makeSecureHandshakeResponse(HandshakeInit handshakeInit) {
        return new SecureHandshakeResponse(this.settings().username(), this.settings().password(), this.settings().database(), this.settings().sslCalculatedClientCapabilities(), handshakeInit.salt(), handshakeInit.serverCapabilities(), this.settings().charset(), (int)this.settings().maxPacketSize().inBytes(), this.settings().enableCachingSha2PasswordAuth());
    }

    private HandshakeResponse makePlainHandshakeResponse(HandshakeInit handshakeInit) {
        return new PlainHandshakeResponse(this.settings().username(), this.settings().password(), this.settings().database(), this.settings().calculatedClientCapabilities(), handshakeInit.salt(), handshakeInit.serverCapabilities(), this.settings().charset(), (int)this.settings().maxPacketSize().inBytes(), this.settings().enableCachingSha2PasswordAuth());
    }

    private Future<Result> initiateAuthNegotiation(HandshakeInit handshakeInit, boolean secure) {
        HandshakeResponse handshakeResponse = secure ? this.makeSecureHandshakeResponse(handshakeInit) : this.makePlainHandshakeResponse(handshakeInit);
        AuthInfo authInfo = new AuthInfo(handshakeInit.version(), this.settings(), this.fastAuthSuccessCounter(), secure, AuthInfo$.MODULE$.apply$default$5());
        return new AuthNegotiation(this.transport, (Function1<Packet, Future<Result>>)(Function1 & Serializable & scala.Serializable)packet -> this.decodeSimpleResult((Packet)packet)).doAuth(handshakeResponse, authInfo);
    }

    @Override
    public Future<Result> connectionPhase() {
        return this.readHandshakeInit().flatMap((Function1 & Serializable & scala.Serializable)handshakeInit -> {
            Future future;
            OpportunisticTls.Level level = $this.tlsLevel;
            OpportunisticTls.Off$ off$ = OpportunisticTls.Off$.MODULE$;
            if (!(level != null ? !level.equals(off$) : off$ != null)) {
                future = this.initiateAuthNegotiation((HandshakeInit)handshakeInit, false);
            } else {
                boolean serverTlsEnabled = handshakeInit.serverCapabilities().has(Capability$.MODULE$.SSL());
                if (serverTlsEnabled) {
                    future = this.writeSslConnectionRequest((HandshakeInit)handshakeInit).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> this.negotiateTls((HandshakeInit)handshakeInit)).map((Function1 & Serializable & scala.Serializable)x$2 -> handshakeInit).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> this.initiateAuthNegotiation((HandshakeInit)x$3, true));
                } else {
                    OpportunisticTls.Level level2 = $this.tlsLevel;
                    OpportunisticTls.Desired$ desired$ = OpportunisticTls.Desired$.MODULE$;
                    future = !(level2 != null ? !level2.equals(desired$) : desired$ != null) ? this.initiateAuthNegotiation((HandshakeInit)handshakeInit, false) : Future$.MODULE$.exception((Throwable)new InsufficientServerCapabilitiesException(new Capability(Capability$.MODULE$.SSL()), handshakeInit.serverCapabilities(), InsufficientServerCapabilitiesException$.MODULE$.$lessinit$greater$default$3()));
                }
            }
            return future;
        }).onFailure((Function1 & Serializable & scala.Serializable)x$4 -> {
            this.transport.close();
            return BoxedUnit.UNIT;
        });
    }

    public SecureHandshake(Stack.Params params, Transport<Packet, Packet> transport) {
        this.params = params;
        this.transport = transport;
        super(params, transport);
        this.tlsLevel = (OpportunisticTls.Level)((OppTls)params.apply(OppTls$.MODULE$.param())).level().getOrElse((Function0 & Serializable & scala.Serializable)() -> OpportunisticTls$Required$.MODULE$);
    }
}

