/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql;

import com.twitter.finagle.mysql.MysqlCharset$;
import com.twitter.finagle.mysql.RawValue;
import com.twitter.finagle.mysql.TimestampValue;
import com.twitter.finagle.mysql.TimestampValue$Zero$;
import com.twitter.finagle.mysql.Type$;
import com.twitter.finagle.mysql.Value;
import com.twitter.finagle.mysql.transport.MysqlBuf$;
import com.twitter.finagle.mysql.transport.MysqlBufReader;
import com.twitter.util.TwitterDateFormat$;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.math.package$;

public final class TimestampValue$
extends TimestampValue {
    public static TimestampValue$ MODULE$;

    static {
        new TimestampValue$();
    }

    public boolean isTimestamp(Value value) {
        RawValue rawValue;
        Value value2 = value;
        boolean bl = value2 instanceof RawValue && ((rawValue = (RawValue)value2).typ() == Type$.MODULE$.Timestamp() || rawValue.typ() == Type$.MODULE$.DateTime());
        return bl;
    }

    public Option<Timestamp> fromValue(Value value, TimeZone timeZone) {
        None$ none$;
        RawValue rawValue;
        Value value2 = value;
        if (value2 instanceof RawValue && this.isTimestamp(rawValue = (RawValue)value2)) {
            Timestamp timestamp;
            if (!rawValue.isBinary()) {
                String str = new String(rawValue.bytes(), MysqlCharset$.MODULE$.apply(rawValue.charset()));
                timestamp = this.fromString(str, timeZone);
            } else {
                timestamp = this.fromBytes(rawValue.bytes(), timeZone);
            }
            Timestamp timestamp2 = timestamp;
            none$ = new Some((Object)timestamp2);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Timestamp fromString(String str, TimeZone timeZone) {
        Timestamp timestamp;
        String string = str;
        String string2 = TimestampValue$Zero$.MODULE$.toString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return TimestampValue$Zero$.MODULE$;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        SimpleDateFormat format = TwitterDateFormat$.MODULE$.apply("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(timeZone);
        long timeInMillis = format.parse(str, parsePosition).getTime();
        int index = parsePosition.getIndex();
        if (index >= str.length()) {
            timestamp = new Timestamp(timeInMillis);
        } else if (str.charAt(index) != '.') {
            timestamp = TimestampValue$Zero$.MODULE$;
        } else {
            String rest = str.substring(index + 1);
            if (rest.length() > 9) {
                timestamp = TimestampValue$Zero$.MODULE$;
            } else {
                int multiple = (int)package$.MODULE$.pow(10.0, (double)(9 - rest.length()));
                try {
                    int nanos = Integer.parseInt(rest) * multiple;
                    Timestamp ts = new Timestamp(timeInMillis);
                    ts.setNanos(nanos);
                    timestamp = ts;
                }
                catch (NumberFormatException numberFormatException) {
                    timestamp = TimestampValue$Zero$.MODULE$;
                }
            }
        }
        return timestamp;
    }

    private Timestamp fromBytes(byte[] bytes, TimeZone timeZone) {
        Timestamp timestamp;
        block8: {
            TimestampValue$Zero$ timestampValue$Zero$;
            block7: {
                if (bytes.length == 0) {
                    return TimestampValue$Zero$.MODULE$;
                }
                int year = 0;
                short month = 0;
                short day = 0;
                short hour = 0;
                short min = 0;
                short sec = 0;
                int micro = 0;
                try (MysqlBufReader br = MysqlBuf$.MODULE$.reader(bytes);){
                    if (br.remaining() < 4) {
                        timestampValue$Zero$ = TimestampValue$Zero$.MODULE$;
                        break block7;
                    }
                    year = br.readUnsignedShortLE();
                    month = br.readUnsignedByte();
                    day = br.readUnsignedByte();
                    if (br.remaining() >= 3) {
                        hour = br.readUnsignedByte();
                        min = br.readUnsignedByte();
                        sec = br.readUnsignedByte();
                    }
                    if (br.remaining() >= 4) {
                        micro = br.readIntLE();
                    }
                    Calendar cal = Calendar.getInstance(timeZone);
                    cal.set(year, month - 1, day, hour, min, sec);
                    Timestamp ts = new Timestamp(0L);
                    ts.setTime(cal.getTimeInMillis());
                    ts.setNanos(micro * 1000);
                    timestamp = ts;
                    break block8;
                }
            }
            return timestampValue$Zero$;
        }
        return timestamp;
    }

    private TimestampValue$() {
        super(TimeZone.getTimeZone("UTC"), TimeZone.getTimeZone("UTC"));
        MODULE$ = this;
    }
}

