/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql;

import com.twitter.finagle.mysql.Extractable;
import com.twitter.finagle.mysql.Injectable;
import com.twitter.finagle.mysql.MysqlCharset$;
import com.twitter.finagle.mysql.RawValue;
import com.twitter.finagle.mysql.TimestampValue$;
import com.twitter.finagle.mysql.Type$;
import com.twitter.finagle.mysql.Value;
import com.twitter.finagle.mysql.transport.MysqlBuf$;
import com.twitter.finagle.mysql.transport.MysqlBufWriter;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\f\u0019\u0001\u0005B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015q\u0005\u0001\"\u0001P\u000f\u0015)\u0006\u0004#\u0001W\r\u00159\u0002\u0004#\u0001X\u0011\u0015\u0011\u0015\u0002\"\u0001Y\u0011\u0019I\u0016\u0002\"\u0001\u00195\"1\u0001-\u0003C\u00011\u0005<a!Z\u0005!\u0012\u00131gA\u00025\nA#%\u0011\u000eC\u0003C\u001d\u0011\u0005!\u000eC\u0004l\u001d\t\u0007I\u0011\t7\t\rAt\u0001\u0015!\u0003n\u0011\u001d\thB1A\u0005BIDaA \b!\u0002\u0013\u0019\b\u0002C@\u000f\u0003\u0003%I!!\u0001\t\u0011\u0005=\u0011\u0002)C\u0005\u0003#A\u0001\"!\u0007\nA\u0013%\u00111\u0004\u0002\u000f)&lWm\u001d;b[B4\u0016\r\\;f\u0015\tI\"$A\u0003nsN\fHN\u0003\u0002\u001c9\u00059a-\u001b8bO2,'BA\u000f\u001f\u0003\u001d!x/\u001b;uKJT\u0011aH\u0001\u0004G>l7\u0001A\n\u0005\u0001\tBC\u0007\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0004S)bS\"\u0001\r\n\u0005-B\"AC%oU\u0016\u001cG/\u00192mKB\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0004gFd'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012\u0011\u0002V5nKN$\u0018-\u001c9\u0011\u0007%*D&\u0003\u000271\tYQ\t\u001f;sC\u000e$\u0018M\u00197f\u0003EIgN[3di&|g\u000eV5nKj{g.Z\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bM\u0001\u0005kRLG.\u0003\u0002?w\tAA+[7f5>tW-\u0001\nj]*,7\r^5p]RKW.\u001a.p]\u0016\u0004\u0013AE3yiJ\f7\r^5p]RKW.\u001a.p]\u0016\f1#\u001a=ue\u0006\u001cG/[8o)&lWMW8oK\u0002\na\u0001P5oSRtDc\u0001#F\rB\u0011\u0011\u0006\u0001\u0005\u0006o\u0015\u0001\r!\u000f\u0005\u0006\u0001\u0016\u0001\r!O\u0001\u0006CB\u0004H.\u001f\u000b\u0003\u00132\u0003\"!\u000b&\n\u0005-C\"!\u0002,bYV,\u0007\"B'\u0007\u0001\u0004a\u0013A\u0001;t\u0003\u001d)h.\u00199qYf$\"\u0001U*\u0011\u0007\r\nF&\u0003\u0002SI\t1q\n\u001d;j_:DQ\u0001V\u0004A\u0002%\u000b\u0011A^\u0001\u000f)&lWm\u001d;b[B4\u0016\r\\;f!\tI\u0013b\u0005\u0002\n\tR\ta+A\u0006jgRKW.Z:uC6\u0004HCA._!\t\u0019C,\u0003\u0002^I\t9!i\\8mK\u0006t\u0007\"B0\f\u0001\u0004I\u0015!\u0002<bYV,\u0017!\u00034s_64\u0016\r\\;f)\r\u0001&m\u0019\u0005\u0006?2\u0001\r!\u0013\u0005\u0006I2\u0001\r!O\u0001\ti&lWMW8oK\u0006!!,\u001a:p!\t9g\"D\u0001\n\u0005\u0011QVM]8\u0014\u00059aC#\u00014\u0002\u000f\u001d,G\u000fV5nKV\tQ\u000e\u0005\u0002$]&\u0011q\u000e\n\u0002\u0005\u0019>tw-\u0001\u0005hKR$\u0016.\\3!\u0003!!xn\u0015;sS:<W#A:\u0011\u0005Q\\hBA;z!\t1H%D\u0001x\u0015\tA\b%\u0001\u0004=e>|GOP\u0005\u0003u\u0012\na\u0001\u0015:fI\u00164\u0017B\u0001?~\u0005\u0019\u0019FO]5oO*\u0011!\u0010J\u0001\ni>\u001cFO]5oO\u0002\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0019\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\t9A\u0001\u0004PE*,7\r^\u0001\u000bMJ|Wn\u0015;sS:<G#\u0002\u0017\u0002\u0014\u0005]\u0001BBA\u000b+\u0001\u00071/A\u0002tiJDQ\u0001Z\u000bA\u0002e\n\u0011B\u001a:p[\nKH/Z:\u0015\u000b1\ni\"!\f\t\u000f\u0005}a\u00031\u0001\u0002\"\u0005)!-\u001f;fgB)1%a\t\u0002(%\u0019\u0011Q\u0005\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\r\nI#C\u0002\u0002,\u0011\u0012AAQ=uK\")AM\u0006a\u0001s\u0001")
public class TimestampValue
implements Injectable<Timestamp>,
Extractable<Timestamp> {
    private final TimeZone injectionTimeZone;
    private final TimeZone extractionTimeZone;

    public TimeZone injectionTimeZone() {
        return this.injectionTimeZone;
    }

    public TimeZone extractionTimeZone() {
        return this.extractionTimeZone;
    }

    @Override
    public Value apply(Timestamp ts) {
        byte[] bytes = new byte[11];
        MysqlBufWriter bw = MysqlBuf$.MODULE$.writer(bytes);
        Calendar cal = Calendar.getInstance(this.injectionTimeZone());
        cal.setTimeInMillis(ts.getTime());
        bw.writeShortLE(cal.get(1));
        bw.writeByte(cal.get(2) + 1);
        bw.writeByte(cal.get(5));
        bw.writeByte(cal.get(11));
        bw.writeByte(cal.get(12));
        bw.writeByte(cal.get(13));
        bw.writeIntLE(ts.getNanos() / 1000);
        return new RawValue(Type$.MODULE$.Timestamp(), MysqlCharset$.MODULE$.Binary(), true, bytes);
    }

    @Override
    public Option<Timestamp> unapply(Value v) {
        return TimestampValue$.MODULE$.fromValue(v, this.extractionTimeZone());
    }

    public TimestampValue(TimeZone injectionTimeZone, TimeZone extractionTimeZone) {
        this.injectionTimeZone = injectionTimeZone;
        this.extractionTimeZone = extractionTimeZone;
    }
}

