/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mysql.transport;

import com.twitter.finagle.mysql.transport.MysqlBuf$;
import com.twitter.finagle.mysql.transport.MysqlBufReader$;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.io.ProxyByteReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154AAD\b\u00015!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0003;\u0001\u0011\u00051\bC\u0003=\u0001\u0011\u0005Q\bC\u0003J\u0001\u0011\u00051\bC\u0003K\u0001\u0011\u00051\nC\u0003X\u0001\u0011\u0005\u0001lB\u0003]\u001f!\u0005QLB\u0003\u000f\u001f!\u0005a\fC\u0003&\u0015\u0011\u0005!\rC\u0003d\u0015\u0011\u0005A\rC\u0003d\u0015\u0011\u0005!N\u0001\bNsN\fHNQ;g%\u0016\fG-\u001a:\u000b\u0005A\t\u0012!\u0003;sC:\u001c\bo\u001c:u\u0015\t\u00112#A\u0003nsN\fHN\u0003\u0002\u0015+\u00059a-\u001b8bO2,'B\u0001\f\u0018\u0003\u001d!x/\u001b;uKJT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ!AH\u000b\u0002\u0005%|\u0017B\u0001\u0011\u001e\u0005=\u0001&o\u001c=z\u0005f$XMU3bI\u0016\u0014\u0018AC;oI\u0016\u0014H._5oOB\u0011AdI\u0005\u0003Iu\u0011!BQ=uKJ+\u0017\rZ3s\u0003\u0019a\u0014N\\5u}Q\u0011q%\u000b\t\u0003Q\u0001i\u0011a\u0004\u0005\u0006C\t\u0001\rAI\u0001\u0005i\u0006\\W\r\u0006\u0002-kA\u0019Q\u0006\r\u001a\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012Q!\u0011:sCf\u0004\"!L\u001a\n\u0005Qr#\u0001\u0002\"zi\u0016DQAN\u0002A\u0002]\n\u0011A\u001c\t\u0003[aJ!!\u000f\u0018\u0003\u0007%sG/A\fsK\u0006$g*\u001e7m)\u0016\u0014X.\u001b8bi\u0016$')\u001f;fgR\tA&\u0001\rsK\u0006$g*\u001e7m)\u0016\u0014X.\u001b8bi\u0016$7\u000b\u001e:j]\u001e$\u0012A\u0010\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005sS\"\u0001\"\u000b\u0005\rK\u0012A\u0002\u001fs_>$h(\u0003\u0002F]\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)e&\u0001\u000bsK\u0006$G*\u001a8hi\"\u001cu\u000eZ3e\u0005f$Xm]\u0001\u0016e\u0016\fG\rT3oORD7i\u001c3fIN#(/\u001b8h)\tqD\nC\u0003N\u000f\u0001\u0007a*A\u0004dQ\u0006\u00148/\u001a;\u0011\u0005=+V\"\u0001)\u000b\u00055\u000b&B\u0001*T\u0003\rq\u0017n\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0006KA\u0004DQ\u0006\u00148/\u001a;\u0002!I,\u0017\r\u001a,be&\f'\r\\3M_:<G#A-\u0011\u00055R\u0016BA./\u0005\u0011auN\\4\u0002\u001d5K8/\u001d7Ck\u001a\u0014V-\u00193feB\u0011\u0001FC\n\u0003\u0015}\u0003\"!\f1\n\u0005\u0005t#AB!osJ+g\rF\u0001^\u0003\u0015\t\u0007\u000f\u001d7z)\t9S\rC\u0003g\u0019\u0001\u0007q-A\u0002ck\u001a\u0004\"\u0001\b5\n\u0005%l\"a\u0001\"vMR\u0011qe\u001b\u0005\u0006Y6\u0001\r\u0001L\u0001\u0006Ef$Xm\u001d")
public class MysqlBufReader
extends ProxyByteReader {
    public static MysqlBufReader apply(byte[] byArray) {
        return MysqlBufReader$.MODULE$.apply(byArray);
    }

    public static MysqlBufReader apply(Buf buf) {
        return MysqlBufReader$.MODULE$.apply(buf);
    }

    public byte[] take(int n) {
        return Buf.ByteArray$.Owned$.MODULE$.extract(this.readBytes(n));
    }

    public byte[] readNullTerminatedBytes() {
        Buffer bytes = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        boolean eof = false;
        do {
            BoxedUnit boxedUnit;
            byte b;
            if ((b = this.readByte()) == 0) {
                eof = true;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = bytes.$plus$eq((Object)BoxesRunTime.boxToByte((byte)b));
        } while (!eof);
        return (byte[])bytes.toArray(ClassTag$.MODULE$.Byte());
    }

    public String readNullTerminatedString() {
        return new String(this.readNullTerminatedBytes(), StandardCharsets.UTF_8);
    }

    public byte[] readLengthCodedBytes() {
        byte[] byArray;
        long l = this.readVariableLong();
        if ((long)MysqlBuf$.MODULE$.NullLength() == l) {
            byArray = null;
        } else if (0L == l) {
            byArray = Array$.MODULE$.emptyByteArray();
        } else {
            if (l > Integer.MAX_VALUE) {
                throw new IllegalStateException(new StringBuilder(39).append("Length-encoded byte size is too large: ").append(l).toString());
            }
            byArray = Buf.ByteArray$.Owned$.MODULE$.extract(this.readBytes((int)l));
        }
        return byArray;
    }

    public String readLengthCodedString(Charset charset) {
        byte[] bytes = this.readLengthCodedBytes();
        return bytes != null ? new String(bytes, charset) : null;
    }

    public long readVariableLong() {
        long l;
        short s = this.readUnsignedByte();
        if (s < 251) {
            l = s;
        } else if (251 == s) {
            l = MysqlBuf$.MODULE$.NullLength();
        } else if (252 == s) {
            l = this.readUnsignedShortLE();
        } else if (253 == s) {
            l = this.readUnsignedMediumLE();
        } else if (254 == s) {
            long longValue = this.readLongLE();
            if (longValue < 0L) {
                throw new IllegalStateException(new StringBuilder(31).append("Negative length-encoded value: ").append(longValue).toString());
            }
            l = longValue;
        } else {
            throw new IllegalStateException(new StringBuilder(21).append("Invalid length byte: ").append(s).toString());
        }
        return l;
    }

    public MysqlBufReader(ByteReader underlying) {
        super(underlying);
    }
}

