/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.Verbosity$;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tuv!B\u0001\u0003\u0011\u0013i\u0011aE\"iC:tW\r\\*uCR\u001c\b*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0019\u0007.\u00198oK2T!!\u0002\u0004\u0002\r9,G\u000f^=5\u0015\t9\u0001\"A\u0004gS:\fw\r\\3\u000b\u0005%Q\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0005#\t\u00192\t[1o]\u0016d7\u000b^1ug\"\u000bg\u000e\u001a7feN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u000f\u0010\u0005\u0004%I!H\u0001\u0004Y><W#\u0001\u0010\u0011\u0005}1S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003G\u0011\nA!\u001e;jY*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014!\u0005\u0019aunZ4fe\"1\u0011f\u0004Q\u0001\ny\tA\u0001\\8hA\u0019!1f\u0004\u0001-\u0005I\u0019\u0006.\u0019:fI\u000eC\u0017M\u001c8fYN#\u0018\r^:\u0014\u0005)\u0012\u0002\u0002\u0003\u0018+\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u001bM$\u0018\r^:SK\u000e,\u0017N^3s!\t\u00014'D\u00012\u0015\t\u0011d!A\u0003ti\u0006$8/\u0003\u00025c\ti1\u000b^1ugJ+7-Z5wKJDQ!\u0007\u0016\u0005\u0002Y\"\"aN\u001d\u0011\u0005aRS\"A\b\t\u000b9*\u0004\u0019A\u0018\t\u000fmR#\u0019!C\u0005y\u0005y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG/F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0005\n\n!bY8oGV\u0014(/\u001a8u\u0013\t!uHA\u0005M_:<\u0017\t\u001a3fe\"1aI\u000bQ\u0001\nu\n\u0001cY8o]\u0016\u001cG/[8o\u0007>,h\u000e\u001e\u0011\t\u000b!SC\u0011A%\u00021\r|gN\\3di&|gnQ8v]RLen\u0019:f[\u0016tG\u000fF\u0001K!\t\u00192*\u0003\u0002M)\t!QK\\5u\u0011\u0015q%\u0006\"\u0001J\u0003a\u0019wN\u001c8fGRLwN\\\"pk:$H)Z2sK6,g\u000e\u001e\u0005\b!*\u0012\r\u0011\"\u0003=\u0003I!Hn]\"p]:,7\r^5p]\u000e{WO\u001c;\t\rIS\u0003\u0015!\u0003>\u0003M!Hn]\"p]:,7\r^5p]\u000e{WO\u001c;!\u0011\u0015!&\u0006\"\u0001J\u0003m!Hn]\"p]:,7\r^5p]\u000e{WO\u001c;J]\u000e\u0014X-\\3oi\")aK\u000bC\u0001\u0013\u0006YB\u000f\\:D_:tWm\u0019;j_:\u001cu.\u001e8u\t\u0016\u001c'/Z7f]RDq\u0001\u0017\u0016C\u0002\u0013\u0005\u0011,\u0001\u0005d_:tWm\u0019;t+\u0005Q\u0006C\u0001\u0019\\\u0013\ta\u0016GA\u0004D_VtG/\u001a:\t\ryS\u0003\u0015!\u0003[\u0003%\u0019wN\u001c8fGR\u001c\b\u0005C\u0004aU\t\u0007I\u0011A1\u0002%\r|gN\\3di&|g\u000eR;sCRLwN\\\u000b\u0002EB\u0011\u0001gY\u0005\u0003IF\u0012Aa\u0015;bi\"1aM\u000bQ\u0001\n\t\f1cY8o]\u0016\u001cG/[8o\tV\u0014\u0018\r^5p]\u0002Bq\u0001\u001b\u0016C\u0002\u0013\u0005\u0011-A\fd_:tWm\u0019;j_:\u0014VmY3jm\u0016$')\u001f;fg\"1!N\u000bQ\u0001\n\t\f\u0001dY8o]\u0016\u001cG/[8o%\u0016\u001cW-\u001b<fI\nKH/Z:!\u0011\u001da'F1A\u0005\u0002\u0005\f1cY8o]\u0016\u001cG/[8o'\u0016tGOQ=uKNDaA\u001c\u0016!\u0002\u0013\u0011\u0017\u0001F2p]:,7\r^5p]N+g\u000e\u001e\"zi\u0016\u001c\b\u0005C\u0004qU\t\u0007I\u0011A-\u0002\u0011]\u0014\u0018\u000e^1cY\u0016DaA\u001d\u0016!\u0002\u0013Q\u0016!C<sSR\f'\r\\3!\u0011\u001d!(F1A\u0005\u0002e\u000b!\"\u001e8xe&$\u0018M\u00197f\u0011\u00191(\u0006)A\u00055\u0006YQO\\<sSR\f'\r\\3!\u0011\u001dA(F1A\u0005\u0002e\u000b1B]3ue\u0006t7/\\5ug\"1!P\u000bQ\u0001\ni\u000bAB]3ue\u0006t7/\\5ug\u0002Bq\u0001 \u0016C\u0002\u0013\u0005\u0011-A\tuGB\u001cVM\u001c3XS:$wn^*ju\u0016DaA \u0016!\u0002\u0013\u0011\u0017A\u0005;daN+g\u000eZ,j]\u0012|woU5{K\u0002B\u0001\"!\u0001+\u0005\u0004%\t!W\u0001\u000ee\u0016\u001cW-\u001b<fI\nKH/Z:\t\u000f\u0005\u0015!\u0006)A\u00055\u0006q!/Z2fSZ,GMQ=uKN\u0004\u0003\u0002CA\u0005U\t\u0007I\u0011A-\u0002\u0013M,g\u000e\u001e\"zi\u0016\u001c\bbBA\u0007U\u0001\u0006IAW\u0001\u000bg\u0016tGOQ=uKN\u0004\u0003\"CA\tU\t\u0007I\u0011AA\n\u0003))\u0007pY3qi&|gn]\u000b\u0002_!9\u0011q\u0003\u0016!\u0002\u0013y\u0013aC3yG\u0016\u0004H/[8og\u0002B\u0001\"a\u0007+\u0005\u0004%\t!W\u0001\fG2|7/Z:D_VtG\u000fC\u0004\u0002 )\u0002\u000b\u0011\u0002.\u0002\u0019\rdwn]3t\u0007>,h\u000e\u001e\u0011\t\u0013\u0005\r\"F1A\u0005\n\u0005\u0015\u0012aC2p]:,7\r^5p]N,\"!a\n\u0011\u0007A\nI#C\u0002\u0002,E\u0012QaR1vO\u0016D\u0001\"a\f+A\u0003%\u0011qE\u0001\rG>tg.Z2uS>t7\u000f\t\u0005\n\u0003gQ#\u0019!C\u0005\u0003K\ta\u0002\u001e7t\u0007>tg.Z2uS>t7\u000f\u0003\u0005\u00028)\u0002\u000b\u0011BA\u0014\u0003=!Hn]\"p]:,7\r^5p]N\u0004\u0003\"CA\u001e\u001f\t\u0007IQBA\u001f\u0003Y!6\r]*uCR\u001cX\u000b\u001d3bi\u0016Le\u000e^3sm\u0006dWCAA !\u0011\t\t%!\u0012\u000e\u0005\u0005\r#BA\u0012\t\u0013\u0011\t9%a\u0011\u0003\u0011\u0011+(/\u0019;j_:D\u0001\"a\u0013\u0010A\u00035\u0011qH\u0001\u0018)\u000e\u00048\u000b^1ugV\u0003H-\u0019;f\u0013:$XM\u001d<bY\u00022a!a\u0014\u0010\r\u0005E#a\u0004+daN#\u0018\r^:Va\u0012\fG/\u001a:\u0014\r\u00055\u00131KA0!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-I\u0005!A.\u00198h\u0013\u0011\ti&a\u0016\u0003\r=\u0013'.Z2u!\u0011\t)&!\u0019\n\t\u0005\r\u0014q\u000b\u0002\t%Vtg.\u00192mK\"Q\u0011qMA'\u0005\u0003\u0005\u000b\u0011B\u001c\u0002%MD\u0017M]3e\u0007\"\fgN\\3m'R\fGo\u001d\u0005\u000b\u0007\u00055#\u0011!Q\u0001\n\u0005-\u0004\u0003BA7\u0003{j!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0006KB|G\u000e\u001c\u0006\u0004\u0007\u0005U$\u0002BA<\u0003s\nQA\\3uifT!!a\u001f\u0002\u0005%|\u0017\u0002BA@\u0003_\u0012!#\u00129pY2\u001cvnY6fi\u000eC\u0017M\u001c8fY\"9\u0011$!\u0014\u0005\u0002\u0005\rECBAC\u0003\u000f\u000bI\tE\u00029\u0003\u001bBq!a\u001a\u0002\u0002\u0002\u0007q\u0007C\u0004\u0004\u0003\u0003\u0003\r!a\u001b\t\u0013\u00055\u0015Q\nQ\u0001\n\u0005=\u0015a\u0002;da&sgm\u001c\t\u0005\u0003[\n\t*\u0003\u0003\u0002\u0014\u0006=$\u0001D#q_2dGk\u00199J]\u001a|\u0007\"CAL\u0003\u001b\u0002\u000b\u0015BAM\u0003=a\u0017m\u001d;SKR\u0014\u0018M\\:nSR\u001c\bcA\n\u0002\u001c&\u0019\u0011Q\u0014\u000b\u0003\t1{gn\u001a\u0005\n\u0003C\u000bi\u0005)Q\u0005\u0003G\u000b\u0011bY1oG\u0016dG.\u001a3\u0011\u0007M\t)+C\u0002\u0002(R\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002,\u00065\u0003\u0015!\u0003\u0002.\u0006y1o\u00195fIVdW\rZ+qI\u0006$X\r\r\u0003\u00020\u0006}\u0006CBAY\u0003o\u000bY,\u0004\u0002\u00024*\u0019!)!.\u000b\u0007\r\n)(\u0003\u0003\u0002:\u0006M&aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0011\t\u0005u\u0016q\u0018\u0007\u0001\t1\t\t-!+\u0002\u0002\u0003\u0005)\u0011AAb\u0005\ryF%M\t\u0005\u0003\u000b\fY\rE\u0002\u0014\u0003\u000fL1!!3\u0015\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aEAg\u0013\r\ty\r\u0006\u0002\u0004\u0003:L\bbBAj\u0003\u001b\"\t!S\u0001\u0007G\u0006t7-\u001a7\t\u000f\u0005]\u0017Q\nC!\u0013\u0006\u0019!/\u001e8\t\u000f\u0005m\u0017Q\nC\u0005\u0013\u0006\tR\u000f\u001d3bi\u0016\u001cvnY6fiN#\u0018\r^:\u0007\u000bA\u0011A!a8\u0014\t\u0005u\u0017\u0011\u001d\t\u0005\u0003G\f)/\u0004\u0002\u0002t%!\u0011q]A:\u0005Q\u0019\u0005.\u00198oK2$U\u000f\u001d7fq\"\u000bg\u000e\u001a7fe\"Y\u0011qMAo\u0005\u0003\u0005\u000b\u0011BAv!\r\tiO\u000b\b\u0004\u0003_\u0004a\u0002BAy\u0005\u000fqA!a=\u0003\u00069!\u0011Q\u001fB\u0002\u001d\u0011\t9P!\u0001\u000f\t\u0005e\u0018q`\u0007\u0003\u0003wT1!!@\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\t\u000fe\ti\u000e\"\u0001\u0003\fQ!!Q\u0002B\b!\rq\u0011Q\u001c\u0005\t\u0003O\u0012I\u00011\u0001\u0002l\"a!1CAo\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001a\u0006\u00012\r[1o]\u0016d')\u001f;fgJ+\u0017\r\u001a\u0005\r\u0005/\ti\u000e1A\u0001B\u0003&\u0011\u0011T\u0001\u0014G\"\fgN\\3m\u0005f$Xm],sSR$XM\u001c\u0005\r\u00057\ti\u000e1A\u0001B\u0003&\u00111U\u0001\u0013G\"\fgN\\3m/\u0006\u001cxK]5uC\ndW\r\u0003\u0007\u0003 \u0005u\u0007\u0019!A!B\u0013\u0011\t#A\fdQ\u0006tg.\u001a7Xe&$\u0018M\u00197f\tV\u0014\u0018\r^5p]B!!1\u0005B\u0015\u001d\u0011\t\tE!\n\n\t\t\u001d\u00121I\u0001\n'R|\u0007o^1uG\"LAAa\u000b\u0003.\t9Q\t\\1qg\u0016$\u0017\u0002\u0002B\u0018\u0003\u0007\u0012\u0011b\u0015;pa^\fGo\u00195\t\u0017\u0001\fi\u000e1A\u0001B\u0003&!\u0011\u0005\u0005\n\u0005k\ti\u000e)Q\u0005\u0003G\u000bQb\u00195b]:,G.Q2uSZ,\u0007\"\u0003B\u001d\u0003;\u0004\u000b\u0015BAR\u0003A!Hn]\"iC:tW\r\\!di&4X\r\u0003\u0007\u0003>\u0005u\u0007\u0019!A!B\u0013\u0011y$A\buGB\u001cF/\u0019;t+B$\u0017\r^3s!\u0011\u0011\t%!\u0014\u000f\u00059\u0001\u0001\u0002\u0003B#\u0003;$\tEa\u0012\u0002\u0019!\fg\u000e\u001a7fe\u0006#G-\u001a3\u0015\u0007)\u0013I\u0005\u0003\u0005\u0003L\t\r\u0003\u0019\u0001B'\u0003\r\u0019G\u000f\u001f\t\u0005\u0003G\u0014y%\u0003\u0003\u0003R\u0005M$!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0005k\ti\u000e\"\u0011\u0003VQ\u0019!Ja\u0016\t\u0011\t-#1\u000ba\u0001\u0005\u001bB\u0001Ba\u0017\u0002^\u0012\u0005#QL\u0001\u0006oJLG/\u001a\u000b\b\u0015\n}#\u0011\rB3\u0011!\u0011YE!\u0017A\u0002\t5\u0003\u0002\u0003B2\u00053\u0002\r!a\u0015\u0002\u00075\u001cx\r\u0003\u0005\u0003h\te\u0003\u0019\u0001B5\u0003\u0005\u0001\b\u0003BAr\u0005WJAA!\u001c\u0002t\tq1\t[1o]\u0016d\u0007K]8nSN,\u0007\u0002\u0003B9\u0003;$\tEa\u001d\u0002\u0017\rD\u0017M\u001c8fYJ+\u0017\r\u001a\u000b\u0006\u0015\nU$q\u000f\u0005\t\u0005\u0017\u0012y\u00071\u0001\u0003N!A!1\rB8\u0001\u0004\t\u0019\u0006\u0003\u0005\u0003|\u0005uG\u0011\tB?\u0003\u0015\u0019Gn\\:f)\u0015Q%q\u0010BA\u0011!\u0011YE!\u001fA\u0002\t5\u0003\u0002\u0003B4\u0005s\u0002\rA!\u001b\t\u0011\t\u0015\u0015Q\u001cC!\u0005\u000f\u000bqb\u00195b]:,G.\u00138bGRLg/\u001a\u000b\u0004\u0015\n%\u0005\u0002\u0003B&\u0005\u0007\u0003\rA!\u0014\t\u0011\t5\u0015Q\u001cC!\u0005\u001f\u000bq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u0006\u0015\nE%1\u0013\u0005\t\u0005\u0017\u0012Y\t1\u0001\u0003N!A!Q\u0013BF\u0001\u0004\u00119*A\u0003dCV\u001cX\r\u0005\u0003\u0003\u001a\n\rf\u0002\u0002BN\u0005?sA!!?\u0003\u001e&\tQ#C\u0002\u0003\"R\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003&\n\u001d&!\u0003+ie><\u0018M\u00197f\u0015\r\u0011\t\u000b\u0006\u0005\t\u0005W\u000bi\u000e\"\u0011\u0003.\u0006I2\r[1o]\u0016dwK]5uC\nLG.\u001b;z\u0007\"\fgnZ3e)\rQ%q\u0016\u0005\t\u0005\u0017\u0012I\u000b1\u0001\u0003N!A!1WAo\t\u0003\u0012),\u0001\nvg\u0016\u0014XI^3oiR\u0013\u0018nZ4fe\u0016$G#\u0002&\u00038\ne\u0006\u0002\u0003B&\u0005c\u0003\rA!\u0014\t\u000f\tm&\u0011\u0017a\u0001%\u0005\u0019QM\u001e;")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final SharedChannelStats sharedChannelStats;
    private long channelBytesRead;
    private long channelBytesWritten;
    private boolean channelWasWritable;
    private Function0<Duration> channelWritableDuration;
    private Function0<Duration> connectionDuration;
    private boolean channelActive;
    private boolean tlsChannelActive;
    private TcpStatsUpdater tcpStatsUpdater;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.channelBytesRead = 0L;
        this.channelBytesWritten = 0L;
        this.channelWasWritable = true;
        this.channelWritableDuration = Stopwatch$.MODULE$.start();
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.sharedChannelStats.connects().incr();
        this.sharedChannelStats.connectionCountIncrement();
        Channel channel = ctx.channel();
        if (channel instanceof EpollSocketChannel) {
            EpollSocketChannel epollSocketChannel = (EpollSocketChannel)channel;
            if (this.tcpStatsUpdater != null) {
                this.tcpStatsUpdater.cancel();
            }
            this.tcpStatsUpdater = new TcpStatsUpdater(this.sharedChannelStats, epollSocketChannel);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.channelActive = true;
        this.connectionDuration = Stopwatch$.MODULE$.start();
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.sentBytes().incr((long)readableBytes);
            this.channelBytesWritten += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder().append((Object)"ChannelStatsHandler received non-ByteBuf write: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.receivedBytes().incr((long)readableBytes);
            this.channelBytesRead += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning(new StringBuilder().append((Object)"ChannelStatsHandler received non-ByteBuf read: ").append(msg).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        this.sharedChannelStats.closesCount().incr();
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.channelActive) {
            this.channelActive = false;
            Function0<Duration> elapsed = this.connectionDuration;
            this.connectionDuration = null;
            this.sharedChannelStats.connectionDuration().add((float)((TimeLike)elapsed.apply()).inMilliseconds());
            this.sharedChannelStats.connectionCountDecrement();
            long oldChannelBytesRead = this.channelBytesRead;
            long oldChannelBytesWritten = this.channelBytesWritten;
            this.channelBytesRead = 0L;
            this.channelBytesWritten = 0L;
            if (this.tcpStatsUpdater != null) {
                this.tcpStatsUpdater.cancel();
                this.tcpStatsUpdater = null;
            }
            this.sharedChannelStats.connectionReceivedBytes().add((float)oldChannelBytesRead);
            this.sharedChannelStats.connectionSentBytes().add((float)oldChannelBytesWritten);
            if (this.tlsChannelActive) {
                this.tlsChannelActive = false;
                this.sharedChannelStats.tlsConnectionCountDecrement();
            }
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.sharedChannelStats.exceptions().counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof TimeoutException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != this.channelWasWritable) {
            Duration elapsed = (Duration)this.channelWritableDuration.apply();
            Counter stat = this.channelWasWritable ? this.sharedChannelStats.writable() : this.sharedChannelStats.unwritable();
            stat.incr((long)((int)elapsed.inMilliseconds()));
            this.channelWasWritable = isWritable;
            this.channelWritableDuration = Stopwatch$.MODULE$.start();
        }
        super.channelWritabilityChanged(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Object object = evt;
        if (object instanceof SslHandshakeCompletionEvent) {
            BoxedUnit boxedUnit;
            if (this.channelActive) {
                this.tlsChannelActive = true;
                this.sharedChannelStats.tlsConnectionCountIncrement();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.userEventTriggered(ctx, evt);
    }

    public ChannelStatsHandler(SharedChannelStats sharedChannelStats) {
        this.sharedChannelStats = sharedChannelStats;
        this.channelActive = false;
        this.tlsChannelActive = false;
    }

    public static final class TcpStatsUpdater
    implements Runnable {
        private final SharedChannelStats sharedChannelStats;
        private final EpollSocketChannel channel;
        private final EpollTcpInfo tcpInfo;
        private long lastRetransmits;
        private boolean cancelled;
        private final ScheduledFuture<?> scheduledUpdate;

        public void cancel() {
            this.cancelled = true;
            this.scheduledUpdate.cancel(false);
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                this.updateSocketStats();
            }
        }

        private void updateSocketStats() {
            try {
                this.channel.tcpInfo(this.tcpInfo);
                this.sharedChannelStats.tcpSendWindowSize().add((float)(this.tcpInfo.sndCwnd() * this.tcpInfo.sndMss()));
                long retransmits = this.tcpInfo.totalRetrans();
                this.sharedChannelStats.retransmits().incr(retransmits - this.lastRetransmits);
                this.lastRetransmits = retransmits;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ChannelException) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(Level.WARNING, "Error updating TCP info stats", t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public TcpStatsUpdater(SharedChannelStats sharedChannelStats, EpollSocketChannel channel) {
            this.sharedChannelStats = sharedChannelStats;
            this.channel = channel;
            this.tcpInfo = new EpollTcpInfo();
            this.lastRetransmits = 0L;
            this.cancelled = false;
            this.scheduledUpdate = channel.eventLoop().scheduleAtFixedRate((Runnable)this, 0L, ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$TcpStatsUpdateInterval().inMilliseconds(), TimeUnit.MILLISECONDS);
        }
    }

    public static class SharedChannelStats {
        private final LongAdder com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount = new LongAdder();
        private final LongAdder com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$tlsConnectionCount = new LongAdder();
        private final Counter connects;
        private final Stat connectionDuration;
        private final Stat connectionReceivedBytes;
        private final Stat connectionSentBytes;
        private final Counter writable;
        private final Counter unwritable;
        private final Counter retransmits;
        private final Stat tcpSendWindowSize;
        private final Counter receivedBytes;
        private final Counter sentBytes;
        private final StatsReceiver exceptions;
        private final Counter closesCount;
        private final Gauge connections;
        private final Gauge tlsConnections;

        public LongAdder com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount() {
            return this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount;
        }

        public void connectionCountIncrement() {
            this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount().increment();
        }

        public void connectionCountDecrement() {
            this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount().decrement();
        }

        public LongAdder com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$tlsConnectionCount() {
            return this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$tlsConnectionCount;
        }

        public void tlsConnectionCountIncrement() {
            this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$tlsConnectionCount().increment();
        }

        public void tlsConnectionCountDecrement() {
            this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$tlsConnectionCount().decrement();
        }

        public Counter connects() {
            return this.connects;
        }

        public Stat connectionDuration() {
            return this.connectionDuration;
        }

        public Stat connectionReceivedBytes() {
            return this.connectionReceivedBytes;
        }

        public Stat connectionSentBytes() {
            return this.connectionSentBytes;
        }

        public Counter writable() {
            return this.writable;
        }

        public Counter unwritable() {
            return this.unwritable;
        }

        public Counter retransmits() {
            return this.retransmits;
        }

        public Stat tcpSendWindowSize() {
            return this.tcpSendWindowSize;
        }

        public Counter receivedBytes() {
            return this.receivedBytes;
        }

        public Counter sentBytes() {
            return this.sentBytes;
        }

        public StatsReceiver exceptions() {
            return this.exceptions;
        }

        public Counter closesCount() {
            return this.closesCount;
        }

        private Gauge connections() {
            return this.connections;
        }

        private Gauge tlsConnections() {
            return this.tlsConnections;
        }

        public SharedChannelStats(StatsReceiver statsReceiver) {
            this.connects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
            this.connectionDuration = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_duration"}));
            this.connectionReceivedBytes = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_received_bytes"}));
            this.connectionSentBytes = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_sent_bytes"}));
            this.writable = statsReceiver.counter(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_writable_ms"}));
            this.unwritable = statsReceiver.counter(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_unwritable_ms"}));
            this.retransmits = statsReceiver.counter(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tcp_retransmits"}));
            this.tcpSendWindowSize = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tcp_send_window_size"}));
            this.receivedBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received_bytes"}));
            this.sentBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_bytes"}));
            this.exceptions = statsReceiver.scope("exn");
            this.closesCount = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
            this.connections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connections"}), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SharedChannelStats $outer;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return this.$outer.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$connectionCount().sum();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.tlsConnections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tls", "connections"}), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SharedChannelStats $outer;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return this.$outer.com$twitter$finagle$netty4$channel$ChannelStatsHandler$SharedChannelStats$$tlsConnectionCount().sum();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }
}

