// Autogenerated file, do not edit.
// See BuiltinTypeGenerator
package com.twitter.finagle.postgresql.types

import com.twitter.finagle.postgresql.Types.Oid

case class PgType(name: String, oid: Oid, kind: Kind)

object PgType {

  /**
   * Lookup a type by its Oid.
   *
   * @return Some if such a type exists, None otherwise.
   */
  def byOid(oid: Oid): Option[PgType] =
    pgTypeByOid.get(oid)

  /**
   * Find the corresponding one-dimensional array type for the specified element type.
   *
   * For example, passing `PgType.Int4` to this function would return `Some(PgType.Int4Vector)`.
   *
   * @return the corresponding array type, None if no such type exists.
   */
  def arrayOf(elementType: PgType): Option[PgType] =
    pgArrayOidByElementType.get(elementType)

  val pgTypeByOid: Map[Oid, PgType] = Map(
    Oid(16) -> Bool,
    Oid(17) -> Bytea,
    Oid(18) -> Char,
    Oid(19) -> Name,
    Oid(20) -> Int8,
    Oid(21) -> Int2,
    Oid(22) -> Int2Vector,
    Oid(23) -> Int4,
    Oid(24) -> Regproc,
    Oid(25) -> Text,
    Oid(26) -> OidType,
    Oid(27) -> Tid,
    Oid(28) -> Xid,
    Oid(29) -> Cid,
    Oid(30) -> OidVector,
    Oid(32) -> PgDdlCommand,
    Oid(71) -> PgTypeType,
    Oid(75) -> PgAttribute,
    Oid(81) -> PgProc,
    Oid(83) -> PgClass,
    Oid(114) -> Json,
    Oid(142) -> Xml,
    Oid(143) -> XmlArray,
    Oid(194) -> PgNodeTree,
    Oid(199) -> JsonArray,
    Oid(210) -> PgTypeArray,
    Oid(269) -> TableAmHandler,
    Oid(270) -> PgAttributeArray,
    Oid(271) -> Xid8Array,
    Oid(272) -> PgProcArray,
    Oid(273) -> PgClassArray,
    Oid(325) -> IndexAmHandler,
    Oid(600) -> Point,
    Oid(601) -> Lseg,
    Oid(602) -> Path,
    Oid(603) -> Box,
    Oid(604) -> Polygon,
    Oid(628) -> Line,
    Oid(629) -> LineArray,
    Oid(650) -> Cidr,
    Oid(651) -> CidrArray,
    Oid(700) -> Float4,
    Oid(701) -> Float8,
    Oid(705) -> Unknown,
    Oid(718) -> Circle,
    Oid(719) -> CircleArray,
    Oid(774) -> Macaddr8,
    Oid(775) -> Macaddr8Array,
    Oid(790) -> Money,
    Oid(791) -> MoneyArray,
    Oid(829) -> Macaddr,
    Oid(869) -> Inet,
    Oid(1000) -> BoolArray,
    Oid(1001) -> ByteaArray,
    Oid(1002) -> CharArray,
    Oid(1003) -> NameArray,
    Oid(1005) -> Int2Array,
    Oid(1006) -> Int2VectorArray,
    Oid(1007) -> Int4Array,
    Oid(1008) -> RegprocArray,
    Oid(1009) -> TextArray,
    Oid(1010) -> TidArray,
    Oid(1011) -> XidArray,
    Oid(1012) -> CidArray,
    Oid(1013) -> OidVectorArray,
    Oid(1014) -> BpcharArray,
    Oid(1015) -> VarcharArray,
    Oid(1016) -> Int8Array,
    Oid(1017) -> PointArray,
    Oid(1018) -> LsegArray,
    Oid(1019) -> PathArray,
    Oid(1020) -> BoxArray,
    Oid(1021) -> Float4Array,
    Oid(1022) -> Float8Array,
    Oid(1027) -> PolygonArray,
    Oid(1028) -> OidArray,
    Oid(1033) -> Aclitem,
    Oid(1034) -> AclitemArray,
    Oid(1040) -> MacaddrArray,
    Oid(1041) -> InetArray,
    Oid(1042) -> Bpchar,
    Oid(1043) -> Varchar,
    Oid(1082) -> Date,
    Oid(1083) -> Time,
    Oid(1114) -> Timestamp,
    Oid(1115) -> TimestampArray,
    Oid(1182) -> DateArray,
    Oid(1183) -> TimeArray,
    Oid(1184) -> Timestamptz,
    Oid(1185) -> TimestamptzArray,
    Oid(1186) -> Interval,
    Oid(1187) -> IntervalArray,
    Oid(1231) -> NumericArray,
    Oid(1263) -> CstringArray,
    Oid(1266) -> Timetz,
    Oid(1270) -> TimetzArray,
    Oid(1560) -> Bit,
    Oid(1561) -> BitArray,
    Oid(1562) -> Varbit,
    Oid(1563) -> VarbitArray,
    Oid(1700) -> Numeric,
    Oid(1790) -> Refcursor,
    Oid(2201) -> RefcursorArray,
    Oid(2202) -> Regprocedure,
    Oid(2203) -> Regoper,
    Oid(2204) -> Regoperator,
    Oid(2205) -> Regclass,
    Oid(2206) -> Regtype,
    Oid(2207) -> RegprocedureArray,
    Oid(2208) -> RegoperArray,
    Oid(2209) -> RegoperatorArray,
    Oid(2210) -> RegclassArray,
    Oid(2211) -> RegtypeArray,
    Oid(2249) -> Record,
    Oid(2275) -> Cstring,
    Oid(2276) -> Any,
    Oid(2277) -> Anyarray,
    Oid(2278) -> Void,
    Oid(2279) -> Trigger,
    Oid(2280) -> LanguageHandler,
    Oid(2281) -> Internal,
    Oid(2283) -> Anyelement,
    Oid(2287) -> RecordArray,
    Oid(2776) -> Anynonarray,
    Oid(2949) -> TxidSnapshotArray,
    Oid(2950) -> Uuid,
    Oid(2951) -> UuidArray,
    Oid(2970) -> TxidSnapshot,
    Oid(3115) -> FdwHandler,
    Oid(3220) -> PgLsn,
    Oid(3221) -> PgLsnArray,
    Oid(3310) -> TsmHandler,
    Oid(3361) -> PgNdistinct,
    Oid(3402) -> PgDependencies,
    Oid(3500) -> Anyenum,
    Oid(3614) -> TsVector,
    Oid(3615) -> Tsquery,
    Oid(3642) -> GtsVector,
    Oid(3643) -> TsVectorArray,
    Oid(3644) -> GtsVectorArray,
    Oid(3645) -> TsqueryArray,
    Oid(3734) -> Regconfig,
    Oid(3735) -> RegconfigArray,
    Oid(3769) -> Regdictionary,
    Oid(3770) -> RegdictionaryArray,
    Oid(3802) -> Jsonb,
    Oid(3807) -> JsonbArray,
    Oid(3831) -> AnyRange,
    Oid(3838) -> EventTrigger,
    Oid(3904) -> Int4Range,
    Oid(3905) -> Int4RangeArray,
    Oid(3906) -> NumRange,
    Oid(3907) -> NumRangeArray,
    Oid(3908) -> TsRange,
    Oid(3909) -> TsRangeArray,
    Oid(3910) -> TstzRange,
    Oid(3911) -> TstzRangeArray,
    Oid(3912) -> DateRange,
    Oid(3913) -> DateRangeArray,
    Oid(3926) -> Int8Range,
    Oid(3927) -> Int8RangeArray,
    Oid(4072) -> Jsonpath,
    Oid(4073) -> JsonpathArray,
    Oid(4089) -> Regnamespace,
    Oid(4090) -> RegnamespaceArray,
    Oid(4096) -> Regrole,
    Oid(4097) -> RegroleArray,
    Oid(4191) -> Regcollation,
    Oid(4192) -> RegcollationArray,
    Oid(5017) -> PgMcvList,
    Oid(5038) -> PgSnapshot,
    Oid(5039) -> PgSnapshotArray,
    Oid(5069) -> Xid8,
    Oid(5077) -> Anycompatible,
    Oid(5078) -> Anycompatiblearray,
    Oid(5079) -> Anycompatiblenonarray,
    Oid(5080) -> AnycompatibleRange
  )
  val pgArrayOidByElementType: Map[PgType, PgType] = Map(
    Bool -> BoolArray,
    Bytea -> ByteaArray,
    Char -> CharArray,
    Name -> NameArray,
    Int8 -> Int8Array,
    Int2 -> Int2Array,
    Int2Vector -> Int2VectorArray,
    Int4 -> Int4Array,
    Regproc -> RegprocArray,
    Text -> TextArray,
    OidType -> OidArray,
    Tid -> TidArray,
    Xid -> XidArray,
    Cid -> CidArray,
    OidVector -> OidVectorArray,
    PgTypeType -> PgTypeArray,
    PgAttribute -> PgAttributeArray,
    PgProc -> PgProcArray,
    PgClass -> PgClassArray,
    Json -> JsonArray,
    Xml -> XmlArray,
    Point -> PointArray,
    Lseg -> LsegArray,
    Path -> PathArray,
    Box -> BoxArray,
    Polygon -> PolygonArray,
    Line -> LineArray,
    Cidr -> CidrArray,
    Float4 -> Float4Array,
    Float8 -> Float8Array,
    Circle -> CircleArray,
    Macaddr8 -> Macaddr8Array,
    Money -> MoneyArray,
    Macaddr -> MacaddrArray,
    Inet -> InetArray,
    Aclitem -> AclitemArray,
    Bpchar -> BpcharArray,
    Varchar -> VarcharArray,
    Date -> DateArray,
    Time -> TimeArray,
    Timestamp -> TimestampArray,
    Timestamptz -> TimestamptzArray,
    Interval -> IntervalArray,
    Timetz -> TimetzArray,
    Bit -> BitArray,
    Varbit -> VarbitArray,
    Numeric -> NumericArray,
    Refcursor -> RefcursorArray,
    Regprocedure -> RegprocedureArray,
    Regoper -> RegoperArray,
    Regoperator -> RegoperatorArray,
    Regclass -> RegclassArray,
    Regtype -> RegtypeArray,
    Cstring -> CstringArray,
    Uuid -> UuidArray,
    TxidSnapshot -> TxidSnapshotArray,
    PgLsn -> PgLsnArray,
    TsVector -> TsVectorArray,
    Tsquery -> TsqueryArray,
    GtsVector -> GtsVectorArray,
    Regconfig -> RegconfigArray,
    Regdictionary -> RegdictionaryArray,
    Jsonb -> JsonbArray,
    Int4Range -> Int4RangeArray,
    NumRange -> NumRangeArray,
    TsRange -> TsRangeArray,
    TstzRange -> TstzRangeArray,
    DateRange -> DateRangeArray,
    Int8Range -> Int8RangeArray,
    Jsonpath -> JsonpathArray,
    Regnamespace -> RegnamespaceArray,
    Regrole -> RegroleArray,
    Regcollation -> RegcollationArray,
    PgSnapshot -> PgSnapshotArray,
    Xid8 -> Xid8Array
  )

  /**
   * boolean, 'true'/'false'
   */
  lazy val Bool: PgType = PgType("bool", Oid(16), Kind.Base)

  /**
   * variable-length string, binary values escaped
   */
  lazy val Bytea: PgType = PgType("bytea", Oid(17), Kind.Base)

  /**
   * single character
   */
  lazy val Char: PgType = PgType("char", Oid(18), Kind.Base)

  /**
   * 63-byte type for storing system identifiers
   */
  lazy val Name: PgType = PgType("name", Oid(19), Kind.Base)

  /**
   * ~18 digit integer, 8-byte storage
   */
  lazy val Int8: PgType = PgType("int8", Oid(20), Kind.Base)

  /**
   * -32 thousand to 32 thousand, 2-byte storage
   */
  lazy val Int2: PgType = PgType("int2", Oid(21), Kind.Base)

  /**
   * array of int2, used in system tables
   */
  lazy val Int2Vector: PgType = PgType("int2vector", Oid(22), Kind.Array(Int2))

  /**
   * -2 billion to 2 billion integer, 4-byte storage
   */
  lazy val Int4: PgType = PgType("int4", Oid(23), Kind.Base)

  /**
   * registered procedure
   */
  lazy val Regproc: PgType = PgType("regproc", Oid(24), Kind.Base)

  /**
   * variable-length string, no limit specified
   */
  lazy val Text: PgType = PgType("text", Oid(25), Kind.Base)

  /**
   * object identifier(oid), maximum 4 billion
   */
  lazy val OidType: PgType = PgType("oid", Oid(26), Kind.Base)

  /**
   * (block, offset), physical location of tuple
   */
  lazy val Tid: PgType = PgType("tid", Oid(27), Kind.Base)

  /**
   * transaction id
   */
  lazy val Xid: PgType = PgType("xid", Oid(28), Kind.Base)

  /**
   * command identifier type, sequence in transaction id
   */
  lazy val Cid: PgType = PgType("cid", Oid(29), Kind.Base)

  /**
   * array of oids, used in system tables
   */
  lazy val OidVector: PgType = PgType("oidvector", Oid(30), Kind.Array(OidType))

  /**
   * internal type for passing CollectedCommand
   */
  lazy val PgDdlCommand: PgType = PgType("pg_ddl_command", Oid(32), Kind.Pseudo)

  /**
   *
   */
  lazy val PgTypeType: PgType = PgType("pg_type", Oid(71), Kind.Base)

  /**
   *
   */
  lazy val PgAttribute: PgType = PgType("pg_attribute", Oid(75), Kind.Base)

  /**
   *
   */
  lazy val PgProc: PgType = PgType("pg_proc", Oid(81), Kind.Base)

  /**
   *
   */
  lazy val PgClass: PgType = PgType("pg_class", Oid(83), Kind.Base)

  /**
   * JSON stored as text
   */
  lazy val Json: PgType = PgType("json", Oid(114), Kind.Base)

  /**
   * XML content
   */
  lazy val Xml: PgType = PgType("xml", Oid(142), Kind.Base)

  /**
   * Array of xml
   */
  lazy val XmlArray: PgType = PgType("_xml", Oid(143), Kind.Array(Xml))

  /**
   * string representing an internal node tree
   */
  lazy val PgNodeTree: PgType = PgType("pg_node_tree", Oid(194), Kind.Base)

  /**
   * Array of json
   */
  lazy val JsonArray: PgType = PgType("_json", Oid(199), Kind.Array(Json))

  /**
   * Array of pg_type
   */
  lazy val PgTypeArray: PgType = PgType("_pg_type", Oid(210), Kind.Array(PgTypeType))

  /**
   *
   */
  lazy val TableAmHandler: PgType = PgType("table_am_handler", Oid(269), Kind.Pseudo)

  /**
   * Array of pg_attribute
   */
  lazy val PgAttributeArray: PgType = PgType("_pg_attribute", Oid(270), Kind.Array(PgAttribute))

  /**
   * Array of xid8
   */
  lazy val Xid8Array: PgType = PgType("_xid8", Oid(271), Kind.Array(Xid8))

  /**
   * Array of pg_proc
   */
  lazy val PgProcArray: PgType = PgType("_pg_proc", Oid(272), Kind.Array(PgProc))

  /**
   * Array of pg_class
   */
  lazy val PgClassArray: PgType = PgType("_pg_class", Oid(273), Kind.Array(PgClass))

  /**
   * pseudo-type for the result of an index AM handler function
   */
  lazy val IndexAmHandler: PgType = PgType("index_am_handler", Oid(325), Kind.Pseudo)

  /**
   * geometric point '(x, y)'
   */
  lazy val Point: PgType = PgType("point", Oid(600), Kind.Base)

  /**
   * geometric line segment '(pt1,pt2)'
   */
  lazy val Lseg: PgType = PgType("lseg", Oid(601), Kind.Base)

  /**
   * geometric path '(pt1,...)'
   */
  lazy val Path: PgType = PgType("path", Oid(602), Kind.Base)

  /**
   * geometric box '(lower left,upper right)'
   */
  lazy val Box: PgType = PgType("box", Oid(603), Kind.Base)

  /**
   * geometric polygon '(pt1,...)'
   */
  lazy val Polygon: PgType = PgType("polygon", Oid(604), Kind.Base)

  /**
   * geometric line
   */
  lazy val Line: PgType = PgType("line", Oid(628), Kind.Base)

  /**
   * Array of line
   */
  lazy val LineArray: PgType = PgType("_line", Oid(629), Kind.Array(Line))

  /**
   * network IP address/netmask, network address
   */
  lazy val Cidr: PgType = PgType("cidr", Oid(650), Kind.Base)

  /**
   * Array of cidr
   */
  lazy val CidrArray: PgType = PgType("_cidr", Oid(651), Kind.Array(Cidr))

  /**
   * single-precision floating point number, 4-byte storage
   */
  lazy val Float4: PgType = PgType("float4", Oid(700), Kind.Base)

  /**
   * double-precision floating point number, 8-byte storage
   */
  lazy val Float8: PgType = PgType("float8", Oid(701), Kind.Base)

  /**
   * pseudo-type representing an undetermined type
   */
  lazy val Unknown: PgType = PgType("unknown", Oid(705), Kind.Base)

  /**
   * geometric circle '(center,radius)'
   */
  lazy val Circle: PgType = PgType("circle", Oid(718), Kind.Base)

  /**
   * Array of circle
   */
  lazy val CircleArray: PgType = PgType("_circle", Oid(719), Kind.Array(Circle))

  /**
   * XX:XX:XX:XX:XX:XX:XX:XX, MAC address
   */
  lazy val Macaddr8: PgType = PgType("macaddr8", Oid(774), Kind.Base)

  /**
   * Array of macaddr8
   */
  lazy val Macaddr8Array: PgType = PgType("_macaddr8", Oid(775), Kind.Array(Macaddr8))

  /**
   * monetary amounts, $d,ddd.cc
   */
  lazy val Money: PgType = PgType("money", Oid(790), Kind.Base)

  /**
   * Array of money
   */
  lazy val MoneyArray: PgType = PgType("_money", Oid(791), Kind.Array(Money))

  /**
   * XX:XX:XX:XX:XX:XX, MAC address
   */
  lazy val Macaddr: PgType = PgType("macaddr", Oid(829), Kind.Base)

  /**
   * IP address/netmask, host address, netmask optional
   */
  lazy val Inet: PgType = PgType("inet", Oid(869), Kind.Base)

  /**
   * Array of bool
   */
  lazy val BoolArray: PgType = PgType("_bool", Oid(1000), Kind.Array(Bool))

  /**
   * Array of bytea
   */
  lazy val ByteaArray: PgType = PgType("_bytea", Oid(1001), Kind.Array(Bytea))

  /**
   * Array of char
   */
  lazy val CharArray: PgType = PgType("_char", Oid(1002), Kind.Array(Char))

  /**
   * Array of name
   */
  lazy val NameArray: PgType = PgType("_name", Oid(1003), Kind.Array(Name))

  /**
   * Array of int2
   */
  lazy val Int2Array: PgType = PgType("_int2", Oid(1005), Kind.Array(Int2))

  /**
   * Array of int2vector
   */
  lazy val Int2VectorArray: PgType = PgType("_int2vector", Oid(1006), Kind.Array(Int2Vector))

  /**
   * Array of int4
   */
  lazy val Int4Array: PgType = PgType("_int4", Oid(1007), Kind.Array(Int4))

  /**
   * Array of regproc
   */
  lazy val RegprocArray: PgType = PgType("_regproc", Oid(1008), Kind.Array(Regproc))

  /**
   * Array of text
   */
  lazy val TextArray: PgType = PgType("_text", Oid(1009), Kind.Array(Text))

  /**
   * Array of tid
   */
  lazy val TidArray: PgType = PgType("_tid", Oid(1010), Kind.Array(Tid))

  /**
   * Array of xid
   */
  lazy val XidArray: PgType = PgType("_xid", Oid(1011), Kind.Array(Xid))

  /**
   * Array of cid
   */
  lazy val CidArray: PgType = PgType("_cid", Oid(1012), Kind.Array(Cid))

  /**
   * Array of oidvector
   */
  lazy val OidVectorArray: PgType = PgType("_oidvector", Oid(1013), Kind.Array(OidVector))

  /**
   * Array of bpchar
   */
  lazy val BpcharArray: PgType = PgType("_bpchar", Oid(1014), Kind.Array(Bpchar))

  /**
   * Array of varchar
   */
  lazy val VarcharArray: PgType = PgType("_varchar", Oid(1015), Kind.Array(Varchar))

  /**
   * Array of int8
   */
  lazy val Int8Array: PgType = PgType("_int8", Oid(1016), Kind.Array(Int8))

  /**
   * Array of point
   */
  lazy val PointArray: PgType = PgType("_point", Oid(1017), Kind.Array(Point))

  /**
   * Array of lseg
   */
  lazy val LsegArray: PgType = PgType("_lseg", Oid(1018), Kind.Array(Lseg))

  /**
   * Array of path
   */
  lazy val PathArray: PgType = PgType("_path", Oid(1019), Kind.Array(Path))

  /**
   * Array of box
   */
  lazy val BoxArray: PgType = PgType("_box", Oid(1020), Kind.Array(Box))

  /**
   * Array of float4
   */
  lazy val Float4Array: PgType = PgType("_float4", Oid(1021), Kind.Array(Float4))

  /**
   * Array of float8
   */
  lazy val Float8Array: PgType = PgType("_float8", Oid(1022), Kind.Array(Float8))

  /**
   * Array of polygon
   */
  lazy val PolygonArray: PgType = PgType("_polygon", Oid(1027), Kind.Array(Polygon))

  /**
   * Array of oid
   */
  lazy val OidArray: PgType = PgType("_oid", Oid(1028), Kind.Array(OidType))

  /**
   * access control list
   */
  lazy val Aclitem: PgType = PgType("aclitem", Oid(1033), Kind.Base)

  /**
   * Array of aclitem
   */
  lazy val AclitemArray: PgType = PgType("_aclitem", Oid(1034), Kind.Array(Aclitem))

  /**
   * Array of macaddr
   */
  lazy val MacaddrArray: PgType = PgType("_macaddr", Oid(1040), Kind.Array(Macaddr))

  /**
   * Array of inet
   */
  lazy val InetArray: PgType = PgType("_inet", Oid(1041), Kind.Array(Inet))

  /**
   * char(length), blank-padded string, fixed storage length
   */
  lazy val Bpchar: PgType = PgType("bpchar", Oid(1042), Kind.Base)

  /**
   * varchar(length), non-blank-padded string, variable storage length
   */
  lazy val Varchar: PgType = PgType("varchar", Oid(1043), Kind.Base)

  /**
   * date
   */
  lazy val Date: PgType = PgType("date", Oid(1082), Kind.Base)

  /**
   * time of day
   */
  lazy val Time: PgType = PgType("time", Oid(1083), Kind.Base)

  /**
   * date and time
   */
  lazy val Timestamp: PgType = PgType("timestamp", Oid(1114), Kind.Base)

  /**
   * Array of timestamp
   */
  lazy val TimestampArray: PgType = PgType("_timestamp", Oid(1115), Kind.Array(Timestamp))

  /**
   * Array of date
   */
  lazy val DateArray: PgType = PgType("_date", Oid(1182), Kind.Array(Date))

  /**
   * Array of time
   */
  lazy val TimeArray: PgType = PgType("_time", Oid(1183), Kind.Array(Time))

  /**
   * date and time with time zone
   */
  lazy val Timestamptz: PgType = PgType("timestamptz", Oid(1184), Kind.Base)

  /**
   * Array of timestamptz
   */
  lazy val TimestamptzArray: PgType = PgType("_timestamptz", Oid(1185), Kind.Array(Timestamptz))

  /**
   * @ <number> <units>, time interval
   */
  lazy val Interval: PgType = PgType("interval", Oid(1186), Kind.Base)

  /**
   * Array of interval
   */
  lazy val IntervalArray: PgType = PgType("_interval", Oid(1187), Kind.Array(Interval))

  /**
   * Array of numeric
   */
  lazy val NumericArray: PgType = PgType("_numeric", Oid(1231), Kind.Array(Numeric))

  /**
   * Array of cstring
   */
  lazy val CstringArray: PgType = PgType("_cstring", Oid(1263), Kind.Array(Cstring))

  /**
   * time of day with time zone
   */
  lazy val Timetz: PgType = PgType("timetz", Oid(1266), Kind.Base)

  /**
   * Array of timetz
   */
  lazy val TimetzArray: PgType = PgType("_timetz", Oid(1270), Kind.Array(Timetz))

  /**
   * fixed-length bit string
   */
  lazy val Bit: PgType = PgType("bit", Oid(1560), Kind.Base)

  /**
   * Array of bit
   */
  lazy val BitArray: PgType = PgType("_bit", Oid(1561), Kind.Array(Bit))

  /**
   * variable-length bit string
   */
  lazy val Varbit: PgType = PgType("varbit", Oid(1562), Kind.Base)

  /**
   * Array of varbit
   */
  lazy val VarbitArray: PgType = PgType("_varbit", Oid(1563), Kind.Array(Varbit))

  /**
   * numeric(precision, decimal), arbitrary precision number
   */
  lazy val Numeric: PgType = PgType("numeric", Oid(1700), Kind.Base)

  /**
   * reference to cursor (portal name)
   */
  lazy val Refcursor: PgType = PgType("refcursor", Oid(1790), Kind.Base)

  /**
   * Array of refcursor
   */
  lazy val RefcursorArray: PgType = PgType("_refcursor", Oid(2201), Kind.Array(Refcursor))

  /**
   * registered procedure (with args)
   */
  lazy val Regprocedure: PgType = PgType("regprocedure", Oid(2202), Kind.Base)

  /**
   * registered operator
   */
  lazy val Regoper: PgType = PgType("regoper", Oid(2203), Kind.Base)

  /**
   * registered operator (with args)
   */
  lazy val Regoperator: PgType = PgType("regoperator", Oid(2204), Kind.Base)

  /**
   * registered class
   */
  lazy val Regclass: PgType = PgType("regclass", Oid(2205), Kind.Base)

  /**
   * registered type
   */
  lazy val Regtype: PgType = PgType("regtype", Oid(2206), Kind.Base)

  /**
   * Array of regprocedure
   */
  lazy val RegprocedureArray: PgType = PgType("_regprocedure", Oid(2207), Kind.Array(Regprocedure))

  /**
   * Array of regoper
   */
  lazy val RegoperArray: PgType = PgType("_regoper", Oid(2208), Kind.Array(Regoper))

  /**
   * Array of regoperator
   */
  lazy val RegoperatorArray: PgType = PgType("_regoperator", Oid(2209), Kind.Array(Regoperator))

  /**
   * Array of regclass
   */
  lazy val RegclassArray: PgType = PgType("_regclass", Oid(2210), Kind.Array(Regclass))

  /**
   * Array of regtype
   */
  lazy val RegtypeArray: PgType = PgType("_regtype", Oid(2211), Kind.Array(Regtype))

  /**
   * pseudo-type representing any composite type
   */
  lazy val Record: PgType = PgType("record", Oid(2249), Kind.Pseudo)

  /**
   * C-style string
   */
  lazy val Cstring: PgType = PgType("cstring", Oid(2275), Kind.Pseudo)

  /**
   * pseudo-type representing any type
   */
  lazy val Any: PgType = PgType("any", Oid(2276), Kind.Pseudo)

  /**
   * pseudo-type representing a polymorphic array type
   */
  lazy val Anyarray: PgType = PgType("anyarray", Oid(2277), Kind.Pseudo)

  /**
   * pseudo-type for the result of a function with no real result
   */
  lazy val Void: PgType = PgType("void", Oid(2278), Kind.Pseudo)

  /**
   * pseudo-type for the result of a trigger function
   */
  lazy val Trigger: PgType = PgType("trigger", Oid(2279), Kind.Pseudo)

  /**
   * pseudo-type for the result of a language handler function
   */
  lazy val LanguageHandler: PgType = PgType("language_handler", Oid(2280), Kind.Pseudo)

  /**
   * pseudo-type representing an internal data structure
   */
  lazy val Internal: PgType = PgType("internal", Oid(2281), Kind.Pseudo)

  /**
   * pseudo-type representing a polymorphic base type
   */
  lazy val Anyelement: PgType = PgType("anyelement", Oid(2283), Kind.Pseudo)

  /**
   *
   */
  lazy val RecordArray: PgType = PgType("_record", Oid(2287), Kind.Pseudo)

  /**
   * pseudo-type representing a polymorphic base type that is not an array
   */
  lazy val Anynonarray: PgType = PgType("anynonarray", Oid(2776), Kind.Pseudo)

  /**
   * Array of txid_snapshot
   */
  lazy val TxidSnapshotArray: PgType = PgType("_txid_snapshot", Oid(2949), Kind.Array(TxidSnapshot))

  /**
   * UUID datatype
   */
  lazy val Uuid: PgType = PgType("uuid", Oid(2950), Kind.Base)

  /**
   * Array of uuid
   */
  lazy val UuidArray: PgType = PgType("_uuid", Oid(2951), Kind.Array(Uuid))

  /**
   * txid snapshot
   */
  lazy val TxidSnapshot: PgType = PgType("txid_snapshot", Oid(2970), Kind.Base)

  /**
   * pseudo-type for the result of an FDW handler function
   */
  lazy val FdwHandler: PgType = PgType("fdw_handler", Oid(3115), Kind.Pseudo)

  /**
   * PostgreSQL LSN datatype
   */
  lazy val PgLsn: PgType = PgType("pg_lsn", Oid(3220), Kind.Base)

  /**
   * Array of pg_lsn
   */
  lazy val PgLsnArray: PgType = PgType("_pg_lsn", Oid(3221), Kind.Array(PgLsn))

  /**
   * pseudo-type for the result of a tablesample method function
   */
  lazy val TsmHandler: PgType = PgType("tsm_handler", Oid(3310), Kind.Pseudo)

  /**
   * multivariate ndistinct coefficients
   */
  lazy val PgNdistinct: PgType = PgType("pg_ndistinct", Oid(3361), Kind.Base)

  /**
   * multivariate dependencies
   */
  lazy val PgDependencies: PgType = PgType("pg_dependencies", Oid(3402), Kind.Base)

  /**
   * pseudo-type representing a polymorphic base type that is an enum
   */
  lazy val Anyenum: PgType = PgType("anyenum", Oid(3500), Kind.Pseudo)

  /**
   * text representation for text search
   */
  lazy val TsVector: PgType = PgType("tsvector", Oid(3614), Kind.Base)

  /**
   * query representation for text search
   */
  lazy val Tsquery: PgType = PgType("tsquery", Oid(3615), Kind.Base)

  /**
   * GiST index internal text representation for text search
   */
  lazy val GtsVector: PgType = PgType("gtsvector", Oid(3642), Kind.Base)

  /**
   * Array of tsvector
   */
  lazy val TsVectorArray: PgType = PgType("_tsvector", Oid(3643), Kind.Array(TsVector))

  /**
   * Array of gtsvector
   */
  lazy val GtsVectorArray: PgType = PgType("_gtsvector", Oid(3644), Kind.Array(GtsVector))

  /**
   * Array of tsquery
   */
  lazy val TsqueryArray: PgType = PgType("_tsquery", Oid(3645), Kind.Array(Tsquery))

  /**
   * registered text search configuration
   */
  lazy val Regconfig: PgType = PgType("regconfig", Oid(3734), Kind.Base)

  /**
   * Array of regconfig
   */
  lazy val RegconfigArray: PgType = PgType("_regconfig", Oid(3735), Kind.Array(Regconfig))

  /**
   * registered text search dictionary
   */
  lazy val Regdictionary: PgType = PgType("regdictionary", Oid(3769), Kind.Base)

  /**
   * Array of regdictionary
   */
  lazy val RegdictionaryArray: PgType =
    PgType("_regdictionary", Oid(3770), Kind.Array(Regdictionary))

  /**
   * Binary JSON
   */
  lazy val Jsonb: PgType = PgType("jsonb", Oid(3802), Kind.Base)

  /**
   * Array of jsonb
   */
  lazy val JsonbArray: PgType = PgType("_jsonb", Oid(3807), Kind.Array(Jsonb))

  /**
   * pseudo-type representing a range over a polymorphic base type
   */
  lazy val AnyRange: PgType = PgType("anyrange", Oid(3831), Kind.Pseudo)

  /**
   * pseudo-type for the result of an event trigger function
   */
  lazy val EventTrigger: PgType = PgType("event_trigger", Oid(3838), Kind.Pseudo)

  /**
   * range of integers
   */
  lazy val Int4Range: PgType = PgType("int4range", Oid(3904), Kind.Base)

  /**
   * Array of int4range
   */
  lazy val Int4RangeArray: PgType = PgType("_int4range", Oid(3905), Kind.Array(Int4Range))

  /**
   * range of numerics
   */
  lazy val NumRange: PgType = PgType("numrange", Oid(3906), Kind.Base)

  /**
   * Array of numrange
   */
  lazy val NumRangeArray: PgType = PgType("_numrange", Oid(3907), Kind.Array(NumRange))

  /**
   * range of timestamps without time zone
   */
  lazy val TsRange: PgType = PgType("tsrange", Oid(3908), Kind.Base)

  /**
   * Array of tsrange
   */
  lazy val TsRangeArray: PgType = PgType("_tsrange", Oid(3909), Kind.Array(TsRange))

  /**
   * range of timestamps with time zone
   */
  lazy val TstzRange: PgType = PgType("tstzrange", Oid(3910), Kind.Base)

  /**
   * Array of tstzrange
   */
  lazy val TstzRangeArray: PgType = PgType("_tstzrange", Oid(3911), Kind.Array(TstzRange))

  /**
   * range of dates
   */
  lazy val DateRange: PgType = PgType("daterange", Oid(3912), Kind.Base)

  /**
   * Array of daterange
   */
  lazy val DateRangeArray: PgType = PgType("_daterange", Oid(3913), Kind.Array(DateRange))

  /**
   * range of bigints
   */
  lazy val Int8Range: PgType = PgType("int8range", Oid(3926), Kind.Base)

  /**
   * Array of int8range
   */
  lazy val Int8RangeArray: PgType = PgType("_int8range", Oid(3927), Kind.Array(Int8Range))

  /**
   * JSON path
   */
  lazy val Jsonpath: PgType = PgType("jsonpath", Oid(4072), Kind.Base)

  /**
   * Array of jsonpath
   */
  lazy val JsonpathArray: PgType = PgType("_jsonpath", Oid(4073), Kind.Array(Jsonpath))

  /**
   * registered namespace
   */
  lazy val Regnamespace: PgType = PgType("regnamespace", Oid(4089), Kind.Base)

  /**
   * Array of regnamespace
   */
  lazy val RegnamespaceArray: PgType = PgType("_regnamespace", Oid(4090), Kind.Array(Regnamespace))

  /**
   * registered role
   */
  lazy val Regrole: PgType = PgType("regrole", Oid(4096), Kind.Base)

  /**
   * Array of regrole
   */
  lazy val RegroleArray: PgType = PgType("_regrole", Oid(4097), Kind.Array(Regrole))

  /**
   * registered collation
   */
  lazy val Regcollation: PgType = PgType("regcollation", Oid(4191), Kind.Base)

  /**
   * Array of regcollation
   */
  lazy val RegcollationArray: PgType = PgType("_regcollation", Oid(4192), Kind.Array(Regcollation))

  /**
   * multivariate MCV list
   */
  lazy val PgMcvList: PgType = PgType("pg_mcv_list", Oid(5017), Kind.Base)

  /**
   * snapshot
   */
  lazy val PgSnapshot: PgType = PgType("pg_snapshot", Oid(5038), Kind.Base)

  /**
   * Array of pg_snapshot
   */
  lazy val PgSnapshotArray: PgType = PgType("_pg_snapshot", Oid(5039), Kind.Array(PgSnapshot))

  /**
   * full transaction id
   */
  lazy val Xid8: PgType = PgType("xid8", Oid(5069), Kind.Base)

  /**
   * pseudo-type representing a polymorphic common type
   */
  lazy val Anycompatible: PgType = PgType("anycompatible", Oid(5077), Kind.Pseudo)

  /**
   * pseudo-type representing an array of polymorphic common type elements
   */
  lazy val Anycompatiblearray: PgType = PgType("anycompatiblearray", Oid(5078), Kind.Pseudo)

  /**
   * pseudo-type representing a polymorphic common type that is not an array
   */
  lazy val Anycompatiblenonarray: PgType = PgType("anycompatiblenonarray", Oid(5079), Kind.Pseudo)

  /**
   * pseudo-type representing a range over a polymorphic common type
   */
  lazy val AnycompatibleRange: PgType = PgType("anycompatiblerange", Oid(5080), Kind.Pseudo)
}
