/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis;

import com.twitter.finagle.Service;
import com.twitter.finagle.redis.ServerError;
import com.twitter.finagle.redis.protocol.Auth;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.Command;
import com.twitter.finagle.redis.protocol.EmptyBulkReply;
import com.twitter.finagle.redis.protocol.ErrorReply;
import com.twitter.finagle.redis.protocol.FlushAll$;
import com.twitter.finagle.redis.protocol.FlushDB$;
import com.twitter.finagle.redis.protocol.Info;
import com.twitter.finagle.redis.protocol.Quit$;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.Select;
import com.twitter.finagle.redis.protocol.StatusReply;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001-\u0011!BQ1tK\u000ec\u0017.\u001a8u\u0015\t\u0019A!A\u0003sK\u0012L7O\u0003\u0002\u0006\r\u00059a-\u001b8bO2,'BA\u0004\t\u0003\u001d!x/\u001b;uKJT\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u000fM,'O^5dKB!QC\u0006\r\u001f\u001b\u0005!\u0011BA\f\u0005\u0005\u001d\u0019VM\u001d<jG\u0016\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0002\u0002\u0011A\u0014x\u000e^8d_2L!!\b\u000e\u0003\u000f\r{W.\\1oIB\u0011\u0011dH\u0005\u0003Ai\u0011QAU3qYfDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013'!\t)\u0003!D\u0001\u0003\u0011\u0015\u0019\u0012\u00051\u0001\u0015\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0011\tW\u000f\u001e5\u0015\u0005)\u001a\u0004cA\u0016/a5\tAF\u0003\u0002.\r\u0005!Q\u000f^5m\u0013\tyCF\u0001\u0004GkR,(/\u001a\t\u0003\u001bEJ!A\r\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006i\u001d\u0002\r!N\u0001\ta\u0006\u001c8o^8sIB\u0011agP\u0007\u0002o)\u0011\u0001(O\u0001\u0007EV4g-\u001a:\u000b\u0005iZ\u0014!\u00028fiRL(B\u0001\u001f>\u0003\u0015Q'm\\:t\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000e\u0002\u000e\u0007\"\fgN\\3m\u0005V4g-\u001a:\t\u000b\t\u0003A\u0011A\"\u0002\t%tgm\u001c\u000b\u0003\t\"\u00032a\u000b\u0018F!\ria)N\u0005\u0003\u000f:\u0011aa\u00149uS>t\u0007bB%B!\u0003\u0005\r!N\u0001\bg\u0016\u001cG/[8o\u0011\u0015Y\u0005\u0001\"\u0001M\u0003!1G.^:i\u00032dG#\u0001\u0016\t\u000b9\u0003A\u0011\u0001'\u0002\u000f\u0019dWo\u001d5E\u0005\")\u0001\u000b\u0001C\u0001\u0019\u0006!\u0011/^5u\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003\u0019\u0019X\r\\3diR\u0011!\u0006\u0016\u0005\u0006+F\u0003\rAV\u0001\u0006S:$W\r\u001f\t\u0003\u001b]K!\u0001\u0017\b\u0003\u0007%sG\u000fC\u0003[\u0001\u0011\u0005A*A\u0004sK2,\u0017m]3\t\rq\u0003A\u0011\u0001\u0002^\u0003%!wNU3rk\u0016\u001cH/\u0006\u0002_GR\u0011q,\u001d\u000b\u0003A2\u00042a\u000b\u0018b!\t\u00117\r\u0004\u0001\u0005\u000b\u0011\\&\u0019A3\u0003\u0003Q\u000b\"AZ5\u0011\u000559\u0017B\u00015\u000f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u00046\n\u0005-t!aA!os\")Qn\u0017a\u0001]\u00069\u0001.\u00198eY\u0016\u0014\b\u0003B\u0007p=\u0001L!\u0001\u001d\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:DQA].A\u0002a\t1aY7e\u0011\u0019!\b\u0001\"\u0001\u0003k\u0006Y!/\u001a;ve:\u0004\u0016-\u001b:t)\t1x\u0010E\u0002xurl\u0011\u0001\u001f\u0006\u0003s:\t!bY8mY\u0016\u001cG/[8o\u0013\tY\bPA\u0002TKF\u0004B!D?6k%\u0011aP\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u00051\u000f1\u0001\u0002\u0004\u0005AQ.Z:tC\u001e,7\u000fE\u0003\u0002\u0006\u0005UQG\u0004\u0003\u0002\b\u0005Ea\u0002BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055!\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0019\u00111\u0003\b\u0002\u000fA\f7m[1hK&\u001910a\u0006\u000b\u0007\u0005Ma\u0002C\u0005\u0002\u001c\u0001\t\n\u0011\"\u0001\u0002\u001e\u0005q\u0011N\u001c4pI\u0011,g-Y;mi\u0012\nTCAA\u0010U\r)\u0014\u0011E\u0016\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0006\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0005\u001d\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class BaseClient {
    private final Service<Command, Reply> service;

    public Future<BoxedUnit> auth(ChannelBuffer password) {
        return this.doRequest(new Auth(password), (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x2) {
                Reply reply = x2;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<Option<ChannelBuffer>> info(ChannelBuffer section) {
        return this.doRequest(new Info(section), (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x3) {
                Reply reply = x3;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public ChannelBuffer info$default$1() {
        return ChannelBuffers.EMPTY_BUFFER;
    }

    public Future<BoxedUnit> flushAll() {
        return this.doRequest(FlushAll$.MODULE$, (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x4) {
                Reply reply = x4;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<BoxedUnit> flushDB() {
        return this.doRequest(FlushDB$.MODULE$, (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                A1 A1 = x5;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x5);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x5) {
                Reply reply = x5;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<BoxedUnit> quit() {
        return this.doRequest(Quit$.MODULE$, (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                A1 A1 = x6;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x6);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x6) {
                Reply reply = x6;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<BoxedUnit> select(int index) {
        return this.doRequest(new Select(index), (PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                A1 A1 = x7;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x7);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x7) {
                Reply reply = x7;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public Future<BoxedUnit> release() {
        return this.service.close();
    }

    public <T> Future<T> doRequest(Command cmd, PartialFunction<Reply, Future<T>> handler) {
        return this.service.apply((Object)cmd).flatMap((Function1)handler.orElse((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future future;
                A1 A1 = x1;
                if (A1 instanceof ErrorReply) {
                    ErrorReply errorReply = (ErrorReply)A1;
                    String message = errorReply.message();
                    future = Future$.MODULE$.exception((Throwable)new ServerError(message));
                } else {
                    future = Future$.MODULE$.exception((Throwable)new IllegalStateException());
                }
                return (B1)future;
            }

            public final boolean isDefinedAt(Reply x1) {
                Reply reply = x1;
                boolean bl = reply instanceof ErrorReply ? true : true;
                return bl;
            }
        }));
    }

    public Seq<Tuple2<ChannelBuffer, ChannelBuffer>> returnPairs(Seq<ChannelBuffer> messages) {
        Predef$.MODULE$.assert(messages.length() % 2 == 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Odd number of items in response";
            }
        });
        return (Seq)messages.grouped(2).toSeq().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<ChannelBuffer, ChannelBuffer>> apply(Seq<ChannelBuffer> x0$1) {
                Iterable iterable;
                Seq<ChannelBuffer> seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    ChannelBuffer a = (ChannelBuffer)((SeqLike)some.get()).apply(0);
                    ChannelBuffer b = (ChannelBuffer)((SeqLike)some.get()).apply(1);
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)a, (Object)b)));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public BaseClient(Service<Command, Reply> service) {
        this.service = service;
    }
}

