/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis;

import com.twitter.finagle.redis.BaseClient;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.EmptyBulkReply;
import com.twitter.finagle.redis.protocol.EmptyMBulkReply;
import com.twitter.finagle.redis.protocol.IntegerReply;
import com.twitter.finagle.redis.protocol.MBulkReply;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.commands.BAdd;
import com.twitter.finagle.redis.protocol.commands.BCard;
import com.twitter.finagle.redis.protocol.commands.BGet;
import com.twitter.finagle.redis.protocol.commands.BRange;
import com.twitter.finagle.redis.protocol.commands.BRem;
import com.twitter.finagle.redis.util.ReplyFormat$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import org.jboss.netty.buffer.ChannelBuffer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;

public abstract class BtreeSortedSetCommands$class {
    public static Future bRem(BaseClient $this, ChannelBuffer key, Seq fields) {
        return $this.doRequest(new BRem(key, (Seq<ChannelBuffer>)fields), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x1) {
                Reply reply = x1;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future bGet(BaseClient $this, ChannelBuffer key, ChannelBuffer field) {
        return $this.doRequest(new BGet(key, field), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x2) {
                Reply reply = x2;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future bAdd(BaseClient $this, ChannelBuffer key, ChannelBuffer field, ChannelBuffer value) {
        return $this.doRequest(new BAdd(key, field, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x3) {
                Reply reply = x3;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future bCard(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new BCard(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x4) {
                Reply reply = x4;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future bRange(BaseClient $this, ChannelBuffer key, Option startField, Option endField) {
        return $this.doRequest(new BRange(key, (Option<ChannelBuffer>)startField, (Option<ChannelBuffer>)endField), new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseClient $outer;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x5;
                if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> messages = mBulkReply.messages();
                    object = Future$.MODULE$.value(this.$outer.returnPairs((Seq<ChannelBuffer>)ReplyFormat$.MODULE$.toChannelBuffers(messages)));
                } else {
                    object = A1 instanceof EmptyMBulkReply ? Future$.MODULE$.Nil() : function1.apply(x5);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x5) {
                Reply reply = x5;
                boolean bl = reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void $init$(BaseClient $this) {
    }
}

