/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis;

import com.twitter.finagle.redis.BaseClient;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.Del;
import com.twitter.finagle.redis.protocol.Dump;
import com.twitter.finagle.redis.protocol.EmptyBulkReply;
import com.twitter.finagle.redis.protocol.EmptyMBulkReply;
import com.twitter.finagle.redis.protocol.Exists;
import com.twitter.finagle.redis.protocol.Expire;
import com.twitter.finagle.redis.protocol.ExpireAt;
import com.twitter.finagle.redis.protocol.IntegerReply;
import com.twitter.finagle.redis.protocol.Keys;
import com.twitter.finagle.redis.protocol.MBulkReply;
import com.twitter.finagle.redis.protocol.Move;
import com.twitter.finagle.redis.protocol.PExpire;
import com.twitter.finagle.redis.protocol.PExpireAt;
import com.twitter.finagle.redis.protocol.PTtl;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.Scan;
import com.twitter.finagle.redis.protocol.Ttl;
import com.twitter.finagle.redis.util.ReplyFormat$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Time$;
import org.jboss.netty.buffer.ChannelBuffer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;

public abstract class Keys$class {
    public static Future del(BaseClient $this, Seq keys2) {
        return $this.doRequest(new Del((Seq<ChannelBuffer>)keys2), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x1) {
                Reply reply = x1;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future dump(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new Dump(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x2) {
                Reply reply = x2;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future exists(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new Exists(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x3;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x3) {
                Reply reply = x3;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future expire(BaseClient $this, ChannelBuffer key, Long ttl2) {
        return $this.doRequest(new Expire(key, Predef$.MODULE$.Long2long(ttl2)), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x4;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x4) {
                Reply reply = x4;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future expireAt(BaseClient $this, ChannelBuffer key, Long ttl2) {
        return $this.doRequest(new ExpireAt(key, Time$.MODULE$.fromMilliseconds(Predef$.MODULE$.Long2long(ttl2))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x5;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x5);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x5) {
                Reply reply = x5;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future keys(BaseClient $this, ChannelBuffer pattern) {
        return $this.doRequest(new Keys(pattern), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x6;
                if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> messages = mBulkReply.messages();
                    object = Future$.MODULE$.value(ReplyFormat$.MODULE$.toChannelBuffers(messages));
                } else {
                    object = A1 instanceof EmptyMBulkReply ? Future$.MODULE$.Nil() : function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x6) {
                Reply reply = x6;
                boolean bl = reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply;
                return bl;
            }
        });
    }

    public static Future move(BaseClient $this, ChannelBuffer key, ChannelBuffer db) {
        return $this.doRequest(new Move(key, db), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x7;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x7);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x7) {
                Reply reply = x7;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future pExpire(BaseClient $this, ChannelBuffer key, Long milliseconds) {
        return $this.doRequest(new PExpire(key, Predef$.MODULE$.Long2long(milliseconds)), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x8;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x8);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x8) {
                Reply reply = x8;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future pExpireAt(BaseClient $this, ChannelBuffer key, Long timestamp) {
        return $this.doRequest(new PExpireAt(key, Time$.MODULE$.fromMilliseconds(Predef$.MODULE$.Long2long(timestamp))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x9;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x9);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x9) {
                Reply reply = x9;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future pTtl(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new PTtl(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x10;
                Object object = A1 instanceof IntegerReply ? ((n = (integerReply = (IntegerReply)A1).id()) != -1L ? Future$.MODULE$.value((Object)new Some((Object)Predef$.MODULE$.long2Long(n))) : Future$.MODULE$.value((Object)None$.MODULE$)) : function1.apply(x10);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x10) {
                Reply reply = x10;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future scan(BaseClient $this, Long cursor, Option count, Option pattern) {
        return $this.doRequest(new Scan(Predef$.MODULE$.Long2long(cursor), (Option<Long>)count, (Option<ChannelBuffer>)pattern), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x11;
                if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> messages = mBulkReply.messages();
                    object = Future$.MODULE$.value(ReplyFormat$.MODULE$.toChannelBuffers(messages));
                } else {
                    object = A1 instanceof EmptyMBulkReply ? Future$.MODULE$.Nil() : function1.apply(x11);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x11) {
                Reply reply = x11;
                boolean bl = reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply;
                return bl;
            }
        });
    }

    public static Future ttl(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new Ttl(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x12;
                Object object = A1 instanceof IntegerReply ? ((n = (integerReply = (IntegerReply)A1).id()) != -1L ? Future$.MODULE$.value((Object)new Some((Object)Predef$.MODULE$.long2Long(n))) : Future$.MODULE$.value((Object)None$.MODULE$)) : function1.apply(x12);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x12) {
                Reply reply = x12;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static void $init$(BaseClient $this) {
    }
}

