/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis;

import com.twitter.finagle.redis.BaseClient;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.EmptyBulkReply;
import com.twitter.finagle.redis.protocol.EmptyMBulkReply;
import com.twitter.finagle.redis.protocol.IntegerReply;
import com.twitter.finagle.redis.protocol.LIndex;
import com.twitter.finagle.redis.protocol.LInsert;
import com.twitter.finagle.redis.protocol.LLen;
import com.twitter.finagle.redis.protocol.LPop;
import com.twitter.finagle.redis.protocol.LPush;
import com.twitter.finagle.redis.protocol.LRange;
import com.twitter.finagle.redis.protocol.LRem;
import com.twitter.finagle.redis.protocol.LSet;
import com.twitter.finagle.redis.protocol.LTrim;
import com.twitter.finagle.redis.protocol.MBulkReply;
import com.twitter.finagle.redis.protocol.RPop;
import com.twitter.finagle.redis.protocol.RPush;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.StatusReply;
import com.twitter.finagle.redis.util.ReplyFormat$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import org.jboss.netty.buffer.ChannelBuffer;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public abstract class Lists$class {
    public static Future lLen(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new LLen(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x1) {
                Reply reply = x1;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future lIndex(BaseClient $this, ChannelBuffer key, Long index) {
        return $this.doRequest(new LIndex(key, Predef$.MODULE$.Long2long(index)), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x2) {
                Reply reply = x2;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future lInsertAfter(BaseClient $this, ChannelBuffer key, ChannelBuffer pivot, ChannelBuffer value) {
        return $this.doRequest(new LInsert(key, "AFTER", pivot, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x3;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((n = (integerReply = (IntegerReply)A1).id()) == -1L ? None$.MODULE$ : new Some((Object)Predef$.MODULE$.long2Long(n))) : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x3) {
                Reply reply = x3;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future lInsertBefore(BaseClient $this, ChannelBuffer key, ChannelBuffer pivot, ChannelBuffer value) {
        return $this.doRequest(new LInsert(key, "BEFORE", pivot, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x4;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((n = (integerReply = (IntegerReply)A1).id()) == -1L ? None$.MODULE$ : new Some((Object)Predef$.MODULE$.long2Long(n))) : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x4) {
                Reply reply = x4;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future lPop(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new LPop(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x5;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x5);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x5) {
                Reply reply = x5;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future lPush(BaseClient $this, ChannelBuffer key, List value) {
        return $this.doRequest(new LPush(key, (Seq<ChannelBuffer>)value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x6;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x6) {
                Reply reply = x6;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future lRem(BaseClient $this, ChannelBuffer key, Long count, ChannelBuffer value) {
        return $this.doRequest(new LRem(key, Predef$.MODULE$.Long2long(count), value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x7;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x7);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x7) {
                Reply reply = x7;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future lSet(BaseClient $this, ChannelBuffer key, Long index, ChannelBuffer value) {
        return $this.doRequest(new LSet(key, Predef$.MODULE$.Long2long(index), value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                A1 A1 = x8;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x8);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x8) {
                Reply reply = x8;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public static Future lRange(BaseClient $this, ChannelBuffer key, Long start2, Long end) {
        return $this.doRequest(new LRange(key, Predef$.MODULE$.Long2long(start2), Predef$.MODULE$.Long2long(end)), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x9;
                if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> message = mBulkReply.messages();
                    object = Future$.MODULE$.value(ReplyFormat$.MODULE$.toChannelBuffers(message));
                } else {
                    object = A1 instanceof EmptyMBulkReply ? Future$.MODULE$.value((Object)Nil$.MODULE$) : function1.apply(x9);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x9) {
                Reply reply = x9;
                boolean bl = reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply;
                return bl;
            }
        });
    }

    public static Future rPop(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new RPop(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x10;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x10);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x10) {
                Reply reply = x10;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future rPush(BaseClient $this, ChannelBuffer key, List value) {
        return $this.doRequest(new RPush(key, (List<ChannelBuffer>)value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x11;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x11);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x11) {
                Reply reply = x11;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future lTrim(BaseClient $this, ChannelBuffer key, Long start2, Long end) {
        return $this.doRequest(new LTrim(key, Predef$.MODULE$.Long2long(start2), Predef$.MODULE$.Long2long(end)), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                A1 A1 = x12;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x12);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x12) {
                Reply reply = x12;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public static void $init$(BaseClient $this) {
    }
}

