/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis;

import com.twitter.finagle.redis.BaseClient;
import com.twitter.finagle.redis.SortedSets;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.EmptyBulkReply;
import com.twitter.finagle.redis.protocol.EmptyMBulkReply;
import com.twitter.finagle.redis.protocol.IntegerReply;
import com.twitter.finagle.redis.protocol.Limit;
import com.twitter.finagle.redis.protocol.MBulkReply;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.WithScores$;
import com.twitter.finagle.redis.protocol.ZAdd;
import com.twitter.finagle.redis.protocol.ZCard;
import com.twitter.finagle.redis.protocol.ZCount;
import com.twitter.finagle.redis.protocol.ZIncrBy;
import com.twitter.finagle.redis.protocol.ZInterval;
import com.twitter.finagle.redis.protocol.ZMember;
import com.twitter.finagle.redis.protocol.ZRange;
import com.twitter.finagle.redis.protocol.ZRangeByScore;
import com.twitter.finagle.redis.protocol.ZRangeResults;
import com.twitter.finagle.redis.protocol.ZRangeResults$;
import com.twitter.finagle.redis.protocol.ZRank;
import com.twitter.finagle.redis.protocol.ZRem;
import com.twitter.finagle.redis.protocol.ZRemRangeByRank;
import com.twitter.finagle.redis.protocol.ZRemRangeByScore;
import com.twitter.finagle.redis.protocol.ZRevRange;
import com.twitter.finagle.redis.protocol.ZRevRangeByScore;
import com.twitter.finagle.redis.protocol.ZRevRank;
import com.twitter.finagle.redis.protocol.ZScore;
import com.twitter.finagle.redis.util.BytesToString$;
import com.twitter.finagle.redis.util.NumberFormat$;
import com.twitter.finagle.redis.util.ReplyFormat$;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import org.jboss.netty.buffer.ChannelBuffer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.util.Either;

public abstract class SortedSets$class {
    public static PartialFunction com$twitter$finagle$redis$SortedSets$$parseMBulkReply(BaseClient $this, Boolean withScores) {
        Serializable parse = new Serializable($this, withScores){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseClient $outer;
            private final Boolean withScores$1;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> messages = mBulkReply.messages();
                    object = SortedSets$class.com$twitter$finagle$redis$SortedSets$$withScoresHelper((BaseClient)((Object)((SortedSets)((Object)this.$outer))), this.withScores$1, messages);
                } else {
                    object = A1 instanceof EmptyMBulkReply ? SortedSets$class.com$twitter$finagle$redis$SortedSets$$withScoresHelper((BaseClient)((Object)((SortedSets)((Object)this.$outer))), this.withScores$1, (List)Nil$.MODULE$) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x1) {
                Reply reply = x1;
                boolean bl = reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.withScores$1 = withScores$1;
            }
        };
        return parse.andThen((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Future<Either<ZRangeResults, Seq<ChannelBuffer>>> apply(Either<ZRangeResults, Seq<ChannelBuffer>> a) {
                return Future$.MODULE$.value(a);
            }
        });
    }

    public static Either com$twitter$finagle$redis$SortedSets$$withScoresHelper(BaseClient $this, Boolean withScores, List messages) {
        List<ChannelBuffer> chanBufs = ReplyFormat$.MODULE$.toChannelBuffers((List<Reply>)messages);
        return Predef$.MODULE$.Boolean2boolean(withScores) ? package$.MODULE$.Left().apply((Object)ZRangeResults$.MODULE$.apply($this.returnPairs((Seq<ChannelBuffer>)chanBufs))) : package$.MODULE$.Right().apply(chanBufs);
    }

    public static Future zAdd(BaseClient $this, ChannelBuffer key, Double score, ChannelBuffer member) {
        return ((SortedSets)((Object)$this)).zAddMulti(key, (Seq<Tuple2<Double, ChannelBuffer>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)score, (Object)member)}))));
    }

    public static Future zAddMulti(BaseClient $this, ChannelBuffer key, Seq members) {
        return $this.doRequest(new ZAdd(key, (Seq<ZMember>)((Seq)members.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ZMember apply(Tuple2<Double, ChannelBuffer> m) {
                return new ZMember(Predef$.MODULE$.Double2double((Double)m._1()), (ChannelBuffer)m._2());
            }
        }, Seq$.MODULE$.canBuildFrom()))), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x2) {
                Reply reply = x2;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future zCard(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new ZCard(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x3) {
                Reply reply = x3;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future zCount(BaseClient $this, ChannelBuffer key, ZInterval min, ZInterval max) {
        return $this.doRequest(new ZCount(key, min, max), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x4) {
                Reply reply = x4;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future zRangeByScore(BaseClient $this, ChannelBuffer key, ZInterval min, ZInterval max, Boolean withScores, Option limit) {
        return $this.doRequest(new ZRangeByScore(key, min, max, WithScores$.MODULE$.option(Predef$.MODULE$.Boolean2boolean(withScores)), (Option<Limit>)limit), SortedSets$class.com$twitter$finagle$redis$SortedSets$$parseMBulkReply((BaseClient)((Object)((SortedSets)((Object)$this))), withScores));
    }

    public static Future zRem(BaseClient $this, ChannelBuffer key, Seq members) {
        return $this.doRequest(new ZRem(key, (Seq<ChannelBuffer>)members), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x5;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x5);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x5) {
                Reply reply = x5;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future zRevRange(BaseClient $this, ChannelBuffer key, Long start2, Long stop2, Boolean withScores) {
        return $this.doRequest(new ZRevRange(key, Predef$.MODULE$.Long2long(start2), Predef$.MODULE$.Long2long(stop2), WithScores$.MODULE$.option(Predef$.MODULE$.Boolean2boolean(withScores))), SortedSets$class.com$twitter$finagle$redis$SortedSets$$parseMBulkReply((BaseClient)((Object)((SortedSets)((Object)$this))), withScores));
    }

    public static Future zRevRangeByScore(BaseClient $this, ChannelBuffer key, ZInterval max, ZInterval min, Boolean withScores, Option limit) {
        return $this.doRequest(new ZRevRangeByScore(key, max, min, WithScores$.MODULE$.option(Predef$.MODULE$.Boolean2boolean(withScores)), (Option<Limit>)limit), SortedSets$class.com$twitter$finagle$redis$SortedSets$$parseMBulkReply((BaseClient)((Object)((SortedSets)((Object)$this))), withScores));
    }

    public static Future zScore(BaseClient $this, ChannelBuffer key, ChannelBuffer member) {
        return $this.doRequest(new ZScore(key, member), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x6;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)Predef$.MODULE$.double2Double(NumberFormat$.MODULE$.toDouble(BytesToString$.MODULE$.apply(message.array(), BytesToString$.MODULE$.apply$default$2())))));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x6) {
                Reply reply = x6;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future zRevRank(BaseClient $this, ChannelBuffer key, ChannelBuffer member) {
        return $this.doRequest(new ZRevRank(key, member), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x7;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)new Some((Object)Predef$.MODULE$.long2Long(n)));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x7);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x7) {
                Reply reply = x7;
                boolean bl = reply instanceof IntegerReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future zIncrBy(BaseClient $this, ChannelBuffer key, Double amount, ChannelBuffer member) {
        return $this.doRequest(new ZIncrBy(key, Predef$.MODULE$.Double2double(amount), member), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x8;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)Predef$.MODULE$.double2Double(NumberFormat$.MODULE$.toDouble(BytesToString$.MODULE$.apply(message.array(), BytesToString$.MODULE$.apply$default$2())))));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x8);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x8) {
                Reply reply = x8;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future zRank(BaseClient $this, ChannelBuffer key, ChannelBuffer member) {
        return $this.doRequest(new ZRank(key, member), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x9;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)new Some((Object)Predef$.MODULE$.long2Long(n)));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x9);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x9) {
                Reply reply = x9;
                boolean bl = reply instanceof IntegerReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future zRemRangeByRank(BaseClient $this, ChannelBuffer key, Long start2, Long stop2) {
        return $this.doRequest(new ZRemRangeByRank(key, Predef$.MODULE$.Long2long(start2), Predef$.MODULE$.Long2long(stop2)), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x10;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x10);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x10) {
                Reply reply = x10;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future zRemRangeByScore(BaseClient $this, ChannelBuffer key, ZInterval min, ZInterval max) {
        return $this.doRequest(new ZRemRangeByScore(key, min, max), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x11;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x11);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x11) {
                Reply reply = x11;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future zRange(BaseClient $this, ChannelBuffer key, Long start2, Long stop2, Boolean withScores) {
        return $this.doRequest(new ZRange(key, Predef$.MODULE$.Long2long(start2), Predef$.MODULE$.Long2long(stop2), WithScores$.MODULE$.option(Predef$.MODULE$.Boolean2boolean(withScores))), SortedSets$class.com$twitter$finagle$redis$SortedSets$$parseMBulkReply((BaseClient)((Object)((SortedSets)((Object)$this))), withScores));
    }

    public static void $init$(BaseClient $this) {
    }
}

