/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis;

import com.twitter.finagle.redis.BaseClient;
import com.twitter.finagle.redis.protocol.Append;
import com.twitter.finagle.redis.protocol.BitCount;
import com.twitter.finagle.redis.protocol.BitOp;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.Decr;
import com.twitter.finagle.redis.protocol.DecrBy$;
import com.twitter.finagle.redis.protocol.EmptyBulkReply;
import com.twitter.finagle.redis.protocol.EmptyMBulkReply;
import com.twitter.finagle.redis.protocol.Get;
import com.twitter.finagle.redis.protocol.GetBit;
import com.twitter.finagle.redis.protocol.GetRange;
import com.twitter.finagle.redis.protocol.GetSet;
import com.twitter.finagle.redis.protocol.InMilliseconds;
import com.twitter.finagle.redis.protocol.InSeconds;
import com.twitter.finagle.redis.protocol.Incr;
import com.twitter.finagle.redis.protocol.IncrBy$;
import com.twitter.finagle.redis.protocol.IntegerReply;
import com.twitter.finagle.redis.protocol.MBulkReply;
import com.twitter.finagle.redis.protocol.MGet;
import com.twitter.finagle.redis.protocol.MSet;
import com.twitter.finagle.redis.protocol.MSetNx;
import com.twitter.finagle.redis.protocol.PSetEx;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.Set;
import com.twitter.finagle.redis.protocol.Set$;
import com.twitter.finagle.redis.protocol.SetBit;
import com.twitter.finagle.redis.protocol.SetEx;
import com.twitter.finagle.redis.protocol.SetNx;
import com.twitter.finagle.redis.protocol.SetRange;
import com.twitter.finagle.redis.protocol.StatusReply;
import com.twitter.finagle.redis.protocol.Strlen;
import com.twitter.finagle.redis.protocol.TimeToLive;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import org.jboss.netty.buffer.ChannelBuffer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;

public abstract class Strings$class {
    public static Future append(BaseClient $this, ChannelBuffer key, ChannelBuffer value) {
        return $this.doRequest(new Append(key, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x1) {
                Reply reply = x1;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future bitCount(BaseClient $this, ChannelBuffer key, Option start2, Option end) {
        return $this.doRequest(new BitCount(key, (Option<Object>)start2, (Option<Object>)end), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x2) {
                Reply reply = x2;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Option bitCount$default$2(BaseClient $this) {
        return None$.MODULE$;
    }

    public static Option bitCount$default$3(BaseClient $this) {
        return None$.MODULE$;
    }

    public static Future bitOp(BaseClient $this, ChannelBuffer op, ChannelBuffer dstKey, Seq srcKeys) {
        return $this.doRequest(new BitOp(op, dstKey, (Seq<ChannelBuffer>)srcKeys), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x3) {
                Reply reply = x3;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future decr(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new Decr(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x4) {
                Reply reply = x4;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future decrBy(BaseClient $this, ChannelBuffer key, long amount) {
        return $this.doRequest(DecrBy$.MODULE$.apply(key, amount), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x5;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x5);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x5) {
                Reply reply = x5;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future get(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new Get(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x6;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x6) {
                Reply reply = x6;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future getBit(BaseClient $this, ChannelBuffer key, int offset) {
        return $this.doRequest(new GetBit(key, offset), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x7;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x7);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x7) {
                Reply reply = x7;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future getRange(BaseClient $this, ChannelBuffer key, long start2, long end) {
        return $this.doRequest(new GetRange(key, start2, end), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x8;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x8);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x8) {
                Reply reply = x8;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future getSet(BaseClient $this, ChannelBuffer key, ChannelBuffer value) {
        return $this.doRequest(new GetSet(key, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x9;
                if (A1 instanceof BulkReply) {
                    BulkReply bulkReply = (BulkReply)A1;
                    ChannelBuffer message = bulkReply.message();
                    object = Future$.MODULE$.value((Object)new Some((Object)message));
                } else {
                    object = A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)None$.MODULE$) : function1.apply(x9);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x9) {
                Reply reply = x9;
                boolean bl = reply instanceof BulkReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future incr(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new Incr(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x10;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x10);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x10) {
                Reply reply = x10;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future incrBy(BaseClient $this, ChannelBuffer key, long increment) {
        return $this.doRequest(IncrBy$.MODULE$.apply(key, increment), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x11;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x11);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x11) {
                Reply reply = x11;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future mGet(BaseClient $this, Seq keys2) {
        return $this.doRequest(new MGet((Seq<ChannelBuffer>)keys2), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x12;
                if (A1 instanceof MBulkReply) {
                    MBulkReply mBulkReply = (MBulkReply)A1;
                    List<Reply> messages = mBulkReply.messages();
                    object = Future$.MODULE$.apply((Function0)new Serializable(this, messages){
                        public static final long serialVersionUID = 0L;
                        private final List messages$1;

                        public final scala.collection.immutable.Seq<Option<ChannelBuffer>> apply() {
                            return ((scala.collection.immutable.Seq)this.messages$1.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Option<ChannelBuffer> apply(Reply x0$1) {
                                    block4: {
                                        None$ none$;
                                        block3: {
                                            Reply reply;
                                            block2: {
                                                reply = x0$1;
                                                if (!(reply instanceof BulkReply)) break block2;
                                                BulkReply bulkReply = (BulkReply)reply;
                                                ChannelBuffer message = bulkReply.message();
                                                none$ = new Some((Object)message);
                                                break block3;
                                            }
                                            if (!(reply instanceof EmptyBulkReply)) break block4;
                                            none$ = None$.MODULE$;
                                        }
                                        return none$;
                                    }
                                    throw new IllegalStateException();
                                }
                            }, List$.MODULE$.canBuildFrom())).toSeq();
                        }
                        {
                            this.messages$1 = messages$1;
                        }
                    });
                } else {
                    object = A1 instanceof EmptyMBulkReply ? Future$.MODULE$.Nil() : function1.apply(x12);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x12) {
                Reply reply = x12;
                boolean bl = reply instanceof MBulkReply ? true : reply instanceof EmptyMBulkReply;
                return bl;
            }
        });
    }

    public static Future mSet(BaseClient $this, Map kv) {
        return $this.doRequest(new MSet((Map<ChannelBuffer, ChannelBuffer>)kv), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                A1 A1 = x13;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x13);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x13) {
                Reply reply = x13;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public static Future mSetNx(BaseClient $this, Map kv) {
        return $this.doRequest(new MSetNx((Map<ChannelBuffer, ChannelBuffer>)kv), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x14;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x14);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x14) {
                Reply reply = x14;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future pSetEx(BaseClient $this, ChannelBuffer key, long millis, ChannelBuffer value) {
        return $this.doRequest(new PSetEx(key, millis, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                A1 A1 = x15;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x15);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x15) {
                Reply reply = x15;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public static Future set(BaseClient $this, ChannelBuffer key, ChannelBuffer value) {
        return $this.doRequest(new Set(key, value, Set$.MODULE$.apply$default$3(), Set$.MODULE$.apply$default$4(), Set$.MODULE$.apply$default$5()), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                A1 A1 = x16;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x16);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x16) {
                Reply reply = x16;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public static Future setBit(BaseClient $this, ChannelBuffer key, int offset, int value) {
        return $this.doRequest(new SetBit(key, offset, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x17, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x17;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x17);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x17) {
                Reply reply = x17;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future setEx(BaseClient $this, ChannelBuffer key, long seconds, ChannelBuffer value) {
        return $this.doRequest(new SetEx(key, seconds, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x18, Function1<A1, B1> function1) {
                A1 A1 = x18;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x18);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x18) {
                Reply reply = x18;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public static Future setExNx(BaseClient $this, ChannelBuffer key, long seconds, ChannelBuffer value) {
        return $this.doRequest(new Set(key, value, (Option<TimeToLive>)new Some((Object)new InSeconds(seconds)), true, false), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x19, Function1<A1, B1> function1) {
                A1 A1 = x19;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(true)) : (A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(false)) : function1.apply(x19));
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x19) {
                Reply reply = x19;
                boolean bl = reply instanceof StatusReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future setExXx(BaseClient $this, ChannelBuffer key, long seconds, ChannelBuffer value) {
        return $this.doRequest(new Set(key, value, (Option<TimeToLive>)new Some((Object)new InSeconds(seconds)), false, true), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x20, Function1<A1, B1> function1) {
                A1 A1 = x20;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(true)) : (A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(false)) : function1.apply(x20));
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x20) {
                Reply reply = x20;
                boolean bl = reply instanceof StatusReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future setNx(BaseClient $this, ChannelBuffer key, ChannelBuffer value) {
        return $this.doRequest(new SetNx(key, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x21, Function1<A1, B1> function1) {
                IntegerReply integerReply;
                long n;
                A1 A1 = x21;
                Object object = A1 instanceof IntegerReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean((n = (integerReply = (IntegerReply)A1).id()) == 1L)) : function1.apply(x21);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x21) {
                Reply reply = x21;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future setPx(BaseClient $this, ChannelBuffer key, long millis, ChannelBuffer value) {
        return $this.doRequest(new Set(key, value, (Option<TimeToLive>)new Some((Object)new InMilliseconds(millis)), Set$.MODULE$.apply$default$4(), Set$.MODULE$.apply$default$5()), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x22, Function1<A1, B1> function1) {
                A1 A1 = x22;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.Unit() : function1.apply(x22);
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x22) {
                Reply reply = x22;
                boolean bl = reply instanceof StatusReply;
                return bl;
            }
        });
    }

    public static Future setPxNx(BaseClient $this, ChannelBuffer key, long millis, ChannelBuffer value) {
        return $this.doRequest(new Set(key, value, (Option<TimeToLive>)new Some((Object)new InMilliseconds(millis)), true, false), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x23, Function1<A1, B1> function1) {
                A1 A1 = x23;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(true)) : (A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(false)) : function1.apply(x23));
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x23) {
                Reply reply = x23;
                boolean bl = reply instanceof StatusReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future setPxXx(BaseClient $this, ChannelBuffer key, long millis, ChannelBuffer value) {
        return $this.doRequest(new Set(key, value, (Option<TimeToLive>)new Some((Object)new InMilliseconds(millis)), false, true), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x24, Function1<A1, B1> function1) {
                A1 A1 = x24;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(true)) : (A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(false)) : function1.apply(x24));
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x24) {
                Reply reply = x24;
                boolean bl = reply instanceof StatusReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future setXx(BaseClient $this, ChannelBuffer key, ChannelBuffer value) {
        return $this.doRequest(new Set(key, value, (Option<TimeToLive>)None$.MODULE$, false, true), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x25, Function1<A1, B1> function1) {
                A1 A1 = x25;
                Object object = A1 instanceof StatusReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(true)) : (A1 instanceof EmptyBulkReply ? Future$.MODULE$.value((Object)Predef$.MODULE$.boolean2Boolean(false)) : function1.apply(x25));
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x25) {
                Reply reply = x25;
                boolean bl = reply instanceof StatusReply ? true : reply instanceof EmptyBulkReply;
                return bl;
            }
        });
    }

    public static Future setRange(BaseClient $this, ChannelBuffer key, int offset, ChannelBuffer value) {
        return $this.doRequest(new SetRange(key, offset, value), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x26, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x26;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x26);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x26) {
                Reply reply = x26;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static Future strlen(BaseClient $this, ChannelBuffer key) {
        return $this.doRequest(new Strlen(key), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Reply, B1> B1 applyOrElse(A1 x27, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x27;
                if (A1 instanceof IntegerReply) {
                    IntegerReply integerReply = (IntegerReply)A1;
                    long n = integerReply.id();
                    object = Future$.MODULE$.value((Object)Predef$.MODULE$.long2Long(n));
                } else {
                    object = function1.apply(x27);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Reply x27) {
                Reply reply = x27;
                boolean bl = reply instanceof IntegerReply;
                return bl;
            }
        });
    }

    public static void $init$(BaseClient $this) {
    }
}

