/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis.naggati.codec;

import com.twitter.finagle.redis.naggati.Codec;
import com.twitter.finagle.redis.naggati.Encoder;
import com.twitter.finagle.redis.naggati.NextStep;
import com.twitter.finagle.redis.naggati.ProtocolError;
import com.twitter.finagle.redis.naggati.Stage;
import com.twitter.finagle.redis.naggati.Stages$;
import com.twitter.finagle.redis.naggati.codec.MemcacheRequest;
import com.twitter.finagle.redis.naggati.codec.MemcacheResponse;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class MemcacheCodec$ {
    public static final MemcacheCodec$ MODULE$;
    private final List<String> STORAGE_COMMANDS;
    private final byte[] END;
    private final byte[] CRLF;
    private final Stage readAscii;
    private final Object writeAscii;

    static {
        new MemcacheCodec$();
    }

    public List<String> STORAGE_COMMANDS() {
        return this.STORAGE_COMMANDS;
    }

    public byte[] END() {
        return this.END;
    }

    public byte[] CRLF() {
        return this.CRLF;
    }

    public Codec<MemcacheResponse> asciiCodec(Function1<Object, BoxedUnit> bytesReadCounter, Function1<Object, BoxedUnit> bytesWrittenCounter) {
        return new Codec<MemcacheResponse>(this.readAscii(), (Encoder<MemcacheResponse>)this.writeAscii(), bytesReadCounter, bytesWrittenCounter, (Manifest<MemcacheResponse>)ManifestFactory$.MODULE$.classType(MemcacheResponse.class));
    }

    public Codec<MemcacheResponse> asciiCodec() {
        return new Codec<MemcacheResponse>(this.readAscii(), (Encoder<MemcacheResponse>)this.writeAscii(), (Manifest<MemcacheResponse>)ManifestFactory$.MODULE$.classType(MemcacheResponse.class));
    }

    public Stage readAscii() {
        return this.readAscii;
    }

    public Object writeAscii() {
        return this.writeAscii;
    }

    private MemcacheCodec$() {
        MODULE$ = this;
        this.STORAGE_COMMANDS = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"set", "add", "replace", "append", "prepend", "cas"}));
        this.END = "\r\nEND\r\n".getBytes();
        this.CRLF = "\r\n".getBytes();
        this.readAscii = Stages$.MODULE$.readLine(true, "ISO-8859-1", (Function1<String, NextStep>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final NextStep apply(String line) {
                NextStep nextStep;
                String[] segments = line.split(" ");
                segments[0] = segments[0].toLowerCase();
                String command = segments[0];
                if (MemcacheCodec$.MODULE$.STORAGE_COMMANDS().contains((Object)command)) {
                    if (segments.length < 5) {
                        throw new ProtocolError("Malformed request line");
                    }
                    int dataBytes = new StringOps(Predef$.MODULE$.augmentString(segments[4])).toInt();
                    nextStep = Stages$.MODULE$.stageToNextStep(Stages$.MODULE$.ensureBytes(dataBytes + 2, (Function1<ChannelBuffer, NextStep>)new Serializable(this, segments, dataBytes, line){
                        public static final long serialVersionUID = 0L;
                        private final String[] segments$1;
                        private final int dataBytes$1;
                        private final String line$1;

                        public final NextStep apply(ChannelBuffer buffer) {
                            ByteBuffer bytes = ByteBuffer.allocate(this.dataBytes$1);
                            buffer.readBytes(bytes);
                            bytes.flip();
                            buffer.skipBytes(2);
                            return Stages$.MODULE$.emit(new MemcacheRequest((List<String>)Predef$.MODULE$.refArrayOps((Object[])this.segments$1).toList(), (Option<ByteBuffer>)new Some((Object)bytes), this.line$1.length() + this.dataBytes$1 + 4));
                        }
                        {
                            this.segments$1 = segments$1;
                            this.dataBytes$1 = dataBytes$1;
                            this.line$1 = line$1;
                        }
                    }));
                } else {
                    nextStep = Stages$.MODULE$.emit(new MemcacheRequest((List<String>)Predef$.MODULE$.refArrayOps((Object[])segments).toList(), (Option<ByteBuffer>)None$.MODULE$, line.length() + 2));
                }
                return nextStep;
            }
        });
        this.writeAscii = new Encoder<MemcacheResponse>(){

            public Option<ChannelBuffer> encode(MemcacheResponse obj) {
                return obj.writeAscii();
            }
        };
    }
}

