/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis.protocol;

import com.twitter.finagle.redis.ClientError;
import com.twitter.finagle.redis.protocol.Aggregate;
import com.twitter.finagle.redis.protocol.Aggregate$;
import com.twitter.finagle.redis.protocol.RequireClientProtocol$;
import com.twitter.finagle.redis.protocol.Weights;
import com.twitter.finagle.redis.protocol.Weights$;
import com.twitter.finagle.redis.protocol.ZStore;
import com.twitter.finagle.redis.protocol.ZStoreCompanion;
import com.twitter.finagle.redis.util.BytesToString$;
import com.twitter.finagle.redis.util.NumberFormat$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public abstract class ZStoreCompanion$class {
    public static ZStore apply(ZStoreCompanion $this, String dest, Seq keys2) {
        return $this.get(dest, keys2.length(), (Seq<String>)keys2, (Option<Weights>)None$.MODULE$, (Option<Aggregate>)None$.MODULE$);
    }

    public static ZStore apply(ZStoreCompanion $this, String dest, Seq keys2, Weights weights) {
        return $this.get(dest, keys2.length(), (Seq<String>)keys2, (Option<Weights>)new Some((Object)weights), (Option<Aggregate>)None$.MODULE$);
    }

    public static ZStore apply(ZStoreCompanion $this, String dest, Seq keys2, Aggregate agg) {
        return $this.get(dest, keys2.length(), (Seq<String>)keys2, (Option<Weights>)None$.MODULE$, (Option<Aggregate>)new Some((Object)agg));
    }

    public static ZStore apply(ZStoreCompanion $this, String dest, Seq keys2, Weights weights, Aggregate agg) {
        return $this.get(dest, keys2.length(), (Seq<String>)keys2, (Option<Weights>)new Some((Object)weights), (Option<Aggregate>)new Some((Object)agg));
    }

    public static ZStore apply(ZStoreCompanion $this, Seq args) {
        block4: {
            block7: {
                ZStore zStore;
                block6: {
                    int n;
                    int numkeys;
                    List tail;
                    String destination;
                    block5: {
                        Seq<String> seq = BytesToString$.MODULE$.fromList((Seq<byte[]>)args, BytesToString$.MODULE$.fromList$default$2());
                        if (!(seq instanceof .colon.colon)) break block4;
                        .colon.colon colon2 = (.colon.colon)seq;
                        destination = (String)colon2.head();
                        List list = colon2.tl$1();
                        if (!(list instanceof .colon.colon)) break block4;
                        .colon.colon colon3 = (.colon.colon)list;
                        String nk = (String)colon3.head();
                        tail = colon3.tl$1();
                        numkeys = BoxesRunTime.unboxToInt(RequireClientProtocol$.MODULE$.safe(new Serializable($this, nk){
                            public static final long serialVersionUID = 0L;
                            private final String nk$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return NumberFormat$.MODULE$.toInt(this.nk$1);
                            }
                            {
                                this.nk$1 = nk$1;
                            }
                        }));
                        n = tail.size();
                        switch (n) {
                            default: 
                        }
                        if (n != numkeys) break block5;
                        zStore = $this.get(destination, numkeys, (Seq<String>)tail, (Option<Weights>)None$.MODULE$, (Option<Aggregate>)None$.MODULE$);
                        break block6;
                    }
                    if (n <= numkeys) break block7;
                    zStore = $this.parseArgs(destination, numkeys, (Seq<String>)tail);
                }
                ZStore zStore2 = zStore;
                return zStore2;
            }
            throw new ClientError("Specified keys must equal numkeys");
        }
        throw new ClientError("Expected a minimum of 3 arguments for command");
    }

    public static ZStore parseArgs(ZStoreCompanion $this, String dest, int numkeys, Seq remaining) {
        Tuple2 tuple2;
        block2: {
            boolean bl;
            block5: {
                Tuple2<Seq<String>, Seq<String>> tuple22;
                block6: {
                    ZStore zStore;
                    block4: {
                        Tuple2 tuple23;
                        Seq args;
                        Seq keys2;
                        block3: {
                            Tuple2 tuple24;
                            tuple2 = remaining.splitAt(numkeys);
                            if (tuple2 == null) break block2;
                            Seq keys3 = (Seq)tuple2._1();
                            Seq args2 = (Seq)tuple2._2();
                            Tuple2 tuple25 = tuple24 = new Tuple2((Object)keys3, (Object)args2);
                            keys2 = (Seq)tuple25._1();
                            args = (Seq)tuple25._2();
                            bl = args.isEmpty();
                            if (!bl) break block3;
                            zStore = $this.get(dest, numkeys, (Seq<String>)keys2, (Option<Weights>)None$.MODULE$, (Option<Aggregate>)None$.MODULE$);
                            break block4;
                        }
                        if (bl) break block5;
                        tuple22 = $this.findArgs((Seq<String>)args, numkeys);
                        if (tuple22 == null) break block6;
                        Seq args0 = (Seq)tuple22._1();
                        Seq args1 = (Seq)tuple22._2();
                        Tuple2 tuple26 = tuple23 = new Tuple2((Object)args0, (Object)args1);
                        Seq args02 = (Seq)tuple26._1();
                        Seq args12 = (Seq)tuple26._2();
                        RequireClientProtocol$.MODULE$.apply(args02.length() > 1, "Length of arguments must be > 1");
                        Option<Weights> weights = $this.findWeights((Seq<String>)args02, (Seq<String>)args12);
                        Option<Aggregate> aggregate = $this.findAggregate((Seq<String>)args02, (Seq<String>)args12);
                        weights.foreach((Function1)new Serializable($this, numkeys){
                            public static final long serialVersionUID = 0L;
                            private final int numkeys$1;

                            public final void apply(Weights w) {
                                RequireClientProtocol$.MODULE$.apply(w.size() == this.numkeys$1, "WEIGHTS length must equal keys length");
                            }
                            {
                                this.numkeys$1 = numkeys$1;
                            }
                        });
                        zStore = $this.get(dest, numkeys, (Seq<String>)keys2, weights, aggregate);
                    }
                    return zStore;
                }
                throw new MatchError(tuple22);
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        throw new MatchError((Object)tuple2);
    }

    public static Tuple2 findArgs(ZStoreCompanion $this, Seq args, int numkeys) {
        String string;
        block4: {
            Tuple2 tuple2;
            block3: {
                block2: {
                    RequireClientProtocol$.MODULE$.apply(args != null && !args.isEmpty(), "Args list must not be empty");
                    string = ((String)args.head()).toUpperCase();
                    String string2 = Weights$.MODULE$.WEIGHTS();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    tuple2 = args.splitAt(numkeys + 1);
                    break block3;
                }
                String string4 = Aggregate$.MODULE$.AGGREGATE();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                tuple2 = args.splitAt(2);
            }
            return tuple2;
        }
        throw new ClientError(new StringOps(Predef$.MODULE$.augmentString("AGGREGATE or WEIGHTS argument expected, found %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Option findWeights(ZStoreCompanion $this, Seq args0, Seq args1) {
        Option<Weights> option;
        boolean bl;
        Option<Weights> option2 = Weights$.MODULE$.apply((Seq<String>)args0);
        if (!None$.MODULE$.equals(option2)) return option2;
        boolean bl2 = bl = args1.length() > 0;
        if (bl) {
            Option<Weights> option3;
            Option<Weights> option4 = Weights$.MODULE$.apply((Seq<String>)args1);
            if (None$.MODULE$.equals(option4)) {
                throw new ClientError("Have additional arguments but unable to process");
            }
            option = option3 = option4;
            return option;
        } else {
            if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            option = None$.MODULE$;
        }
        return option;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Option findAggregate(ZStoreCompanion $this, Seq args0, Seq args1) {
        Option<Aggregate> option;
        boolean bl;
        Option<Aggregate> option2 = Aggregate$.MODULE$.apply((Seq<String>)args0);
        if (!None$.MODULE$.equals(option2)) return option2;
        boolean bl2 = bl = args1.length() > 0;
        if (bl) {
            Option<Aggregate> option3;
            Option<Aggregate> option4 = Aggregate$.MODULE$.apply((Seq<String>)args1);
            if (None$.MODULE$.equals(option4)) {
                throw new ClientError("Have additional arguments but unable to process");
            }
            option = option3 = option4;
            return option;
        } else {
            if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            option = None$.MODULE$;
        }
        return option;
    }

    public static void $init$(ZStoreCompanion $this) {
    }
}

