/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stats;

import com.twitter.finagle.stats.BucketAndCount;
import com.twitter.finagle.stats.BucketedHistogram$;
import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001drAB\u0001\u0003\u0011\u00031!\"A\tCk\u000e\\W\r^3e\u0011&\u001cHo\\4sC6T!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\u001c\t\u0003\u00171i\u0011A\u0001\u0004\u0007\u001b\tA\tA\u0002\b\u0003#\t+8m[3uK\u0012D\u0015n\u001d;pOJ\fWn\u0005\u0002\r\u001fA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001aDQA\u0006\u0007\u0005\u0002a\ta\u0001P5oSRt4\u0001\u0001\u000b\u0002\u0015!A!\u0004\u0004b\u0001\n\u0003\u00111$\u0001\tEK\u001a\fW\u000f\u001c;Rk\u0006tG/\u001b7fgV\tA\u0004E\u0002\u001eA\tj\u0011A\b\u0006\u0003?E\t!bY8mY\u0016\u001cG/[8o\u0013\t\tcD\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004\"\u0001E\u0012\n\u0005\u0011\n\"A\u0002#pk\ndW\r\u0003\u0004'\u0019\u0001\u0006I\u0001H\u0001\u0012\t\u00164\u0017-\u001e7u#V\fg\u000e^5mKN\u0004\u0003B\u0002\u0015\rA\u0013%\u0011&A\u0007nC.,G*[7jiN4uN\u001d\u000b\u0003UA\u00022\u0001E\u0016.\u0013\ta\u0013CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0011]%\u0011q&\u0005\u0002\u0004\u0013:$\b\"B\u0019(\u0001\u0004\u0011\u0013!B3se>\u0014\b\u0002C\u001a\r\u0005\u0004%\tA\u0001\u001b\u0002'\u0011+g-Y;mi\u0016\u0013(o\u001c:QKJ\u001cWM\u001c;\u0016\u0003\tBaA\u000e\u0007!\u0002\u0013\u0011\u0013\u0001\u0006#fM\u0006,H\u000e^#se>\u0014\b+\u001a:dK:$\b\u0005\u0003\u00049\u0019\u0001\u0006IAK\u0001\u000e\t\u00164\u0017-\u001e7u\u0019&l\u0017\u000e^:\t\u000bibA\u0011B\u001e\u0002\u0019\u0005\u001c8/\u001a:u\u0019&l\u0017\u000e^:\u0015\u0005qz\u0004C\u0001\t>\u0013\tq\u0014C\u0001\u0003V]&$\b\"\u0002!:\u0001\u0004Q\u0013A\u00027j[&$8\u000fC\u0003C\u0019\u0011\u00051)A\u0003baBd\u0017\u0010F\u0001E!\tYQIB\u0003\u000e\u0005\u0001\u0011ai\u0005\u0002F\u001f!A\u0001)\u0012B\u0001B\u0003%!\u0006C\u0003\u0017\u000b\u0012\u0005\u0011\n\u0006\u0002E\u0015\")\u0001\t\u0013a\u0001U!1A*\u0012Q\u0005\n5\u000bAbY8v]R\u001cH*\u001a8hi\",\u0012!\f\u0005\u0007\u001f\u0016\u0003\u000b\u0011\u0002\u0016\u0002\r\r|WO\u001c;t\u0011\u0019\tV\t)Q\u0005%\u0006\u0019a.^7\u0011\u0005A\u0019\u0016B\u0001+\u0012\u0005\u0011auN\\4\t\rY+\u0005\u0015)\u0003S\u0003\u0015!x\u000e^1m\u0011\u0015AV\t\"\u0001Z\u0003\r\tG\r\u001a\u000b\u0003yiCQaW,A\u0002I\u000bQA^1mk\u0016DQ!X#\u0005\u0002y\u000bQa\u00197fCJ$\u0012\u0001\u0010\u0005\u0006A\u0016#\t!Y\u0001\u000ba\u0016\u00148-\u001a8uS2,GC\u0001*c\u0011\u0015\u0019w\f1\u0001#\u0003\u0005\u0001\b\"B3F\t\u00031\u0017aB7bq&lW/\\\u000b\u0002%\")\u0001.\u0012C\u0001M\u00069Q.\u001b8j[Vl\u0007B\u00026FA\u0013%1.A\u0007mS6LG/T5ea>Lg\u000e\u001e\u000b\u0003%2DQ!\\5A\u00025\n\u0011!\u001b\u0005\u0006_\u0016#\t\u0001]\u0001\fO\u0016$\u0018+^1oi&dW\r\u0006\u0002Sc\")!O\u001ca\u0001E\u0005A\u0011/^1oi&dW\rC\u0003u\u000b\u0012\u0005Q/\u0001\u0007hKR\fV/\u00198uS2,7\u000f\u0006\u0002woB\u0019\u0001c\u000b*\t\u000ba\u001c\b\u0019A=\u0002\u0013E,\u0018M\u001c;jY\u0016\u001c\b\u0003\u0002>\u0002\u0006\tr1a_A\u0001\u001d\tax0D\u0001~\u0015\tqx#\u0001\u0004=e>|GOP\u0005\u0002%%\u0019\u00111A\t\u0002\u000fA\f7m[1hK&\u0019\u0011%a\u0002\u000b\u0007\u0005\r\u0011\u0003\u0003\u0004\u0002\f\u0015#\tAZ\u0001\u0004gVl\u0007BBA\b\u000b\u0012\u0005a-A\u0003d_VtG\u000f\u0003\u0004\u0002\u0014\u0015#\t\u0001N\u0001\bCZ,'/Y4f\u0011\u001d\t9\"\u0012C\u0001\u00033\tqBY;dW\u0016$\u0018I\u001c3D_VtGo]\u000b\u0003\u00037\u0001RA_A\u000f\u0003CIA!a\b\u0002\b\t\u00191+Z9\u0011\u0007-\t\u0019#C\u0002\u0002&\t\u0011aBQ;dW\u0016$\u0018I\u001c3D_VtG\u000f")
public class BucketedHistogram {
    public final int[] com$twitter$finagle$stats$BucketedHistogram$$limits;
    private final int[] counts;
    private long num;
    private long total;

    public static BucketedHistogram apply() {
        return BucketedHistogram$.MODULE$.apply();
    }

    private int countsLength() {
        return this.com$twitter$finagle$stats$BucketedHistogram$$limits.length + 1;
    }

    public void add(long value) {
        int n;
        if (value >= Integer.MAX_VALUE) {
            this.total += Integer.MAX_VALUE;
            n = this.countsLength() - 1;
        } else {
            this.total += value;
            int asInt = (int)value;
            n = Math.abs(Arrays.binarySearch(this.com$twitter$finagle$stats$BucketedHistogram$$limits, asInt) + 1);
        }
        int index = n;
        this.counts[index] = this.counts[index] + 1;
        ++this.num;
    }

    public void clear() {
        for (int i = 0; i < this.countsLength(); ++i) {
            this.counts[i] = 0;
        }
        this.num = 0L;
        this.total = 0L;
    }

    public long percentile(double p) {
        long l;
        int i;
        if (p < 0.0 || p > 1.0) {
            throw new AssertionError((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile must be within 0.0 to 1.0 inclusive: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)p)})));
        }
        long target = Math.round(p * (double)this.num);
        long total = 0L;
        for (i = 0; i < this.countsLength() && total < target; total += (long)this.counts[i], ++i) {
        }
        int n = i;
        switch (n) {
            case 0: {
                l = 0L;
                break;
            }
            default: {
                if (i == this.countsLength()) {
                    l = this.maximum();
                    break;
                }
                l = this.limitMidpoint(i - 1);
                break;
            }
        }
        return l;
    }

    public long maximum() {
        long l;
        if (this.num == 0L) {
            l = 0L;
        } else if (this.counts[this.countsLength() - 1] > 0) {
            l = Integer.MAX_VALUE;
        } else {
            int i;
            for (i = this.countsLength() - 2; i >= 0 && this.counts[i] == 0; --i) {
            }
            l = i == 0 ? 0L : this.limitMidpoint(i);
        }
        return l;
    }

    public long minimum() {
        long l;
        if (this.num == 0L) {
            l = 0L;
        } else {
            int i;
            for (i = 0; i < this.countsLength() && this.counts[i] == 0; ++i) {
            }
            l = this.limitMidpoint(i);
        }
        return l;
    }

    private long limitMidpoint(int i) {
        long l;
        int n = i;
        switch (n) {
            case 0: {
                l = 0L;
                break;
            }
            default: {
                if (i >= this.com$twitter$finagle$stats$BucketedHistogram$$limits.length) {
                    l = Integer.MAX_VALUE;
                    break;
                }
                l = ((long)this.com$twitter$finagle$stats$BucketedHistogram$$limits[i - 1] + (long)this.com$twitter$finagle$stats$BucketedHistogram$$limits[i]) / 2L;
                break;
            }
        }
        return l;
    }

    public long getQuantile(double quantile) {
        return this.percentile(quantile);
    }

    /*
     * WARNING - void declaration
     */
    public long[] getQuantiles(IndexedSeq<Object> quantiles) {
        void var2_2;
        long[] ps = new long[quantiles.length()];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = this.percentile(BoxesRunTime.unboxToDouble((Object)quantiles.apply(i)));
        }
        return var2_2;
    }

    public long sum() {
        return this.total;
    }

    public long count() {
        return this.num;
    }

    public double average() {
        return this.num == 0L ? 0.0 : (double)this.total / (double)this.num;
    }

    public Seq<BucketAndCount> bucketAndCounts() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.counts)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BucketedHistogram $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int count = A1._1$mcI$sp();
                    int idx = A1._2$mcI$sp();
                    if (count != 0) {
                        int upperLimit = idx != this.$outer.com$twitter$finagle$stats$BucketedHistogram$$limits.length ? this.$outer.com$twitter$finagle$stats$BucketedHistogram$$limits[idx] : Integer.MAX_VALUE;
                        int lowerLimit = idx != 0 ? this.$outer.com$twitter$finagle$stats$BucketedHistogram$$limits[idx - 1] : 0;
                        object = new BucketAndCount((long)lowerLimit, (long)upperLimit, count);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                int count;
                Tuple2<Object, Object> tuple2 = x1;
                boolean bl = tuple2 != null && (count = tuple2._1$mcI$sp()) != 0;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BucketAndCount.class))))).toSeq();
    }

    public BucketedHistogram(int[] limits) {
        this.com$twitter$finagle$stats$BucketedHistogram$$limits = limits;
        BucketedHistogram$.MODULE$.com$twitter$finagle$stats$BucketedHistogram$$assertLimits(limits);
        this.counts = new int[this.countsLength()];
        this.num = 0L;
        this.total = 0L;
    }
}

