/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.stress;

import com.twitter.app.App;
import com.twitter.app.Flag;
import com.twitter.app.Flaggable$;
import com.twitter.app.Flags;
import com.twitter.conversions.time$;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.builder.ClientBuilder$;
import com.twitter.finagle.stress.EmbeddedServer;
import com.twitter.finagle.stress.LoadBalancerTest;
import com.twitter.util.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class LoadBalancerTest$
implements App {
    public static final LoadBalancerTest$ MODULE$;
    private final Flag<Object> nreqsFlag;
    private final Flag<Duration> latencyFlag;
    private final AtomicInteger totalRequests;
    private final ClientBuilder<Nothing$, Nothing$, Nothing$, Nothing$, Nothing$> clientBuilder;
    private final String name;
    private final Flags flag;
    private String[] com$twitter$app$App$$_args;
    private final Buffer<Function0<BoxedUnit>> com$twitter$app$App$$premains;
    private final Buffer<Function0<BoxedUnit>> com$twitter$app$App$$postmains;
    private final Buffer<Function0<BoxedUnit>> com$twitter$app$App$$inits;

    static {
        new LoadBalancerTest$();
    }

    public String name() {
        return this.name;
    }

    public Flags flag() {
        return this.flag;
    }

    public String[] com$twitter$app$App$$_args() {
        return this.com$twitter$app$App$$_args;
    }

    public void com$twitter$app$App$$_args_$eq(String[] x$1) {
        this.com$twitter$app$App$$_args = x$1;
    }

    public Buffer<Function0<BoxedUnit>> com$twitter$app$App$$premains() {
        return this.com$twitter$app$App$$premains;
    }

    public Buffer<Function0<BoxedUnit>> com$twitter$app$App$$postmains() {
        return this.com$twitter$app$App$$postmains;
    }

    public Buffer<Function0<BoxedUnit>> com$twitter$app$App$$inits() {
        return this.com$twitter$app$App$$inits;
    }

    public void com$twitter$app$App$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void com$twitter$app$App$_setter_$flag_$eq(Flags x$1) {
        this.flag = x$1;
    }

    public void com$twitter$app$App$_setter_$com$twitter$app$App$$premains_$eq(Buffer x$1) {
        this.com$twitter$app$App$$premains = x$1;
    }

    public void com$twitter$app$App$_setter_$com$twitter$app$App$$postmains_$eq(Buffer x$1) {
        this.com$twitter$app$App$$postmains = x$1;
    }

    public void com$twitter$app$App$_setter_$com$twitter$app$App$$inits_$eq(Buffer x$1) {
        this.com$twitter$app$App$$inits = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void premain(Function0<BoxedUnit> f) {
        App.class.premain((App)this, f);
    }

    public void postmain(Function0<BoxedUnit> f) {
        App.class.postmain((App)this, f);
    }

    public void init(Function0<BoxedUnit> f) {
        App.class.init((App)this, f);
    }

    public void onExit(Function0<BoxedUnit> f) {
        App.class.onExit((App)this, f);
    }

    public final void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public Flag<Object> nreqsFlag() {
        return this.nreqsFlag;
    }

    public Flag<Duration> latencyFlag() {
        return this.latencyFlag;
    }

    public AtomicInteger totalRequests() {
        return this.totalRequests;
    }

    public ClientBuilder<Nothing$, Nothing$, Nothing$, Nothing$, Nothing$> clientBuilder() {
        return this.clientBuilder;
    }

    public void main() {
        this.runSuite();
    }

    public void doTest(Duration latency, int nreqs, PartialFunction<Tuple2<Object, Seq<EmbeddedServer>>, BoxedUnit> behavior) {
        new LoadBalancerTest(this.clientBuilder(), latency, nreqs, this.$lessinit$greater$default$4(), behavior).run();
    }

    public void runSuite() {
        Duration latency = (Duration)this.latencyFlag().apply();
        int n = BoxesRunTime.unboxToInt((Object)this.nreqsFlag().apply());
        int N = 10 * n;
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"testing ").append(this.clientBuilder()).toString());
        Predef$.MODULE$.println((Object)"\n== baseline (warmup) ==\n");
        this.doTest(latency, N, (PartialFunction<Tuple2<Object, Seq<EmbeddedServer>>, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Seq<EmbeddedServer>>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                A1 A1 = x$1;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<EmbeddedServer>> x$1) {
                Tuple2<Object, Seq<EmbeddedServer>> tuple2 = x$1;
                boolean bl = true;
                return bl;
            }
        });
        Predef$.MODULE$.println((Object)"\n== baseline ==\n");
        this.doTest(latency, N, (PartialFunction<Tuple2<Object, Seq<EmbeddedServer>>, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Seq<EmbeddedServer>>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                A1 A1 = x$1;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<EmbeddedServer>> x$1) {
                Tuple2<Object, Seq<EmbeddedServer>> tuple2 = x$1;
                boolean bl = true;
                return bl;
            }
        });
        Predef$.MODULE$.println((Object)"\n== 1 server goes offline ==\n");
        this.doTest(latency, N, (PartialFunction<Tuple2<Object, Seq<EmbeddedServer>>, BoxedUnit>)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<EmbeddedServer>>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x$1;
                if (A1 != null) {
                    int p2 = A1._1$mcI$sp();
                    Seq servers = (Seq)A1._2();
                    if (this.n$1 == p2) {
                        int x3 = p2;
                        ((EmbeddedServer)servers.apply(1)).stop();
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                }
                object = function1.apply(x$1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Object, Seq<EmbeddedServer>> x$1) {
                Tuple2<Object, Seq<EmbeddedServer>> tuple2 = x$1;
                if (tuple2 == null) return false;
                int p2 = tuple2._1$mcI$sp();
                Seq servers = (Seq)tuple2._2();
                if (this.n$1 != p2) return false;
                int x3 = p2;
                return true;
            }
            {
                this.n$1 = n$1;
            }
        });
        Predef$.MODULE$.println((Object)"\n== 1 application becomes nonresponsive ==\n");
        this.doTest(latency, N, (PartialFunction<Tuple2<Object, Seq<EmbeddedServer>>, BoxedUnit>)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<EmbeddedServer>>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x$1;
                if (A1 != null) {
                    int p2 = A1._1$mcI$sp();
                    Seq servers = (Seq)A1._2();
                    if (this.n$1 == p2) {
                        int x3 = p2;
                        ((EmbeddedServer)servers.apply(1)).becomeApplicationNonresponsive();
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                }
                object = function1.apply(x$1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Object, Seq<EmbeddedServer>> x$1) {
                Tuple2<Object, Seq<EmbeddedServer>> tuple2 = x$1;
                if (tuple2 == null) return false;
                int p2 = tuple2._1$mcI$sp();
                Seq servers = (Seq)tuple2._2();
                if (this.n$1 != p2) return false;
                int x3 = p2;
                return true;
            }
            {
                this.n$1 = n$1;
            }
        });
        Predef$.MODULE$.println((Object)"\n== 1 connection becomes nonresponsive ==\n");
        this.doTest(latency, N, (PartialFunction<Tuple2<Object, Seq<EmbeddedServer>>, BoxedUnit>)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<EmbeddedServer>>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x$1;
                if (A1 != null) {
                    int p2 = A1._1$mcI$sp();
                    Seq servers = (Seq)A1._2();
                    if (this.n$1 == p2) {
                        int x3 = p2;
                        ((EmbeddedServer)servers.apply(1)).becomeConnectionNonresponsive();
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                }
                object = function1.apply(x$1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Object, Seq<EmbeddedServer>> x$1) {
                Tuple2<Object, Seq<EmbeddedServer>> tuple2 = x$1;
                if (tuple2 == null) return false;
                int p2 = tuple2._1$mcI$sp();
                Seq servers = (Seq)tuple2._2();
                if (this.n$1 != p2) return false;
                int x3 = p2;
                return true;
            }
            {
                this.n$1 = n$1;
            }
        });
        Predef$.MODULE$.println((Object)"\n== 1 server has a protocol error ==\n");
        this.doTest(latency, N, (PartialFunction<Tuple2<Object, Seq<EmbeddedServer>>, BoxedUnit>)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<EmbeddedServer>>, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x$1;
                if (A1 != null) {
                    int p2 = A1._1$mcI$sp();
                    Seq servers = (Seq)A1._2();
                    if (this.n$1 == p2) {
                        int x3 = p2;
                        ((EmbeddedServer)servers.apply(1)).becomeBelligerent();
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                }
                object = function1.apply(x$1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Object, Seq<EmbeddedServer>> x$1) {
                Tuple2<Object, Seq<EmbeddedServer>> tuple2 = x$1;
                if (tuple2 == null) return false;
                int p2 = tuple2._1$mcI$sp();
                Seq servers = (Seq)tuple2._2();
                if (this.n$1 != p2) return false;
                int x3 = p2;
                return true;
            }
            {
                this.n$1 = n$1;
            }
        });
    }

    public Duration $lessinit$greater$default$2() {
        return time$.MODULE$.intToTimeableNumber(0).seconds();
    }

    public int $lessinit$greater$default$3() {
        return 100000;
    }

    public int $lessinit$greater$default$4() {
        return 20;
    }

    private LoadBalancerTest$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        this.nreqsFlag = this.flag().apply("n", (Object)BoxesRunTime.boxToInteger((int)100000), "Number of reqs sent from each client", Flaggable$.MODULE$.ofInt());
        this.latencyFlag = this.flag().apply("l", (Object)time$.MODULE$.intToTimeableNumber(0).seconds(), "req latency forced at the server", Flaggable$.MODULE$.ofDuration());
        this.totalRequests = new AtomicInteger(0);
        this.clientBuilder = ClientBuilder$.MODULE$.apply().requestTimeout(time$.MODULE$.intToTimeableNumber(100).milliseconds()).retries(10);
    }
}

