/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.kafkastreams.dsl;

import com.twitter.finagle.stats.NullStatsReceiver$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finatra.kafkastreams.transformer.FinatraTransformer;
import com.twitter.finatra.kafkastreams.transformer.FinatraTransformer$;
import com.twitter.finatra.kafkastreams.transformer.domain.Time$;
import com.twitter.util.Duration;
import org.joda.time.DateTime;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00193Q!\u0001\u0002\u0001\u00051\u0011Qc\u00157fKB$U\r\\1z)J\fgn\u001d4pe6,'O\u0003\u0002\u0004\t\u0005\u0019Am\u001d7\u000b\u0005\u00151\u0011\u0001D6bM.\f7\u000f\u001e:fC6\u001c(BA\u0004\t\u0003\u001d1\u0017N\\1ue\u0006T!!\u0003\u0006\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1\"A\u0002d_6,2!\u0004\f%'\t\u0001a\u0002\u0005\u0004\u0010%Q\u0019CcI\u0007\u0002!)\u0011\u0011\u0003B\u0001\fiJ\fgn\u001d4pe6,'/\u0003\u0002\u0014!\t\u0011b)\u001b8biJ\fGK]1og\u001a|'/\\3s!\t)b\u0003\u0004\u0001\u0005\u000b]\u0001!\u0019A\r\u0003\u0003-\u001b\u0001!\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"!\u0006\u0013\u0005\u000b\u0015\u0002!\u0019A\r\u0003\u0003YC\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006I\u0016d\u0017-\u001f\t\u0003S1j\u0011A\u000b\u0006\u0003W!\tA!\u001e;jY&\u0011QF\u000b\u0002\t\tV\u0014\u0018\r^5p]\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"\"!M\u001a\u0011\tI\u0002AcI\u0007\u0002\u0005!)qE\fa\u0001Q!)Q\u0007\u0001C!m\u0005IqN\\'fgN\fw-\u001a\u000b\u0005oi\u0012E\t\u0005\u0002\u001cq%\u0011\u0011\b\b\u0002\u0005+:LG\u000fC\u0003<i\u0001\u0007A(A\u0006nKN\u001c\u0018mZ3US6,\u0007CA\u001fA\u001b\u0005q$BA \u0011\u0003\u0019!w.\\1j]&\u0011\u0011I\u0010\u0002\u0005)&lW\rC\u0003Di\u0001\u0007A#A\u0002lKfDQ!\u0012\u001bA\u0002\r\nQA^1mk\u0016\u0004")
public class SleepDelayTransformer<K, V>
extends FinatraTransformer<K, V, K, V> {
    private final Duration delay;

    @Override
    public void onMessage(long messageTime, K key, V value) {
        long wallClock = Time$.MODULE$.create(DateTime.now());
        long gap = wallClock - messageTime;
        if (gap < this.delay.inMillis()) {
            Thread.sleep(this.delay.inMillis() - gap);
        }
        this.forward(key, value);
    }

    public SleepDelayTransformer(Duration delay) {
        this.delay = delay;
        super((StatsReceiver)NullStatsReceiver$.MODULE$, FinatraTransformer$.MODULE$.$lessinit$greater$default$2());
    }
}

