/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.twitter4j;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.hbc.SitestreamController;
import com.twitter.hbc.core.Client;
import com.twitter.hbc.core.StatsReporter;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import com.twitter.hbc.twitter4j.Twitter4jClient;
import com.twitter.hbc.twitter4j.message.DisconnectMessage;
import com.twitter.hbc.twitter4j.parser.JSONObjectParser;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.conf.ConfigurationBuilder;
import twitter4j.internal.json.z_T4JInternalJSONImplFactory;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.json.JSONObjectType;

class BaseTwitter4jClient
implements Twitter4jClient {
    private static final Logger logger = LoggerFactory.getLogger(BaseTwitter4jClient.class);
    protected final Client client;
    private final BlockingQueue<String> messageQueue;
    private final ExecutorService executorService;
    private final z_T4JInternalJSONImplFactory factory;

    protected BaseTwitter4jClient(Client client, BlockingQueue<String> blockingQueue, ExecutorService executorService) {
        this.client = (Client)Preconditions.checkNotNull((Object)client);
        this.messageQueue = (BlockingQueue)Preconditions.checkNotNull(blockingQueue);
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.factory = new z_T4JInternalJSONImplFactory(new ConfigurationBuilder().build());
    }

    public void connect() {
        this.client.connect();
    }

    public void reconnect() {
        this.client.reconnect();
    }

    @Override
    public void process() {
        if (this.client.isDone() || this.executorService.isTerminated()) {
            throw new IllegalStateException("Client is already stopped");
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (!BaseTwitter4jClient.this.client.isDone()) {
                            String msg = (String)BaseTwitter4jClient.this.messageQueue.take();
                            try {
                                BaseTwitter4jClient.this.parseMessage(msg);
                                continue block4;
                            }
                            catch (Exception e) {
                                BaseTwitter4jClient.this.onException(e);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        BaseTwitter4jClient.this.onException(e);
                        break;
                    }
                }
            }
        };
        this.executorService.execute(runner);
    }

    public void stop() {
        this.client.stop();
        this.executorService.shutdown();
    }

    public void stop(int millis) {
        this.client.stop(millis);
        this.executorService.shutdown();
    }

    public boolean isDone() {
        return this.client.isDone();
    }

    public String getName() {
        return this.client.getName();
    }

    public StreamingEndpoint getEndpoint() {
        return this.client.getEndpoint();
    }

    public SitestreamController createSitestreamController() {
        return this.client.createSitestreamController();
    }

    public StatsReporter.StatsTracker getStatsTracker() {
        return this.client.getStatsTracker();
    }

    protected void parseMessage(String msg) throws JSONException, TwitterException, IOException {
        JSONObject json = new JSONObject(msg);
        long sitestreamUser = this.getSitestreamUser(json);
        this.processMessage(sitestreamUser, this.preprocessMessage(json));
    }

    protected long getSitestreamUser(JSONObject json) throws JSONException {
        return -1L;
    }

    protected JSONObject preprocessMessage(JSONObject json) throws JSONException {
        return json;
    }

    @VisibleForTesting
    void processMessage(long sitestreamUser, JSONObject json) throws JSONException, TwitterException, IOException {
        JSONObjectType type = JSONObjectType.determine((JSONObject)json);
        if (type == JSONObjectType.STATUS) {
            this.processStatus(sitestreamUser, json);
        } else if (type == JSONObjectType.LIMIT) {
            this.processLimit(sitestreamUser, json);
        } else if (type == JSONObjectType.DELETE) {
            this.processDelete(sitestreamUser, json);
        } else if (type == JSONObjectType.SCRUB_GEO) {
            this.processScrubGeo(sitestreamUser, json);
        } else if (type == JSONObjectType.DIRECT_MESSAGE) {
            this.processDirectMessage(sitestreamUser, json);
        } else if (type == JSONObjectType.FRIENDS) {
            this.processFriends(sitestreamUser, json);
        } else if (type == JSONObjectType.FAVORITE) {
            this.processFavorite(sitestreamUser, json);
        } else if (type == JSONObjectType.UNFAVORITE) {
            this.processUnfavorite(sitestreamUser, json);
        } else if (type == JSONObjectType.RETWEET) {
            this.processRetweet(sitestreamUser, json);
        } else if (type == JSONObjectType.FOLLOW) {
            this.processFollow(sitestreamUser, json);
        } else if (type == JSONObjectType.UNFOLLOW) {
            this.processUnfollow(sitestreamUser, json);
        } else if (type == JSONObjectType.USER_LIST_MEMBER_ADDED) {
            this.processUserListMemberAddition(sitestreamUser, json);
        } else if (type == JSONObjectType.USER_LIST_MEMBER_DELETED) {
            this.processUserListMemberDeletion(sitestreamUser, json);
        } else if (type == JSONObjectType.USER_LIST_SUBSCRIBED) {
            this.processUserListSubscription(sitestreamUser, json);
        } else if (type == JSONObjectType.USER_LIST_UNSUBSCRIBED) {
            this.processUserListUnsubscription(sitestreamUser, json);
        } else if (type == JSONObjectType.USER_LIST_CREATED) {
            this.processUserListCreation(sitestreamUser, json);
        } else if (type == JSONObjectType.USER_LIST_UPDATED) {
            this.processUserListUpdated(sitestreamUser, json);
        } else if (type == JSONObjectType.USER_LIST_DESTROYED) {
            this.processUserListDestroyed(sitestreamUser, json);
        } else if (type == JSONObjectType.BLOCK) {
            this.processBlock(sitestreamUser, json);
        } else if (type == JSONObjectType.UNBLOCK) {
            this.processUnblock(sitestreamUser, json);
        } else if (type == JSONObjectType.USER_UPDATE) {
            this.processUserUpdate(sitestreamUser, json);
        } else if (JSONObjectParser.isControlStreamMessage(json)) {
            this.processControlStream(json);
        } else if (JSONObjectParser.isDisconnectMessage(json)) {
            this.processDisconnectMessage(json);
        } else {
            this.onUnknownMessageType(json.toString());
        }
    }

    private void processStatus(long sitestreamUser, JSONObject json) throws TwitterException {
        Status status = this.factory.createStatus(json);
        this.onStatus(sitestreamUser, status);
    }

    private void processDirectMessage(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        this.onDirectMessage(sitestreamUser, this.factory.createDirectMessage(json.getJSONObject("direct_message")));
    }

    private void processDelete(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        JSONObject deletionNotice = json.getJSONObject("delete");
        if (deletionNotice.has("status")) {
            this.onDelete(sitestreamUser, JSONObjectParser.parseStatusDelete(json));
        } else if (deletionNotice.has("direct_message")) {
            JSONObject dm = deletionNotice.getJSONObject("direct_message");
            long statusId = dm.getLong("id");
            long userId = dm.getLong("user_id");
            this.onDeleteDirectMessage(sitestreamUser, statusId, userId);
        }
    }

    private void processLimit(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        this.onTrackLimitationNotice(sitestreamUser, JSONObjectParser.parseTrackLimit(json));
    }

    private void processScrubGeo(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        JSONObject scrubGeo = json.getJSONObject("scrub_geo");
        long userId = scrubGeo.getLong("user_id");
        long upToStatusId = scrubGeo.getLong("up_to_status_id");
        this.onScrubGeo(sitestreamUser, userId, upToStatusId);
    }

    private void processFriends(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        this.onFriends(sitestreamUser, JSONObjectParser.parseFriendList(json));
    }

    private void processFavorite(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User target = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        Status status = this.factory.createStatus(JSONObjectParser.parseEventTargetObject(json));
        this.onFavorite(sitestreamUser, source, target, status);
    }

    private void processUnfavorite(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User target = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        Status status = this.factory.createStatus(JSONObjectParser.parseEventTargetObject(json));
        this.onUnfavorite(sitestreamUser, source, target, status);
    }

    private void processRetweet(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User target = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        Status status = this.factory.createStatus(JSONObjectParser.parseEventTargetObject(json));
        this.onRetweet(sitestreamUser, source, target, status);
    }

    private void processFollow(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User target = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        this.onFollow(sitestreamUser, source, target);
    }

    private void processUnfollow(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User target = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        this.onUnfollow(sitestreamUser, source, target);
    }

    private void processUserListMemberAddition(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User addedUser = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User owner = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        UserList userList = this.factory.createAUserList(JSONObjectParser.parseEventTargetObject(json));
        this.onUserListMemberAddition(sitestreamUser, addedUser, owner, userList);
    }

    private void processUserListMemberDeletion(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User deletedMember = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User owner = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        UserList userList = this.factory.createAUserList(JSONObjectParser.parseEventTargetObject(json));
        this.onUserListMemberDeletion(sitestreamUser, deletedMember, owner, userList);
    }

    private void processUserListSubscription(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User owner = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        UserList userList = this.factory.createAUserList(JSONObjectParser.parseEventTargetObject(json));
        this.onUserListSubscription(sitestreamUser, source, owner, userList);
    }

    private void processUserListUnsubscription(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User owner = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        UserList userList = this.factory.createAUserList(JSONObjectParser.parseEventTargetObject(json));
        this.onUserListUnsubscription(sitestreamUser, source, owner, userList);
    }

    private void processUserListCreation(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        UserList userList = this.factory.createAUserList(JSONObjectParser.parseEventTarget(json));
        this.onUserListCreation(sitestreamUser, source, userList);
    }

    private void processUserListUpdated(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        UserList userList = this.factory.createAUserList(JSONObjectParser.parseEventTarget(json));
        this.onUserListUpdate(sitestreamUser, source, userList);
    }

    private void processUserListDestroyed(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        UserList userList = this.factory.createAUserList(JSONObjectParser.parseEventTarget(json));
        this.onUserListDeletion(sitestreamUser, source, userList);
    }

    private void processUserUpdate(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        this.onUserProfileUpdate(sitestreamUser, this.factory.createUser(JSONObjectParser.parseEventSource(json)));
    }

    private void processBlock(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User target = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        this.onBlock(sitestreamUser, source, target);
    }

    private void processUnblock(long sitestreamUser, JSONObject json) throws TwitterException, JSONException {
        User source = this.factory.createUser(JSONObjectParser.parseEventSource(json));
        User target = this.factory.createUser(JSONObjectParser.parseEventTarget(json));
        this.onUnblock(sitestreamUser, source, target);
    }

    private void processControlStream(JSONObject json) throws JSONException {
        this.onControlStreamMessage(JSONObjectParser.getStreamId(json));
    }

    private void processDisconnectMessage(JSONObject json) throws JSONException {
        this.onDisconnectMessage(JSONObjectParser.parseDisconnectMessage(json));
    }

    protected void onStatus(long sitestreamUser, Status status) {
        logger.info("Unhandled event: onStatus");
    }

    protected void onDelete(long sitestreamUser, StatusDeletionNotice delete) {
        logger.info("Unhandled event: onDelete");
    }

    protected void onTrackLimitationNotice(long sitestreamUser, int limit) {
        logger.info("Unhandled event: onTrackLimitationNotice");
    }

    protected void onScrubGeo(long sitestreamUser, long userId, long upToStatusId) {
        logger.info("Unhandled event: onScrubGeo");
    }

    protected void onDeleteDirectMessage(long sitestreamUser, long directMessageId, long userId) {
        logger.info("Unhandled event: onDeleteDirectMessage");
    }

    protected void onDirectMessage(long sitestreamUser, DirectMessage directMessage) {
        logger.info("Unhandled event: onDirectMessage");
    }

    protected void onFriends(long sitestreamUser, long[] json) {
        logger.info("Unhandled event: onFriends");
    }

    protected void onFavorite(long sitestreamUser, User source, User target, Status targetObject) {
        logger.info("Unhandled event: onFavorite");
    }

    protected void onUnfavorite(long sitestreamUser, User source, User target, Status targetObject) {
        logger.info("Unhandled event: onUnfavorite");
    }

    protected void onRetweet(long sitestreamUser, User source, User target, Status tweet) {
        logger.info("Unhandled event: onRetweet");
    }

    protected void onFollow(long sitestreamUser, User source, User target) throws TwitterException {
        logger.info("Unhandled event: onFollow");
    }

    protected void onUnfollow(long sitestreamUser, User source, User target) throws TwitterException {
        logger.info("Unhandled event: onUnfollow");
    }

    protected void onUserListMemberAddition(long sitestreamUser, User addedMember, User owner, UserList userList) {
        logger.info("Unhandled event: onUserListMemberAddition");
    }

    protected void onUserListMemberDeletion(long sitestreamUser, User deletedMember, User owner, UserList userList) {
        logger.info("Unhandled event: onUserListMemberDeletion");
    }

    protected void onUserListSubscription(long sitestreamUser, User subscriber, User owner, UserList userList) {
        logger.info("Unhandled event: onUserListSubscription");
    }

    protected void onUserListUnsubscription(long sitestreamUser, User deletedMember, User owner, UserList userList) {
        logger.info("Unhandled event: onUserListUnsubscription");
    }

    protected void onUserListCreation(long sitestreamUser, User source, UserList userList) {
        logger.info("Unhandled event: onUserListCreation");
    }

    protected void onUserListUpdate(long sitestreamUser, User source, UserList userList) {
        logger.info("Unhandled event: onUserListUpdate");
    }

    protected void onUserListDeletion(long sitestreamUser, User source, UserList userList) {
        logger.info("Unhandled event: onUserListDeletion");
    }

    protected void onUserProfileUpdate(long sitestreamUser, User source) {
        logger.info("Unhandled event: onUserProfileUpdate");
    }

    protected void onBlock(long sitestreamUser, User source, User target) {
        logger.info("Unhandled event: onBlock");
    }

    protected void onUnblock(long sitestreamUser, User source, User target) {
        logger.info("Unhandled event: onUnblock");
    }

    protected void onControlStreamMessage(String streamId) {
        logger.info("Unhandled event: onControlStreamMessage");
    }

    protected void onDisconnectMessage(DisconnectMessage disconnectMessage) {
        logger.info("Unhandled event: onDisconnectMessage - {}", (Object)disconnectMessage.toString());
    }

    protected void onException(Exception e) {
        logger.info("Exception caught", (Throwable)e);
    }

    protected void onUnknownMessageType(String msg) {
        logger.info("Unknown message (first 50 chars): " + msg.substring(0, Math.min(msg.length(), 50)));
    }
}

