/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.twitter4j.parser;

import com.google.common.primitives.Longs;
import com.twitter.hbc.twitter4j.message.DisconnectMessage;
import twitter4j.StatusDeletionNotice;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public class JSONObjectParser {
    public static StatusDeletionNotice parseStatusDelete(JSONObject json) throws JSONException {
        JSONObject statusDelete = json.getJSONObject("delete").getJSONObject("status");
        final long statusId = statusDelete.getLong("id");
        final long userId = statusDelete.getLong("user_id");
        return new StatusDeletionNotice(){

            public long getStatusId() {
                return statusId;
            }

            public long getUserId() {
                return userId;
            }

            public int compareTo(Object o) {
                return Longs.compare((long)this.getStatusId(), (long)((StatusDeletionNotice)o).getStatusId());
            }
        };
    }

    public static int parseTrackLimit(JSONObject json) throws JSONException {
        return json.getJSONObject("limit").getInt("track");
    }

    public static JSONObject parseEventSource(JSONObject json) throws JSONException {
        return json.getJSONObject("source");
    }

    public static JSONObject parseEventTarget(JSONObject json) throws JSONException {
        return json.getJSONObject("target");
    }

    public static JSONObject parseEventTargetObject(JSONObject json) throws JSONException {
        return json.getJSONObject("target_object");
    }

    public static long[] parseFriendList(JSONObject json) throws JSONException {
        JSONArray friends = json.getJSONArray("friends");
        long[] friendIds = new long[friends.length()];
        for (int i = 0; i < friendIds.length; ++i) {
            friendIds[i] = friends.getLong(i);
        }
        return friendIds;
    }

    public static long getSitestreamUser(JSONObject envelope) throws JSONException {
        return envelope.getLong("for_user");
    }

    public static JSONObject getSitestreamMessage(JSONObject envelope) throws JSONException {
        return envelope.getJSONObject("message");
    }

    public static boolean isControlStreamMessage(JSONObject message) throws JSONException {
        return message.has("control");
    }

    public static String getStreamId(JSONObject message) throws JSONException {
        String uri = message.getJSONObject("control").getString("control_uri");
        String[] split = uri.split("/");
        if (split.length != 5) {
            throw new IllegalStateException("Unknown url format: " + uri);
        }
        return split[split.length - 1];
    }

    public static boolean isDisconnectMessage(JSONObject message) {
        return message.has("disconnect");
    }

    public static DisconnectMessage parseDisconnectMessage(JSONObject message) throws JSONException {
        JSONObject json = message.getJSONObject("disconnect");
        int code = json.getInt("code");
        String streamName = json.getString("stream_name");
        String reason = json.getString("reason");
        return new DisconnectMessage(code, streamName, reason);
    }
}

