/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.ostrich.stats;

import com.twitter.ostrich.stats.Distribution;
import com.twitter.ostrich.stats.Histogram$;
import java.util.Arrays;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u0003Y\u0011!\u0003%jgR|wM]1n\u0015\t\u0019A!A\u0003ti\u0006$8O\u0003\u0002\u0006\r\u00059qn\u001d;sS\u000eD'BA\u0004\t\u0003\u001d!x/\u001b;uKJT\u0011!C\u0001\u0004G>l7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\n\u0011&\u001cHo\\4sC6\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002\u0003\u0004\u001b\u001b\u0001&IaG\u0001\u000f[\u0006\\WMQ;dW\u0016$8OR8s)\ta\"\u0005E\u0002\u0012;}I!A\b\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0005E\u0001\u0013BA\u0011\u0013\u0005\u0011auN\\4\t\u000b\rJ\u0002\u0019\u0001\u0013\u0002\u000b\u0015\u0014(o\u001c:\u0011\u0005E)\u0013B\u0001\u0014\u0013\u0005\u0019!u.\u001e2mK\"9\u0001&\u0004b\u0001\n\u0003I\u0013a\u00022vG.,Go]\u000b\u00029!11&\u0004Q\u0001\nq\t\u0001BY;dW\u0016$8\u000f\t\u0005\u0006[5!\tAL\u0001\fEV\u001c7.\u001a;J]\u0012,\u0007\u0010\u0006\u00020eA\u0011\u0011\u0003M\u0005\u0003cI\u00111!\u00138u\u0011\u0015\u0019D\u00061\u00010\u0003\rYW-\u001f\u0005\u0007k5\u0001K\u0011\u0002\u001c\u0002\u0019\tLg.\u0019:z'\u0016\f'o\u00195\u0015\u000b=:$hO\u001f\t\u000ba\"\u0004\u0019A\u001d\u0002\u000b\u0005\u0014(/Y=\u0011\u0007Eir\u0006C\u00034i\u0001\u0007q\u0006C\u0003=i\u0001\u0007q&A\u0002m_^DQA\u0010\u001bA\u0002=\nA\u0001[5hQ\"\u0012A\u0007\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007J\t!\"\u00198o_R\fG/[8o\u0013\t)%IA\u0004uC&d'/Z2\t\u000b\u001dkA\u0011\u0001%\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007%\u000b)\b\u0005\u0002\r\u0015\u001a!aB\u0001\u0001L'\tQ\u0005\u0003C\u0003\u0018\u0015\u0012\u0005Q\nF\u0001J\u0011\u001dy%J1A\u0005\u0002A\u000b!B\\;n\u0005V\u001c7.\u001a;t+\u0005y\u0003B\u0002*KA\u0003%q&A\u0006ok6\u0014UoY6fiN\u0004\u0003b\u0002\u0015K\u0005\u0004%\t!\u000b\u0005\u0007W)\u0003\u000b\u0011\u0002\u000f\t\u000fYS\u0005\u0019!C\u0001/\u0006)1m\\;oiV\tq\u0004C\u0004Z\u0015\u0002\u0007I\u0011\u0001.\u0002\u0013\r|WO\u001c;`I\u0015\fHCA._!\t\tB,\u0003\u0002^%\t!QK\\5u\u0011\u001dy\u0006,!AA\u0002}\t1\u0001\u001f\u00132\u0011\u0019\t'\n)Q\u0005?\u000511m\\;oi\u0002Bqa\u0019&A\u0002\u0013\u0005q+A\u0002tk6Dq!\u001a&A\u0002\u0013\u0005a-A\u0004tk6|F%Z9\u0015\u0005m;\u0007bB0e\u0003\u0003\u0005\ra\b\u0005\u0007S*\u0003\u000b\u0015B\u0010\u0002\tM,X\u000e\t\u0005\u0006W*#\t\u0001\\\u0001\fC\u0012$Gk\u001c\"vG.,G\u000f\u0006\u0002\\[\")aN\u001ba\u0001_\u0005)\u0011N\u001c3fq\")\u0001O\u0013C\u0001c\u0006\u0019\u0011\r\u001a3\u0015\u0005}\u0011\b\"B:p\u0001\u0004y\u0013!\u00018\t\u000bUTE\u0011\u0001<\u0002\u000b\rdW-\u0019:\u0015\u0003mCQ\u0001\u001f&\u0005\u0002e\f1aZ3u)\rQ\u0018Q\u0002\t\u0005w\u0006\u001dqDD\u0002}\u0003\u0007q1!`A\u0001\u001b\u0005q(BA@\u000b\u0003\u0019a$o\\8u}%\t1#C\u0002\u0002\u0006I\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0005-!\u0001\u0002'jgRT1!!\u0002\u0013\u0011\u001d\tya\u001ea\u0001\u0003#\tQA]3tKR\u00042!EA\n\u0013\r\t)B\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\tIB\u0013C\u0001\u00037\tQbZ3u!\u0016\u00148-\u001a8uS2,GcA\u0018\u0002\u001e!9\u0011qDA\f\u0001\u0004!\u0013A\u00039fe\u000e,g\u000e^5mK\"1\u00111\u0005&\u0005\u0002A\u000bq!\\1yS6,X\u000e\u0003\u0004\u0002()#\t\u0001U\u0001\b[&t\u0017.\\;n\u0011\u001d\tYC\u0013C\t\u0003[\t\u0001\"\\5ea>Lg\u000e\u001e\u000b\u0004_\u0005=\u0002B\u00028\u0002*\u0001\u0007q\u0006C\u0004\u00024)#\t!!\u000e\u0002\u000b5,'oZ3\u0015\u0007m\u000b9\u0004C\u0004\u0002:\u0005E\u0002\u0019A%\u0002\u000b=$\b.\u001a:\t\u000f\u0005u\"\n\"\u0001\u0002@\u00051A%\\5okN$2!SA!\u0011\u001d\tI$a\u000fA\u0002%Caa\u0012&\u0005\u0002\u0005\u0015CCAA$!\ra\u0011\u0011J\u0005\u0004\u0003\u0017\u0012!\u0001\u0004#jgR\u0014\u0018NY;uS>t\u0007bBA(\u0015\u0012\u0005\u0013\u0011K\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005E\u00111\u000b\u0005\t\u0003s\ti\u00051\u0001\u0002VA\u0019\u0011#a\u0016\n\u0007\u0005e#CA\u0002B]fDq!!\u0018K\t\u0003\ny&\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0007\u0005\u0003\u0002d\u00055TBAA3\u0015\u0011\t9'!\u001b\u0002\t1\fgn\u001a\u0006\u0003\u0003W\nAA[1wC&!\u0011qNA3\u0005\u0019\u0019FO]5oO\"1\u00111\u000f&\u0005B5\u000bQa\u00197p]\u0016Dq!a\u001eG\u0001\u0004\tI(\u0001\u0004wC2,Xm\u001d\t\u0005#\u0005mt&C\u0002\u0002~I\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?\u0001")
public class Histogram {
    private final int numBuckets = Histogram$.MODULE$.buckets().length + 1;
    private final long[] buckets = new long[this.numBuckets()];
    private long count = 0L;
    private long sum = 0L;

    public static int bucketIndex(int n) {
        return Histogram$.MODULE$.bucketIndex(n);
    }

    public int numBuckets() {
        return this.numBuckets;
    }

    public long[] buckets() {
        return this.buckets;
    }

    public long count() {
        return this.count;
    }

    public void count_$eq(long x$1) {
        this.count = x$1;
    }

    public long sum() {
        return this.sum;
    }

    public void sum_$eq(long x$1) {
        this.sum = x$1;
    }

    public void addToBucket(int index) {
        this.buckets()[index] = this.buckets()[index] + 1L;
        this.count_$eq(this.count() + 1L);
    }

    public long add(int n) {
        int index = Histogram$.MODULE$.bucketIndex(n);
        Histogram histogram = this;
        synchronized (histogram) {
            this.addToBucket(index);
            this.sum_$eq(this.sum() + (long)n);
            return this.count();
        }
    }

    public synchronized void clear() {
        Arrays.fill(this.buckets(), 0L);
        this.count_$eq(0L);
        this.sum_$eq(0L);
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> get(boolean reset2) {
        void var2_2;
        List rv = Predef$.MODULE$.longArrayOps(this.buckets()).toList();
        if (reset2) {
            this.clear();
        }
        return var2_2;
    }

    public synchronized int getPercentile(double percentile) {
        int index;
        if (percentile == 0.0) {
            return this.minimum();
        }
        long total = 0L;
        for (index = 0; index < Predef$.MODULE$.longArrayOps(this.buckets()).size() && (double)total < percentile * (double)this.count(); ++index) {
            total += this.buckets()[index];
        }
        return index == 0 ? 0 : (index - 1 == Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() ? this.maximum() : this.midpoint(index - 1));
    }

    public int maximum() {
        int n;
        if (this.buckets()[Predef$.MODULE$.longArrayOps(this.buckets()).size() - 1] > 0L) {
            n = Integer.MAX_VALUE;
        } else if (this.count() == 0L) {
            n = 0;
        } else {
            int index;
            for (index = Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() - 1; index >= 0 && this.buckets()[index] == 0L; --index) {
            }
            n = index < 0 ? 0 : this.midpoint(index);
        }
        return n;
    }

    public int minimum() {
        int n;
        if (this.count() == 0L) {
            n = 0;
        } else {
            int index;
            for (index = 0; index < Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() && this.buckets()[index] == 0L; ++index) {
            }
            n = index >= Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() ? Integer.MAX_VALUE : this.midpoint(index);
        }
        return n;
    }

    public int midpoint(int index) {
        return index == 0 ? 0 : (index - 1 >= Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() ? Integer.MAX_VALUE : (int)((Histogram$.MODULE$.buckets()[index - 1] + Histogram$.MODULE$.buckets()[index] - 1L) / 2L));
    }

    public void merge(Histogram other) {
        if (other.count() > 0L) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numBuckets()).foreach$mVc$sp((Function1)new Serializable(this, other){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Histogram $outer;
                private final Histogram other$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.$outer.buckets()[i] = this.$outer.buckets()[i] + this.other$2.buckets()[i];
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.other$2 = other$2;
                }
            });
            this.count_$eq(this.count() + other.count());
            this.sum_$eq(this.sum() + other.sum());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Histogram $minus(Histogram other) {
        void var2_2;
        Histogram rv = new Histogram();
        rv.sum_$eq(package$.MODULE$.max(0L, this.sum() - other.sum()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numBuckets()).foreach$mVc$sp((Function1)new Serializable(this, other, rv){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Histogram $outer;
            private final Histogram other$1;
            private final Histogram rv$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.rv$1.buckets()[i] = package$.MODULE$.max(0L, this.$outer.buckets()[i] - this.other$1.buckets()[i]);
                this.rv$1.count_$eq(this.rv$1.count() + this.rv$1.buckets()[i]);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = other$1;
                this.rv$1 = rv$1;
            }
        });
        return var2_2;
    }

    public Distribution apply() {
        return new Distribution(this.clone());
    }

    public boolean equals(Object other) {
        Histogram histogram;
        Object object = other;
        boolean bl = object instanceof Histogram ? (histogram = (Histogram)object).count() == this.count() && histogram.sum() == this.sum() && Predef$.MODULE$.longArrayOps(histogram.buckets()).indices().forall((Function1)new Serializable(this, histogram){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Histogram $outer;
            private final Histogram x2$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return this.x2$1.buckets()[i] == this.$outer.buckets()[i];
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.x2$1 = x2$1;
            }
        }) : false;
        return bl;
    }

    public String toString() {
        return new StringBuilder().append((Object)"<Histogram count=").append((Object)BoxesRunTime.boxToLong((long)this.count())).append((Object)" sum=").append((Object)BoxesRunTime.boxToLong((long)this.sum())).append((Object)((TraversableOnce)Predef$.MODULE$.longArrayOps(this.buckets()).indices().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Histogram $outer;

            public final String apply(int i) {
                return new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(i < Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() ? BoxesRunTime.boxToLong((long)Histogram$.MODULE$.buckets()[i]) : "inf"), "=")).append((Object)BoxesRunTime.boxToLong((long)this.$outer.buckets()[i])).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ", ", ", "")).append((Object)">").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Histogram clone() {
        void var1_1;
        Histogram histogram = new Histogram();
        histogram.merge(this);
        return var1_1;
    }
}

