/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.ostrich.stats;

import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.ostrich.admin.PeriodicBackgroundProcess;
import com.twitter.ostrich.stats.Distribution;
import com.twitter.ostrich.stats.StatsCollection;
import com.twitter.ostrich.stats.StatsListener;
import com.twitter.ostrich.stats.StatsSummary;
import com.twitter.util.Duration;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001-\u00111c\u0012:ba\"LG/Z*uCR\u001cHj\\4hKJT!a\u0001\u0003\u0002\u000bM$\u0018\r^:\u000b\u0005\u00151\u0011aB8tiJL7\r\u001b\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f\u0011\tQ!\u00193nS:L!!\u0005\b\u00033A+'/[8eS\u000e\u0014\u0015mY6he>,h\u000e\u001a)s_\u000e,7o\u001d\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u0011Awn\u001d;\u0016\u0003m\u0001\"\u0001H\u0010\u000f\u0005Mi\u0012B\u0001\u0010\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001%\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y!\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000b!|7\u000f\u001e\u0011\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\nA\u0001]8siV\tq\u0005\u0005\u0002\u0014Q%\u0011\u0011\u0006\u0006\u0002\u0004\u0013:$\b\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000bA|'\u000f\u001e\u0011\t\u00115\u0002!Q1A\u0005\u00029\na\u0001]3sS>$W#A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I2\u0011\u0001B;uS2L!\u0001N\u0019\u0003\u0011\u0011+(/\u0019;j_:D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaL\u0001\ba\u0016\u0014\u0018n\u001c3!\u0011!A\u0004A!b\u0001\n\u0003Q\u0012A\u00029sK\u001aL\u0007\u0010\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\u001d\u0001(/\u001a4jq\u0002B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!P\u0001\fg\u0016\u0014h/[2f\u001d\u0006lW-F\u0001?!\r\u0019rhG\u0005\u0003\u0001R\u0011aa\u00149uS>t\u0007\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u0019M,'O^5dK:\u000bW.\u001a\u0011\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015\u000b!bY8mY\u0016\u001cG/[8o!\t1u)D\u0001\u0003\u0013\tA%AA\bTi\u0006$8oQ8mY\u0016\u001cG/[8o\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u0019a\u0014N\\5u}Q9A*\u0014(P!F\u0013\u0006C\u0001$\u0001\u0011\u0015I\u0012\n1\u0001\u001c\u0011\u0015)\u0013\n1\u0001(\u0011\u0015i\u0013\n1\u00010\u0011\u0015A\u0014\n1\u0001\u001c\u0011\u0015a\u0014\n1\u0001?\u0011\u0015!\u0015\n1\u0001F\u0011\u001d!\u0006A1A\u0005\u0002U\u000ba\u0001\\8hO\u0016\u0014X#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e3\u0011a\u00027pO\u001eLgnZ\u0005\u00037b\u0013a\u0001T8hO\u0016\u0014\bBB/\u0001A\u0003%a+A\u0004m_\u001e<WM\u001d\u0011\t\u000f}\u0003!\u0019!C\u0001A\u0006AA.[:uK:,'/F\u0001b!\t1%-\u0003\u0002d\u0005\ti1\u000b^1ug2K7\u000f^3oKJDa!\u001a\u0001!\u0002\u0013\t\u0017!\u00037jgR,g.\u001a:!\u0011\u001d9\u0007A1A\u0005\u0002!\f\u0001\u0002[8ti:\fW.Z\u000b\u0002SB\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0005Y\u0006twMC\u0001o\u0003\u0011Q\u0017M^1\n\u0005\u0001Z\u0007BB9\u0001A\u0003%\u0011.A\u0005i_N$h.Y7fA!)1\u000f\u0001C\u0001i\u0006A\u0001/\u001a:j_\u0012L7\rF\u0001v!\t\u0019b/\u0003\u0002x)\t!QK\\5u\u0011\u0015I\b\u0001\"\u0001{\u0003\u00159(/\u001b;f)\t)8\u0010C\u0003}q\u0002\u0007Q0\u0001\u0003t_\u000e\\\u0007c\u0001@\u0002\u00045\tqPC\u0002\u0002\u00025\f1A\\3u\u0013\r\t)a \u0002\u0007'>\u001c7.\u001a;")
public class GraphiteStatsLogger
extends PeriodicBackgroundProcess
implements ScalaObject {
    private final String host;
    private final int port;
    private final Duration period;
    private final String prefix;
    private final Option<String> serviceName;
    private final Logger logger;
    private final StatsListener listener;
    private final String hostname;

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public Duration period() {
        return this.period;
    }

    public String prefix() {
        return this.prefix;
    }

    public Option<String> serviceName() {
        return this.serviceName;
    }

    public Logger logger() {
        return this.logger;
    }

    public StatsListener listener() {
        return this.listener;
    }

    public String hostname() {
        return this.hostname;
    }

    @Override
    public void periodic() {
        try {
            this.write(new Socket(this.host(), this.port()));
        }
        catch (IOException iOException) {
            this.logger().error("Error connecting to graphite: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
        }
    }

    /*
     * Loose catch block
     */
    public void write(Socket sock) {
        block18: {
            block16: {
                StatsSummary stats = this.listener().get();
                Map statMap = ((MapLike)stats.counters().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<String, Object> apply(Tuple2<String, Object> tuple2) {
                        Tuple2<String, Object> tuple22 = tuple2;
                        if (tuple22 != null) {
                            return new Tuple2(tuple22._1(), (Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)tuple22._2())).doubleValue()));
                        }
                        throw new MatchError(tuple22);
                    }
                }, Map$.MODULE$.canBuildFrom())).$plus$plus(stats.gauges()).$plus$plus((GenTraversableOnce)stats.metrics().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Map<String, Object> apply(Tuple2<String, Distribution> tuple2) {
                        Tuple2<String, Distribution> tuple22 = tuple2;
                        if (tuple22 != null) {
                            String string2;
                            String key$1 = string2 = (String)tuple22._1();
                            return (Map)((Distribution)tuple22._2()).toMap().map((Function1)new Serializable(this, key$1){
                                public static final long serialVersionUID;
                                private final String key$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Tuple2<String, Object> apply(Tuple2<String, Object> tuple2) {
                                    Tuple2<String, Object> tuple22 = tuple2;
                                    if (tuple22 != null) {
                                        return new Tuple2((Object)new StringBuilder().append((Object)this.key$1).append((Object)"_").append(tuple22._1()).toString(), (Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)tuple22._2())).doubleValue()));
                                    }
                                    throw new MatchError(tuple22);
                                }
                                {
                                    this.key$1 = string2;
                                }
                            }, Map$.MODULE$.canBuildFrom());
                        }
                        throw new MatchError(tuple22);
                    }
                }, Map$.MODULE$.canBuildFrom()));
                Map cleanedKeysStatMap = (Map)statMap.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<String, Object> apply(Tuple2<String, Object> tuple2) {
                        Tuple2<String, Object> tuple22 = tuple2;
                        if (tuple22 != null) {
                            return new Tuple2((Object)((String)tuple22._1()).replaceAll(":", "_").replaceAll("/", ".").replaceAll(" ", "_").toLowerCase(), tuple22._2());
                        }
                        throw new MatchError(tuple22);
                    }
                }, Map$.MODULE$.canBuildFrom());
                ObjectRef writer$1 = new ObjectRef(null);
                long epoch$1 = System.currentTimeMillis() / 1000L;
                writer$1.elem = new OutputStreamWriter(sock.getOutputStream());
                try {
                    cleanedKeysStatMap.foreach((Function1)new Serializable(this, writer$1, epoch$1){
                        public static final long serialVersionUID;
                        private final GraphiteStatsLogger $outer;
                        private final ObjectRef writer$1;
                        private final long epoch$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Tuple2<String, Object> tuple2) {
                            Tuple2<String, Object> tuple22 = tuple2;
                            if (tuple22 != null) {
                                ((OutputStreamWriter)this.writer$1.elem).write(Predef$.MODULE$.augmentString("%s.%s.%s %.2f %d\n").formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.prefix(), this.$outer.serviceName().getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return "unknown";
                                    }
                                }), tuple22._1(), BoxesRunTime.boxToDouble((double)Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)tuple22._2()))), BoxesRunTime.boxToLong((long)this.epoch$1)})));
                                return;
                            }
                            throw new MatchError(tuple22);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.writer$1 = objectRef;
                            this.epoch$1 = l;
                        }
                    });
                }
                catch (IOException iOException) {
                    this.logger().error("Error writing data to graphite: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                }
                ((OutputStreamWriter)writer$1.elem).flush();
                if (sock == null) break block16;
                sock.close();
                break block16;
                catch (Exception exception) {
                    block17: {
                        try {
                            this.logger().error("Error writing to Graphite: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()}));
                            if ((OutputStreamWriter)writer$1.elem != null) {
                                try {
                                    ((OutputStreamWriter)writer$1.elem).flush();
                                }
                                catch (IOException iOException) {
                                    this.logger().error("Error while flushing writer: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                                }
                            }
                            if (sock == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (sock != null) {
                                try {
                                    sock.close();
                                }
                                catch (IOException iOException) {
                                    this.logger().error("Error while closing socket: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                                }
                            }
                            writer$1.elem = null;
                            throw throwable;
                        }
                        try {
                            sock.close();
                        }
                        catch (IOException iOException) {
                            this.logger().error("Error while closing socket: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                        }
                    }
                    writer$1.elem = null;
                    break block18;
                }
                catch (IOException iOException) {
                    this.logger().error("Error while closing socket: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iOException.getMessage()}));
                }
            }
            writer$1.elem = null;
        }
    }

    public GraphiteStatsLogger(String host, int port, Duration period, String prefix, Option<String> serviceName, StatsCollection collection) {
        this.host = host;
        this.port = port;
        this.period = period;
        this.prefix = prefix;
        this.serviceName = serviceName;
        super("GraphiteStatsLogger", period);
        this.logger = Logger$.MODULE$.get();
        this.listener = new StatsListener(collection);
        this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
    }
}

