/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.ostrich.stats;

import com.twitter.ostrich.stats.Distribution;
import com.twitter.ostrich.stats.Histogram$;
import java.util.Arrays;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015u!B\u0001\u0003\u0011\u000bY\u0011!\u0003%jgR|wM]1n\u0015\t\u0019A!A\u0003ti\u0006$8O\u0003\u0002\u0006\r\u00059qn\u001d;sS\u000eD'BA\u0004\t\u0003\u001d!x/\u001b;uKJT\u0011!C\u0001\u0004G>l7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA)a\u0004\u0002\n\u0011&\u001cHo\\4sC6\u001c2!\u0004\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"aC*dC2\fwJ\u00196fGRDQaH\u0007\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0006\t\r\tj\u0001\u0015\"\u0003$\u00039i\u0017m[3Ck\u000e\\W\r^:G_J$\"\u0001\n\u0016\u0011\u0007e)s%\u0003\u0002'5\t)\u0011I\u001d:bsB\u0011\u0011\u0004K\u0005\u0003Si\u0011A\u0001T8oO\")1&\ta\u0001Y\u0005)QM\u001d:peB\u0011\u0011$L\u0005\u0003]i\u0011a\u0001R8vE2,\u0007b\u0002\u0019\u000e\u0005\u0004%\t!M\u0001\bEV\u001c7.\u001a;t+\u0005!\u0003BB\u001a\u000eA\u0003%A%\u0001\u0005ck\u000e\\W\r^:!\u0011\u0015)T\u0002\"\u00017\u0003-\u0011WoY6fi&sG-\u001a=\u0015\u0005]R\u0004CA\r9\u0013\tI$DA\u0002J]RDQa\u000f\u001bA\u0002]\n1a[3z\u0011\u0019iT\u0002)C\u0005}\u0005a!-\u001b8bef\u001cV-\u0019:dQR)qg\u0010\"D\u000b\")\u0001\t\u0010a\u0001\u0003\u0006)\u0011M\u001d:bsB\u0019\u0011$J\u001c\t\u000bmb\u0004\u0019A\u001c\t\u000b\u0011c\u0004\u0019A\u001c\u0002\u00071|w\u000fC\u0003Gy\u0001\u0007q'\u0001\u0003iS\u001eD\u0007F\u0001\u001fI!\tIE*D\u0001K\u0015\tY%$\u0001\u0006b]:|G/\u0019;j_:L!!\u0014&\u0003\u000fQ\f\u0017\u000e\u001c:fG\")q*\u0004C\u0001!\u0006)\u0011\r\u001d9msR\u0019\u0011+a\u001f\u0011\u00051\u0011f\u0001\u0002\b\u0003\u0001M\u001b2A\u0015\t\u0019\u0011\u0015y\"\u000b\"\u0001V)\u0005\t\u0006bB,S\u0005\u0004%\t\u0001W\u0001\u000b]Vl')^2lKR\u001cX#A\u001c\t\ri\u0013\u0006\u0015!\u00038\u0003-qW/\u001c\"vG.,Go\u001d\u0011\t\u000fA\u0012&\u0019!C\u0001c!11G\u0015Q\u0001\n\u0011BqA\u0018*A\u0002\u0013\u0005q,A\u0003d_VtG/F\u0001(\u0011\u001d\t'\u000b1A\u0005\u0002\t\f\u0011bY8v]R|F%Z9\u0015\u0005\r4\u0007CA\re\u0013\t)'D\u0001\u0003V]&$\bbB4a\u0003\u0003\u0005\raJ\u0001\u0004q\u0012\n\u0004BB5SA\u0003&q%\u0001\u0004d_VtG\u000f\t\u0005\bWJ\u0003\r\u0011\"\u0001`\u0003\r\u0019X/\u001c\u0005\b[J\u0003\r\u0011\"\u0001o\u0003\u001d\u0019X/\\0%KF$\"aY8\t\u000f\u001dd\u0017\u0011!a\u0001O!1\u0011O\u0015Q!\n\u001d\nAa];nA!)1O\u0015C\u0001i\u0006Y\u0011\r\u001a3U_\n+8m[3u)\t\u0019W\u000fC\u0003we\u0002\u0007q'A\u0003j]\u0012,\u0007\u0010C\u0003y%\u0012\u0005\u00110A\u0002bI\u0012$\"a\n>\t\u000bm<\b\u0019A\u001c\u0002\u00039DQ! *\u0005\u0002y\fQa\u00197fCJ$\u0012a\u0019\u0005\b\u0003\u0003\u0011F\u0011AA\u0002\u0003\r9W\r\u001e\u000b\u0005\u0003\u000b\ti\u0002E\u0003\u0002\b\u0005]qE\u0004\u0003\u0002\n\u0005Ma\u0002BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=!\"\u0001\u0004=e>|GOP\u0005\u00027%\u0019\u0011Q\u0003\u000e\u0002\u000fA\f7m[1hK&!\u0011\u0011DA\u000e\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005U!\u0004C\u0004\u0002 }\u0004\r!!\t\u0002\u000bI,7/\u001a;\u0011\u0007e\t\u0019#C\u0002\u0002&i\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002*I#\t!a\u000b\u0002\u001b\u001d,G\u000fU3sG\u0016tG/\u001b7f)\r9\u0014Q\u0006\u0005\b\u0003_\t9\u00031\u0001-\u0003)\u0001XM]2f]RLG.\u001a\u0005\u0007\u0003g\u0011F\u0011\u0001-\u0002\u000f5\f\u00070[7v[\"1\u0011q\u0007*\u0005\u0002a\u000bq!\\5oS6,X\u000eC\u0004\u0002<I#\t\"!\u0010\u0002\u00115LG\r]8j]R$2aNA \u0011\u00191\u0018\u0011\ba\u0001o!9\u00111\t*\u0005\u0002\u0005\u0015\u0013!B7fe\u001e,GcA2\u0002H!9\u0011\u0011JA!\u0001\u0004\t\u0016!B8uQ\u0016\u0014\bbBA'%\u0012\u0005\u0011qJ\u0001\u0007I5Lg.^:\u0015\u0007E\u000b\t\u0006C\u0004\u0002J\u0005-\u0003\u0019A)\t\r=\u0013F\u0011AA+)\t\t9\u0006E\u0002\r\u00033J1!a\u0017\u0003\u00051!\u0015n\u001d;sS\n,H/[8o\u0011\u001d\tyF\u0015C!\u0003C\na!Z9vC2\u001cH\u0003BA\u0011\u0003GB\u0001\"!\u0013\u0002^\u0001\u0007\u0011Q\r\t\u00043\u0005\u001d\u0014bAA55\t\u0019\u0011I\\=\t\u000f\u00055$\u000b\"\u0011\u0002p\u0005AAo\\*ue&tw\r\u0006\u0002\u0002rA\u0019\u0011#a\u001d\n\u0007\u0005U$C\u0001\u0004TiJLgn\u001a\u0005\u0007\u0003s\u0012F\u0011I+\u0002\u000b\rdwN\\3\t\u000f\u0005ud\n1\u0001\u0002\u0000\u00051a/\u00197vKN\u0004B!GAAo%\u0019\u00111\u0011\u000e\u0003\u0015q\u0012X\r]3bi\u0016$g\b")
public class Histogram
implements ScalaObject {
    private final int numBuckets = Histogram$.MODULE$.buckets().length + 1;
    private final long[] buckets = new long[this.numBuckets()];
    private long count = 0L;
    private long sum = 0L;

    public static final int bucketIndex(int n) {
        return Histogram$.MODULE$.bucketIndex(n);
    }

    public int numBuckets() {
        return this.numBuckets;
    }

    public long[] buckets() {
        return this.buckets;
    }

    public long count() {
        return this.count;
    }

    public void count_$eq(long l) {
        this.count = l;
    }

    public long sum() {
        return this.sum;
    }

    public void sum_$eq(long l) {
        this.sum = l;
    }

    public void addToBucket(int index) {
        this.buckets()[index] = this.buckets()[index] + 1L;
        this.count_$eq(this.count() + 1L);
    }

    public long add(int n) {
        int index = Histogram$.MODULE$.bucketIndex(n);
        Histogram histogram = this;
        synchronized (histogram) {
            this.addToBucket(index);
            this.sum_$eq(this.sum() + (long)n);
            return this.count();
        }
    }

    public void clear() {
        Histogram histogram = this;
        synchronized (histogram) {
            Arrays.fill(this.buckets(), 0L);
            this.count_$eq(0L);
            this.sum_$eq(0L);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> get(boolean reset2) {
        void var2_2;
        List rv = Predef$.MODULE$.longArrayOps(this.buckets()).toList();
        if (reset2) {
            this.clear();
        }
        return var2_2;
    }

    public int getPercentile(double percentile) {
        Histogram histogram = this;
        synchronized (histogram) {
            int index;
            if (percentile == 0.0) {
                return this.minimum();
            }
            long total = 0L;
            for (index = 0; index < Predef$.MODULE$.longArrayOps(this.buckets()).size() && (double)total < percentile * (double)this.count(); ++index) {
                total += this.buckets()[index];
            }
            Integer n = index == 0 ? BoxesRunTime.boxToInteger((int)0) : (index - 1 == Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() ? BoxesRunTime.boxToInteger((int)this.maximum()) : BoxesRunTime.boxToInteger((int)this.midpoint(index - 1)));
            return BoxesRunTime.unboxToInt((Object)n);
        }
    }

    public int maximum() {
        int n;
        if (this.buckets()[Predef$.MODULE$.longArrayOps(this.buckets()).size() - 1] > 0L) {
            n = Integer.MAX_VALUE;
        } else if (this.count() == 0L) {
            n = 0;
        } else {
            int index;
            for (index = Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() - 1; index >= 0 && this.buckets()[index] == 0L; --index) {
            }
            n = index < 0 ? 0 : this.midpoint(index);
        }
        return n;
    }

    public int minimum() {
        int n;
        if (this.count() == 0L) {
            n = 0;
        } else {
            int index;
            for (index = 0; index < Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() && this.buckets()[index] == 0L; ++index) {
            }
            n = index >= Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() ? Integer.MAX_VALUE : this.midpoint(index);
        }
        return n;
    }

    public int midpoint(int index) {
        return index == 0 ? 0 : (index - 1 >= Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() ? Integer.MAX_VALUE : (int)((Histogram$.MODULE$.buckets()[index - 1] + Histogram$.MODULE$.buckets()[index] - 1L) / 2L));
    }

    public void merge(Histogram other$2) {
        if (other$2.count() > 0L) {
            Predef$.MODULE$.intWrapper(0).until(this.numBuckets()).foreach$mVc$sp((Function1)new Serializable(this, other$2){
                public static final long serialVersionUID;
                private final Histogram $outer;
                private final Histogram other$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int v1) {
                    this.$outer.buckets()[v1] = this.$outer.buckets()[v1] + this.other$2.buckets()[v1];
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.other$2 = histogram;
                }
            });
            this.count_$eq(this.count() + other$2.count());
            this.sum_$eq(this.sum() + other$2.sum());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Histogram $minus(Histogram other$1) {
        void var2_2;
        Histogram rv$1 = new Histogram();
        rv$1.sum_$eq(package$.MODULE$.max(0L, this.sum() - other$1.sum()));
        Predef$.MODULE$.intWrapper(0).until(this.numBuckets()).foreach$mVc$sp((Function1)new Serializable(this, other$1, rv$1){
            public static final long serialVersionUID;
            private final Histogram $outer;
            private final Histogram other$1;
            private final Histogram rv$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                this.rv$1.buckets()[v1] = package$.MODULE$.max(0L, this.$outer.buckets()[v1] - this.other$1.buckets()[v1]);
                this.rv$1.count_$eq(this.rv$1.count() + this.rv$1.buckets()[v1]);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = histogram;
                this.rv$1 = histogram2;
            }
        });
        return var2_2;
    }

    public Distribution apply() {
        return new Distribution(this.clone());
    }

    public boolean equals(Object other) {
        Histogram histogram;
        Histogram h$2;
        Object object = other;
        return object instanceof Histogram ? (h$2 = (histogram = (Histogram)object)).count() == this.count() && h$2.sum() == this.sum() && Predef$.MODULE$.longArrayOps(h$2.buckets()).indices().forall((Function1)new Serializable(this, h$2){
            public static final long serialVersionUID;
            private final Histogram $outer;
            private final Histogram h$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int v1) {
                return this.h$2.buckets()[v1] == this.$outer.buckets()[v1];
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.h$2 = histogram;
            }
        }) : false;
    }

    public String toString() {
        return new StringBuilder().append((Object)"<Histogram count=").append((Object)BoxesRunTime.boxToLong((long)this.count())).append((Object)" sum=").append((Object)BoxesRunTime.boxToLong((long)this.sum())).append((Object)((TraversableOnce)Predef$.MODULE$.longArrayOps(this.buckets()).indices().map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final Histogram $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(int i) {
                return new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(i < Predef$.MODULE$.longArrayOps(Histogram$.MODULE$.buckets()).size() ? BoxesRunTime.boxToLong((long)Histogram$.MODULE$.buckets()[i]) : "inf").$plus("=")).append((Object)BoxesRunTime.boxToLong((long)this.$outer.buckets()[i])).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ", ", ", "")).append((Object)">").toString();
    }

    /*
     * WARNING - void declaration
     */
    public Histogram clone() {
        void var1_1;
        Histogram histogram = new Histogram();
        histogram.merge(this);
        return var1_1;
    }
}

