/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import parquet.avro.AvroSchemaConverter;
import parquet.avro.AvroWriteSupport;
import parquet.hadoop.ParquetWriter;
import parquet.hadoop.api.WriteSupport;
import parquet.hadoop.metadata.CompressionCodecName;

public class AvroParquetWriter<T extends IndexedRecord>
extends ParquetWriter<T> {
    public AvroParquetWriter(Path file, Schema avroSchema, CompressionCodecName compressionCodecName, int blockSize, int pageSize) throws IOException {
        super(file, (WriteSupport)new AvroWriteSupport(new AvroSchemaConverter().convert(avroSchema), avroSchema), compressionCodecName, blockSize, pageSize);
    }

    public AvroParquetWriter(Path file, Schema avroSchema, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary) throws IOException {
        super(file, (WriteSupport)new AvroWriteSupport(new AvroSchemaConverter().convert(avroSchema), avroSchema), compressionCodecName, blockSize, pageSize, enableDictionary, false);
    }

    public AvroParquetWriter(Path file, Schema avroSchema) throws IOException {
        this(file, avroSchema, CompressionCodecName.UNCOMPRESSED, 0x8000000, 0x100000);
    }
}

