/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.page.mem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.page.Page;
import parquet.column.page.PageWriter;
import parquet.io.ParquetEncodingException;

public class MemPageWriter
implements PageWriter {
    private static final Log LOG = Log.getLog(MemPageWriter.class);
    private final List<Page> pages = new ArrayList<Page>();
    private DictionaryPage dictionaryPage;
    private long memSize = 0L;
    private long totalValueCount = 0L;

    public void writePage(BytesInput bytesInput, int valueCount, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
        if (valueCount == 0) {
            throw new ParquetEncodingException("illegal page of 0 values");
        }
        this.memSize += bytesInput.size();
        this.pages.add(new Page(BytesInput.copy((BytesInput)bytesInput), valueCount, (int)bytesInput.size(), rlEncoding, dlEncoding, valuesEncoding));
        this.totalValueCount += (long)valueCount;
        if (Log.DEBUG) {
            LOG.debug((Object)("page written for " + bytesInput.size() + " bytes and " + valueCount + " records"));
        }
    }

    public long getMemSize() {
        return this.memSize;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public DictionaryPage getDictionaryPage() {
        return this.dictionaryPage;
    }

    public long getTotalValueCount() {
        return this.totalValueCount;
    }

    public long allocatedSize() {
        return this.memSize;
    }

    public void writeDictionaryPage(DictionaryPage dictionaryPage) throws IOException {
        if (this.dictionaryPage != null) {
            throw new ParquetEncodingException("Only one dictionary page per block");
        }
        this.memSize += dictionaryPage.getBytes().size();
        this.dictionaryPage = dictionaryPage.copy();
        if (Log.DEBUG) {
            LOG.debug((Object)("dictionary page written for " + dictionaryPage.getBytes().size() + " bytes and " + dictionaryPage.getDictionarySize() + " records"));
        }
    }

    public String memUsageString(String prefix) {
        return String.format("%s %,d bytes", prefix, this.memSize);
    }
}

