/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.dictionary;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import parquet.bytes.BytesInput;
import parquet.column.ColumnDescriptor;
import parquet.column.Dictionary;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.values.dictionary.DictionaryValuesReader;
import parquet.column.values.dictionary.DictionaryValuesWriter;
import parquet.column.values.plain.BinaryPlainValuesReader;
import parquet.column.values.plain.PlainValuesReader;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.io.api.Binary;
import parquet.schema.PrimitiveType;

public class TestDictionary {
    @Test
    public void testBinaryDictionary() throws IOException {
        String str;
        int i;
        int COUNT = 100;
        DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(10000, 10000);
        for (int i2 = 0; i2 < COUNT; ++i2) {
            cw.writeBytes(Binary.fromString((String)("a" + i2 % 10)));
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        for (int i3 = 0; i3 < COUNT; ++i3) {
            cw.writeBytes(Binary.fromString((String)("b" + i3 % 10)));
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        BytesInput bytes2 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        DictionaryPage dictionaryPage = cw.createDictionaryPage().copy();
        ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"foo"}, PrimitiveType.PrimitiveTypeName.BINARY, 0, 0);
        Dictionary dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
        DictionaryValuesReader cr = new DictionaryValuesReader(dictionary);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0; i < COUNT; ++i) {
            str = cr.readBytes().toStringUsingUTF8();
            Assert.assertEquals((Object)("a" + i % 10), (Object)str);
        }
        cr.initFromPage((long)COUNT, bytes2.toByteArray(), 0);
        for (i = 0; i < COUNT; ++i) {
            str = cr.readBytes().toStringUsingUTF8();
            Assert.assertEquals((Object)("b" + i % 10), (Object)str);
        }
    }

    @Test
    public void testBinaryDictionaryInefficiency() throws IOException {
        String str;
        int i;
        Object cr;
        int COUNT = 40000;
        DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(2000000, 10000);
        for (int i2 = 0; i2 < COUNT; ++i2) {
            cw.writeBytes(Binary.fromString((String)("a" + i2)));
        }
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        Encoding encoding1 = cw.getEncoding();
        System.out.println(PrimitiveType.PrimitiveTypeName.BINARY.name() + " " + encoding1 + "  " + bytes1.size());
        cw.reset();
        for (int i3 = 0; i3 < COUNT; ++i3) {
            cw.writeBytes(Binary.fromString((String)("b" + i3)));
        }
        BytesInput bytes2 = BytesInput.copy((BytesInput)cw.getBytes());
        Encoding encoding2 = cw.getEncoding();
        System.out.println(PrimitiveType.PrimitiveTypeName.BINARY.name() + " " + encoding2 + "  " + bytes2.size());
        cw.reset();
        DictionaryPage dictionaryPage = cw.createDictionaryPage();
        Dictionary dictionary = null;
        long dictPageSize = 0L;
        if (dictionaryPage != null) {
            dictPageSize = dictionaryPage.getBytes().size();
            System.out.println(PrimitiveType.PrimitiveTypeName.BINARY.name() + " dict byte size: " + dictPageSize);
            ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"foo"}, PrimitiveType.PrimitiveTypeName.BINARY, 0, 0);
            dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
            cr = new DictionaryValuesReader(dictionary);
        } else {
            cr = new BinaryPlainValuesReader();
        }
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0; i < COUNT; ++i) {
            str = cr.readBytes().toStringUsingUTF8();
            Assert.assertEquals((Object)("a" + i), (Object)str);
        }
        cr = dictionary != null && encoding2 == Encoding.PLAIN_DICTIONARY ? new DictionaryValuesReader(dictionary) : new BinaryPlainValuesReader();
        cr.initFromPage((long)COUNT, bytes2.toByteArray(), 0);
        for (i = 0; i < COUNT; ++i) {
            str = cr.readBytes().toStringUsingUTF8();
            Assert.assertEquals((Object)("b" + i), (Object)str);
        }
        Assert.assertTrue((bytes1.size() < bytes2.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)dictPageSize, (long)bytes2.size());
    }

    @Test
    public void testLongDictionary() throws IOException {
        long back;
        long i;
        int COUNT = 1000;
        int COUNT2 = 2000;
        DictionaryValuesWriter.PlainLongDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(10000, 10000);
        for (long i2 = 0L; i2 < (long)COUNT; ++i2) {
            cw.writeLong(i2 % 50L);
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        for (long i3 = (long)COUNT2; i3 > 0L; --i3) {
            cw.writeLong(i3 % 50L);
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        BytesInput bytes2 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        DictionaryPage dictionaryPage = cw.createDictionaryPage().copy();
        ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"along"}, PrimitiveType.PrimitiveTypeName.INT64, 0, 0);
        Dictionary dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
        DictionaryValuesReader cr = new DictionaryValuesReader(dictionary);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0L; i < (long)COUNT; ++i) {
            back = cr.readLong();
            Assert.assertEquals((long)(i % 50L), (long)back);
        }
        cr.initFromPage((long)COUNT2, bytes2.toByteArray(), 0);
        for (i = (long)COUNT2; i > 0L; --i) {
            back = cr.readLong();
            Assert.assertEquals((long)(i % 50L), (long)back);
        }
    }

    @Test
    public void testLongDictionaryInefficiency() throws IOException {
        PlainValuesReader.LongPlainValuesReader cr;
        int COUNT = 50000;
        DictionaryValuesWriter.PlainLongDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(2000000, 10000);
        for (long i = 0L; i < (long)COUNT; ++i) {
            cw.writeLong(i);
        }
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        Encoding encoding1 = cw.getEncoding();
        System.out.println(PrimitiveType.PrimitiveTypeName.INT64.name() + " " + encoding1 + "  " + bytes1.size());
        PlainValuesWriter pw = new PlainValuesWriter(65536);
        for (long i = 0L; i < (long)COUNT; ++i) {
            pw.writeLong(i);
        }
        BytesInput bytes2 = pw.getBytes();
        System.out.println(PrimitiveType.PrimitiveTypeName.INT64.name() + " " + pw.getEncoding() + "  " + bytes2.size());
        DictionaryPage dictionaryPage = cw.createDictionaryPage();
        Dictionary dictionary = null;
        long dictPageSize = 0L;
        if (dictionaryPage != null) {
            dictPageSize = dictionaryPage.getBytes().size();
            System.out.println(PrimitiveType.PrimitiveTypeName.INT64.name() + " dict byte size: " + dictPageSize);
            ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"along"}, PrimitiveType.PrimitiveTypeName.INT64, 0, 0);
            dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
            cr = new DictionaryValuesReader(dictionary);
        } else {
            cr = new PlainValuesReader.LongPlainValuesReader();
        }
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (long i = 0L; i < (long)COUNT; ++i) {
            long back = cr.readLong();
            Assert.assertEquals((long)i, (long)back);
        }
        Assert.assertTrue((bytes1.size() < bytes2.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)dictPageSize, (long)bytes2.size());
    }

    @Test
    public void testDoubleDictionary() throws IOException {
        double back;
        double i;
        int COUNT = 1000;
        int COUNT2 = 2000;
        DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(10000, 10000);
        for (double i2 = 0.0; i2 < (double)COUNT; i2 += 1.0) {
            cw.writeDouble(i2 % 50.0);
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        for (double i3 = (double)COUNT2; i3 > 0.0; i3 -= 1.0) {
            cw.writeDouble(i3 % 50.0);
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        BytesInput bytes2 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        DictionaryPage dictionaryPage = cw.createDictionaryPage().copy();
        ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"adouble"}, PrimitiveType.PrimitiveTypeName.DOUBLE, 0, 0);
        Dictionary dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
        DictionaryValuesReader cr = new DictionaryValuesReader(dictionary);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0.0; i < (double)COUNT; i += 1.0) {
            back = cr.readDouble();
            Assert.assertEquals((double)(i % 50.0), (double)back, (double)0.0);
        }
        cr.initFromPage((long)COUNT2, bytes2.toByteArray(), 0);
        for (i = (double)COUNT2; i > 0.0; i -= 1.0) {
            back = cr.readDouble();
            Assert.assertEquals((double)(i % 50.0), (double)back, (double)0.0);
        }
    }

    @Test
    public void testDoubleDictionaryInefficiency() throws IOException {
        PlainValuesReader.DoublePlainValuesReader cr;
        int COUNT = 30000;
        DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(2000000, 10000);
        for (double i = 0.0; i < (double)COUNT; i += 1.0) {
            cw.writeDouble(i);
        }
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        Encoding encoding1 = cw.getEncoding();
        System.out.println(PrimitiveType.PrimitiveTypeName.DOUBLE.name() + " " + encoding1 + "  " + bytes1.size());
        PlainValuesWriter pw = new PlainValuesWriter(65536);
        for (double i = 0.0; i < (double)COUNT; i += 1.0) {
            pw.writeDouble(i);
        }
        BytesInput bytes2 = pw.getBytes();
        System.out.println(PrimitiveType.PrimitiveTypeName.DOUBLE.name() + " " + pw.getEncoding() + "  " + bytes2.size());
        DictionaryPage dictionaryPage = cw.createDictionaryPage();
        Dictionary dictionary = null;
        long dictPageSize = 0L;
        if (dictionaryPage != null) {
            dictPageSize = dictionaryPage.getBytes().size();
            System.out.println(PrimitiveType.PrimitiveTypeName.DOUBLE.name() + " dict byte size: " + dictPageSize);
            ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"adouble"}, PrimitiveType.PrimitiveTypeName.DOUBLE, 0, 0);
            dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
            cr = new DictionaryValuesReader(dictionary);
        } else {
            cr = new PlainValuesReader.DoublePlainValuesReader();
        }
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (double i = 0.0; i < (double)COUNT; i += 1.0) {
            double back = cr.readDouble();
            Assert.assertEquals((double)i, (double)back, (double)0.0);
        }
        Assert.assertTrue((bytes1.size() < bytes2.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)dictPageSize, (long)bytes2.size());
    }

    @Test
    public void testIntDictionary() throws IOException {
        int back;
        int i;
        int COUNT = 2000;
        int COUNT2 = 4000;
        DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(10000, 10000);
        for (int i2 = 0; i2 < COUNT; ++i2) {
            cw.writeInteger(i2 % 50);
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        for (int i3 = COUNT2; i3 > 0; --i3) {
            cw.writeInteger(i3 % 50);
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        BytesInput bytes2 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        DictionaryPage dictionaryPage = cw.createDictionaryPage().copy();
        ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"anint"}, PrimitiveType.PrimitiveTypeName.INT32, 0, 0);
        Dictionary dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
        DictionaryValuesReader cr = new DictionaryValuesReader(dictionary);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0; i < COUNT; ++i) {
            back = cr.readInteger();
            Assert.assertEquals((long)(i % 50), (long)back);
        }
        cr.initFromPage((long)COUNT2, bytes2.toByteArray(), 0);
        for (i = COUNT2; i > 0; --i) {
            back = cr.readInteger();
            Assert.assertEquals((long)(i % 50), (long)back);
        }
    }

    @Test
    public void testIntDictionaryInefficiency() throws IOException {
        PlainValuesReader.IntegerPlainValuesReader cr;
        int COUNT = 20000;
        DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(2000000, 10000);
        for (int i = 0; i < COUNT; ++i) {
            cw.writeInteger(i);
        }
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        Encoding encoding1 = cw.getEncoding();
        System.out.println(PrimitiveType.PrimitiveTypeName.INT32.name() + " " + encoding1 + "  " + bytes1.size());
        PlainValuesWriter pw = new PlainValuesWriter(65536);
        for (int i = 0; i < COUNT; ++i) {
            pw.writeInteger(i);
        }
        BytesInput bytes2 = pw.getBytes();
        System.out.println(PrimitiveType.PrimitiveTypeName.INT32.name() + " " + pw.getEncoding() + "  " + bytes2.size());
        DictionaryPage dictionaryPage = cw.createDictionaryPage();
        Dictionary dictionary = null;
        long dictPageSize = 0L;
        if (dictionaryPage != null) {
            dictPageSize = dictionaryPage.getBytes().size();
            System.out.println(PrimitiveType.PrimitiveTypeName.INT32.name() + " dict byte size: " + dictPageSize);
            ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"anint"}, PrimitiveType.PrimitiveTypeName.INT32, 0, 0);
            dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
            cr = new DictionaryValuesReader(dictionary);
        } else {
            cr = new PlainValuesReader.IntegerPlainValuesReader();
        }
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (int i = 0; i < COUNT; ++i) {
            int back = cr.readInteger();
            Assert.assertEquals((long)i, (long)back);
        }
        Assert.assertTrue((bytes1.size() < bytes2.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)dictPageSize, (long)bytes2.size());
    }

    @Test
    public void testFloatDictionary() throws IOException {
        float back;
        float i;
        int COUNT = 2000;
        int COUNT2 = 4000;
        DictionaryValuesWriter.PlainFloatDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(10000, 10000);
        for (float i2 = 0.0f; i2 < (float)COUNT; i2 += 1.0f) {
            cw.writeFloat(i2 % 50.0f);
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        for (float i3 = (float)COUNT2; i3 > 0.0f; i3 -= 1.0f) {
            cw.writeFloat(i3 % 50.0f);
        }
        Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        BytesInput bytes2 = BytesInput.copy((BytesInput)cw.getBytes());
        cw.reset();
        DictionaryPage dictionaryPage = cw.createDictionaryPage().copy();
        ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"afloat"}, PrimitiveType.PrimitiveTypeName.FLOAT, 0, 0);
        Dictionary dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
        DictionaryValuesReader cr = new DictionaryValuesReader(dictionary);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0.0f; i < (float)COUNT; i += 1.0f) {
            back = cr.readFloat();
            Assert.assertEquals((double)(i % 50.0f), (double)back, (double)0.0);
        }
        cr.initFromPage((long)COUNT2, bytes2.toByteArray(), 0);
        for (i = (float)COUNT2; i > 0.0f; i -= 1.0f) {
            back = cr.readFloat();
            Assert.assertEquals((double)(i % 50.0f), (double)back, (double)0.0);
        }
    }

    @Test
    public void testFloatDictionaryInefficiency() throws IOException {
        PlainValuesReader.FloatPlainValuesReader cr;
        int COUNT = 60000;
        DictionaryValuesWriter.PlainFloatDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(2000000, 10000);
        for (float i = 0.0f; i < (float)COUNT; i += 1.0f) {
            cw.writeFloat(i);
        }
        BytesInput bytes1 = BytesInput.copy((BytesInput)cw.getBytes());
        Encoding encoding1 = cw.getEncoding();
        System.out.println(PrimitiveType.PrimitiveTypeName.FLOAT.name() + " " + encoding1 + "  " + bytes1.size());
        PlainValuesWriter pw = new PlainValuesWriter(65536);
        for (float i = 0.0f; i < (float)COUNT; i += 1.0f) {
            pw.writeFloat(i);
        }
        BytesInput bytes2 = pw.getBytes();
        System.out.println(PrimitiveType.PrimitiveTypeName.FLOAT.name() + " " + pw.getEncoding() + "  " + bytes2.size());
        DictionaryPage dictionaryPage = cw.createDictionaryPage();
        Dictionary dictionary = null;
        long dictPageSize = 0L;
        if (dictionaryPage != null) {
            dictPageSize = dictionaryPage.getBytes().size();
            System.out.println(PrimitiveType.PrimitiveTypeName.FLOAT.name() + " dict byte size: " + dictPageSize);
            ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"afloat"}, PrimitiveType.PrimitiveTypeName.FLOAT, 0, 0);
            dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
            cr = new DictionaryValuesReader(dictionary);
        } else {
            cr = new PlainValuesReader.FloatPlainValuesReader();
        }
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (float i = 0.0f; i < (float)COUNT; i += 1.0f) {
            float back = cr.readFloat();
            Assert.assertEquals((double)i, (double)back, (double)0.0);
        }
        Assert.assertTrue((bytes1.size() < bytes2.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)dictPageSize, (long)bytes2.size());
    }
}

