/*
 * Decompiled with CFR 0.152.
 */
package parquet.parser;

import org.junit.Assert;
import org.junit.Test;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class TestParquetParser {
    @Test
    public void test() throws Exception {
        String example = "message Document {\n  required int64 DocId;\n  optional group Links {\n    repeated int64 Backward;\n    repeated int64 Forward; }\n  repeated group Name {\n    repeated group Language {\n      required binary Code;\n      required binary Country; }\n    optional binary Url; }}";
        MessageType parsed = MessageTypeParser.parseMessageType((String)example);
        MessageType manuallyMade = new MessageType("Document", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Forward")}), new GroupType(Type.Repetition.REPEATED, "Name", new Type[]{new GroupType(Type.Repetition.REPEATED, "Language", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Code"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Country")}), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Url")})});
        Assert.assertEquals((Object)manuallyMade, (Object)parsed);
        MessageType parsedThenReparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)manuallyMade, (Object)parsedThenReparsed);
        parsed = MessageTypeParser.parseMessageType((String)"message m { required group a {required binary b;} required group c { required int64 d; }}");
        manuallyMade = new MessageType("m", new Type[]{new GroupType(Type.Repetition.REQUIRED, "a", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "b")}), new GroupType(Type.Repetition.REQUIRED, "c", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "d")})});
        Assert.assertEquals((Object)manuallyMade, (Object)parsed);
        parsedThenReparsed = MessageTypeParser.parseMessageType((String)parsed.toString());
        Assert.assertEquals((Object)manuallyMade, (Object)parsedThenReparsed);
    }
}

