/*
 * Decompiled with CFR 0.152.
 */
package parquet.schema;

import org.junit.Assert;
import org.junit.Test;
import parquet.example.Paper;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class TestMessageType {
    @Test
    public void test() throws Exception {
        System.out.println(Paper.schema.toString());
        MessageType schema = MessageTypeParser.parseMessageType((String)Paper.schema.toString());
        Assert.assertEquals((Object)Paper.schema, (Object)schema);
        Assert.assertEquals((Object)schema.toString(), (Object)Paper.schema.toString());
    }

    @Test
    public void testNestedTypes() {
        MessageType schema = MessageTypeParser.parseMessageType((String)Paper.schema.toString());
        Type type = schema.getType(new String[]{"Links", "Backward"});
        Assert.assertEquals((Object)PrimitiveType.PrimitiveTypeName.INT64, (Object)type.asPrimitiveType().getPrimitiveTypeName());
        Assert.assertEquals((long)0L, (long)schema.getMaxRepetitionLevel(new String[]{"DocId"}));
        Assert.assertEquals((long)1L, (long)schema.getMaxRepetitionLevel(new String[]{"Name"}));
        Assert.assertEquals((long)2L, (long)schema.getMaxRepetitionLevel(new String[]{"Name", "Language"}));
        Assert.assertEquals((long)0L, (long)schema.getMaxDefinitionLevel(new String[]{"DocId"}));
        Assert.assertEquals((long)1L, (long)schema.getMaxDefinitionLevel(new String[]{"Links"}));
        Assert.assertEquals((long)2L, (long)schema.getMaxDefinitionLevel(new String[]{"Links", "Backward"}));
    }
}

