/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import parquet.column.ColumnDescriptor;
import parquet.column.ColumnWriteStore;
import parquet.column.ColumnWriter;
import parquet.column.impl.ColumnWriterImpl;
import parquet.column.page.PageWriteStore;
import parquet.column.page.PageWriter;

public class ColumnWriteStoreImpl
implements ColumnWriteStore {
    private final Map<ColumnDescriptor, ColumnWriterImpl> columns = new TreeMap<ColumnDescriptor, ColumnWriterImpl>();
    private final PageWriteStore pageWriteStore;
    private final int pageSizeThreshold;
    private final boolean enableDictionary;
    private final int initialSizePerCol;

    public ColumnWriteStoreImpl(PageWriteStore pageWriteStore, int pageSizeThreshold, int initialSizePerCol, boolean enableDictionary) {
        this.pageWriteStore = pageWriteStore;
        this.pageSizeThreshold = pageSizeThreshold;
        this.initialSizePerCol = initialSizePerCol;
        this.enableDictionary = enableDictionary;
    }

    @Override
    public ColumnWriter getColumnWriter(ColumnDescriptor path) {
        ColumnWriterImpl column = this.columns.get(path);
        if (column == null) {
            column = this.newMemColumn(path);
            this.columns.put(path, column);
        }
        return column;
    }

    private ColumnWriterImpl newMemColumn(ColumnDescriptor path) {
        PageWriter pageWriter = this.pageWriteStore.getPageWriter(path);
        return new ColumnWriterImpl(path, pageWriter, this.pageSizeThreshold, this.initialSizePerCol, this.enableDictionary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ColumnDescriptor, ColumnWriterImpl> entry : this.columns.entrySet()) {
            sb.append(Arrays.toString(entry.getKey().getPath())).append(": ");
            sb.append(entry.getValue().getBufferedSizeInMemory()).append(" bytes");
            sb.append("\n");
        }
        return sb.toString();
    }

    public long allocatedSize() {
        Collection<ColumnWriterImpl> values = this.columns.values();
        long total = 0L;
        for (ColumnWriterImpl memColumn : values) {
            total += memColumn.allocatedSize();
        }
        return total;
    }

    public long memSize() {
        Collection<ColumnWriterImpl> values = this.columns.values();
        long total = 0L;
        for (ColumnWriterImpl memColumn : values) {
            total += memColumn.getBufferedSizeInMemory();
        }
        return total;
    }

    public long maxColMemSize() {
        Collection<ColumnWriterImpl> values = this.columns.values();
        long max = 0L;
        for (ColumnWriterImpl memColumn : values) {
            max = Math.max(max, memColumn.getBufferedSizeInMemory());
        }
        return max;
    }

    @Override
    public void flush() {
        Collection<ColumnWriterImpl> values = this.columns.values();
        for (ColumnWriterImpl memColumn : values) {
            memColumn.flush();
        }
    }

    public String memUsageString() {
        StringBuilder b = new StringBuilder("Store {\n");
        Collection<ColumnWriterImpl> values = this.columns.values();
        for (ColumnWriterImpl memColumn : values) {
            b.append(memColumn.memUsageString(" "));
        }
        b.append("}\n");
        return b.toString();
    }
}

