/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import parquet.Log;
import parquet.bytes.BytesUtils;
import parquet.column.values.ValuesReader;
import parquet.column.values.bitpacking.BitPacking;
import parquet.io.ParquetDecodingException;

public class BitPackingValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BitPackingValuesReader.class);
    private ByteArrayInputStream in;
    private BitPacking.BitPackingReader bitPackingReader;
    private final int bitsPerValue;

    public BitPackingValuesReader(int bound) {
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt((int)bound);
    }

    @Override
    public int readInteger() {
        try {
            return this.bitPackingReader.read();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public int initFromPage(long valueCount, byte[] in, int offset) throws IOException {
        int effectiveBitLength = (int)valueCount * this.bitsPerValue;
        int length = BytesUtils.paddedByteCountFromBits((int)effectiveBitLength);
        if (Log.DEBUG) {
            LOG.debug((Object)("reading " + length + " bytes for " + valueCount + " values of size " + this.bitsPerValue + " bits."));
        }
        this.in = new ByteArrayInputStream(in, offset, length);
        this.bitPackingReader = BitPacking.createBitPackingReader((int)this.bitsPerValue, (InputStream)this.in, (long)valueCount);
        return offset + length;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

