/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.dictionary;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.values.ValuesWriter;
import parquet.column.values.dictionary.IntList;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import parquet.io.ParquetEncodingException;
import parquet.io.api.Binary;
import parquet.it.unimi.dsi.fastutil.doubles.Double2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.doubles.Double2IntMap;
import parquet.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import parquet.it.unimi.dsi.fastutil.floats.Float2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.floats.Float2IntMap;
import parquet.it.unimi.dsi.fastutil.floats.FloatIterator;
import parquet.it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.ints.Int2IntMap;
import parquet.it.unimi.dsi.fastutil.ints.IntIterator;
import parquet.it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import parquet.it.unimi.dsi.fastutil.longs.Long2IntMap;
import parquet.it.unimi.dsi.fastutil.longs.LongIterator;

public abstract class DictionaryValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(DictionaryValuesWriter.class);
    private static final int MAX_DICTIONARY_ENTRIES = 65535;
    protected final int maxDictionaryByteSize;
    protected final PlainValuesWriter plainValuesWriter;
    protected boolean dictionaryTooBig;
    protected int dictionaryByteSize;
    protected int lastUsedDictionaryByteSize;
    protected int lastUsedDictionarySize;
    protected IntList encodedValues = new IntList();

    protected DictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
        this.maxDictionaryByteSize = maxDictionaryByteSize;
        this.plainValuesWriter = new PlainValuesWriter(initialSize);
    }

    protected void checkAndFallbackIfNeeded() {
        if (this.dictionaryByteSize > this.maxDictionaryByteSize || this.getDictionarySize() > 65535) {
            if (Log.DEBUG) {
                LOG.debug((Object)("dictionary is now too big, falling back to plain: " + this.dictionaryByteSize + "B and " + this.getDictionarySize() + " entries"));
            }
            this.dictionaryTooBig = true;
            if (this.lastUsedDictionarySize == 0) {
                this.clearDictionaryContent();
                this.dictionaryByteSize = 0;
                this.encodedValues = null;
            }
        }
    }

    @Override
    public long getBufferedSize() {
        return this.dictionaryTooBig ? this.plainValuesWriter.getBufferedSize() : (long)(this.encodedValues.size() * 4);
    }

    @Override
    public long getAllocatedSize() {
        return (long)((this.encodedValues == null ? 0 : this.encodedValues.size() * 4) + this.dictionaryByteSize) + this.plainValuesWriter.getAllocatedSize();
    }

    @Override
    public BytesInput getBytes() {
        if (!this.dictionaryTooBig && this.getDictionarySize() > 0) {
            this.lastUsedDictionarySize = this.getDictionarySize();
            this.lastUsedDictionaryByteSize = this.dictionaryByteSize;
            int maxDicId = this.getDictionarySize() - 1;
            if (Log.DEBUG) {
                LOG.debug((Object)("max dic id " + maxDicId));
            }
            int bitWidth = BytesUtils.getWidthFromMaxInt((int)maxDicId);
            RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(bitWidth, 65536);
            IntList.IntIterator iterator = this.encodedValues.iterator();
            try {
                while (iterator.hasNext()) {
                    encoder.writeInt(iterator.next());
                }
                byte[] bytesHeader = new byte[]{(byte)bitWidth};
                BytesInput rleEncodedBytes = encoder.toBytes();
                if (Log.DEBUG) {
                    LOG.debug((Object)("rle encoded bytes " + rleEncodedBytes.size()));
                }
                return BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.from((byte[])bytesHeader), rleEncodedBytes});
            }
            catch (IOException e) {
                throw new ParquetEncodingException("could not encode the values", e);
            }
        }
        return this.plainValuesWriter.getBytes();
    }

    @Override
    public Encoding getEncoding() {
        if (!this.dictionaryTooBig && this.getDictionarySize() > 0) {
            return Encoding.PLAIN_DICTIONARY;
        }
        return this.plainValuesWriter.getEncoding();
    }

    @Override
    public void reset() {
        if (this.encodedValues != null) {
            this.encodedValues = new IntList();
        }
        this.plainValuesWriter.reset();
    }

    @Override
    public void resetDictionary() {
        this.lastUsedDictionaryByteSize = 0;
        this.lastUsedDictionarySize = 0;
        this.dictionaryTooBig = false;
        this.clearDictionaryContent();
    }

    protected abstract void clearDictionaryContent();

    protected abstract int getDictionarySize();

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s DictionaryValuesWriter{\n%s\n%s\n%s\n%s}\n", prefix, this.plainValuesWriter.memUsageString(prefix + " plain:"), prefix + " dict:" + this.dictionaryByteSize, prefix + " values:" + this.encodedValues.size() * 4, prefix);
    }

    public static class PlainFloatDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Float2IntMap floatDictionaryContent = new Float2IntLinkedOpenHashMap();

        public PlainFloatDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.floatDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeFloat(float v) {
            if (!this.dictionaryTooBig) {
                int id = this.floatDictionaryContent.get(v);
                if (id == -1) {
                    id = this.floatDictionaryContent.size();
                    this.floatDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 4;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            }
            this.plainValuesWriter.writeFloat(v);
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                FloatIterator floatIterator = this.floatDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeFloat(floatIterator.nextFloat());
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.floatDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.floatDictionaryContent.clear();
        }
    }

    public static class PlainIntegerDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Int2IntMap intDictionaryContent = new Int2IntLinkedOpenHashMap();

        public PlainIntegerDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.intDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeInteger(int v) {
            if (!this.dictionaryTooBig) {
                int id = this.intDictionaryContent.get(v);
                if (id == -1) {
                    id = this.intDictionaryContent.size();
                    this.intDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 4;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            }
            this.plainValuesWriter.writeInteger(v);
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                IntIterator intIterator = this.intDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeInteger(intIterator.nextInt());
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.intDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.intDictionaryContent.clear();
        }
    }

    public static class PlainDoubleDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Double2IntMap doubleDictionaryContent = new Double2IntLinkedOpenHashMap();

        public PlainDoubleDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.doubleDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeDouble(double v) {
            if (!this.dictionaryTooBig) {
                int id = this.doubleDictionaryContent.get(v);
                if (id == -1) {
                    id = this.doubleDictionaryContent.size();
                    this.doubleDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 8;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            }
            this.plainValuesWriter.writeDouble(v);
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                DoubleIterator doubleIterator = this.doubleDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeDouble(doubleIterator.nextDouble());
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.doubleDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.doubleDictionaryContent.clear();
        }
    }

    public static class PlainLongDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Long2IntMap longDictionaryContent = new Long2IntLinkedOpenHashMap();

        public PlainLongDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
            this.longDictionaryContent.defaultReturnValue(-1);
        }

        @Override
        public void writeLong(long v) {
            if (!this.dictionaryTooBig) {
                int id = this.longDictionaryContent.get(v);
                if (id == -1) {
                    id = this.longDictionaryContent.size();
                    this.longDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 8;
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            }
            this.plainValuesWriter.writeLong(v);
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                LongIterator longIterator = this.longDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    dictionaryEncoder.writeLong(longIterator.nextLong());
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.longDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.longDictionaryContent.clear();
        }
    }

    public static class PlainBinaryDictionaryValuesWriter
    extends DictionaryValuesWriter {
        private Map<Binary, Integer> binaryDictionaryContent = new LinkedHashMap<Binary, Integer>();

        public PlainBinaryDictionaryValuesWriter(int maxDictionaryByteSize, int initialSize) {
            super(maxDictionaryByteSize, initialSize);
        }

        @Override
        public void writeBytes(Binary v) {
            if (!this.dictionaryTooBig) {
                Integer id = this.binaryDictionaryContent.get(v);
                if (id == null) {
                    id = this.binaryDictionaryContent.size();
                    this.binaryDictionaryContent.put(v, id);
                    this.dictionaryByteSize += 2 + v.length();
                }
                this.encodedValues.add(id);
                this.checkAndFallbackIfNeeded();
            }
            this.plainValuesWriter.writeBytes(v);
        }

        @Override
        public DictionaryPage createDictionaryPage() {
            if (this.lastUsedDictionarySize > 0) {
                PlainValuesWriter dictionaryEncoder = new PlainValuesWriter(this.lastUsedDictionaryByteSize);
                Iterator<Binary> binaryIterator = this.binaryDictionaryContent.keySet().iterator();
                for (int i = 0; i < this.lastUsedDictionarySize; ++i) {
                    Binary entry = binaryIterator.next();
                    dictionaryEncoder.writeBytes(entry);
                }
                return new DictionaryPage(dictionaryEncoder.getBytes(), this.lastUsedDictionarySize, Encoding.PLAIN_DICTIONARY);
            }
            return this.plainValuesWriter.createDictionaryPage();
        }

        @Override
        public int getDictionarySize() {
            return this.binaryDictionaryContent.size();
        }

        @Override
        protected void clearDictionaryContent() {
            this.binaryDictionaryContent.clear();
        }
    }
}

