/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.rle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import parquet.Ints;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.Encoding;
import parquet.column.values.ValuesWriter;
import parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import parquet.io.ParquetEncodingException;

public class RunLengthBitPackingHybridValuesWriter
extends ValuesWriter {
    private final RunLengthBitPackingHybridEncoder encoder;
    private final ByteArrayOutputStream length;

    public RunLengthBitPackingHybridValuesWriter(int bitWidth, int initialCapacity) {
        this.encoder = new RunLengthBitPackingHybridEncoder(bitWidth, initialCapacity);
        this.length = new ByteArrayOutputStream(4);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.encoder.writeInt(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.encoder.getBufferedSize();
    }

    @Override
    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    @Override
    public BytesInput getBytes() {
        try {
            BytesInput rle = this.encoder.toBytes();
            BytesUtils.writeIntLittleEndian((OutputStream)this.length, (int)Ints.checkedCast((long)rle.size()));
            return BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.from((byte[])this.length.toByteArray()), rle});
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.RLE;
    }

    @Override
    public void reset() {
        this.encoder.reset();
        this.length.reset();
    }

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s RunLengthBitPackingHybrid %d bytes", prefix, this.getAllocatedSize());
    }
}

