/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter;

import parquet.Preconditions;
import parquet.column.ColumnReader;

public class ColumnPredicates {
    public static Predicate equalTo(final String target) {
        Preconditions.checkNotNull((Object)target, (String)"target");
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input) {
                return target.equals(input.getBinary().toStringUsingUTF8());
            }
        };
    }

    public static Predicate equalTo(final int target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input) {
                return input.getInteger() == target;
            }
        };
    }

    public static Predicate equalTo(final long target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input) {
                return input.getLong() == target;
            }
        };
    }

    public static Predicate equalTo(final float target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input) {
                return input.getFloat() == target;
            }
        };
    }

    public static Predicate equalTo(final double target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input) {
                return input.getDouble() == target;
            }
        };
    }

    public static Predicate equalTo(final boolean target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input) {
                return input.getBoolean() == target;
            }
        };
    }

    public static <E extends Enum> Predicate equalTo(E target) {
        Preconditions.checkNotNull(target, (String)"target");
        final String targetAsString = target.name();
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input) {
                return targetAsString.equals(input.getBinary().toStringUsingUTF8());
            }
        };
    }

    public static interface Predicate {
        public boolean apply(ColumnReader var1);
    }
}

