/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.mem;

import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.column.ColumnDescriptor;
import parquet.column.ColumnReader;
import parquet.column.ColumnWriter;
import parquet.column.impl.ColumnReadStoreImpl;
import parquet.column.impl.ColumnWriteStoreImpl;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageWriteStore;
import parquet.column.page.mem.MemPageStore;
import parquet.example.DummyRecordConverter;
import parquet.io.api.Binary;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class TestMemColumn {
    private static final Log LOG = Log.getLog(TestMemColumn.class);

    @Test
    public void testMemColumn() throws Exception {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required int64 bar; } }");
        ColumnDescriptor path = schema.getColumnDescription(new String[]{"foo", "bar"});
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriter columnWriter = this.getColumnWriter(path, memPageStore);
        columnWriter.write(42L, 0, 0);
        columnWriter.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, schema);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getLong(), (long)42L);
            columnReader.consume();
            ++i;
        }
    }

    private ColumnWriter getColumnWriter(ColumnDescriptor path, MemPageStore memPageStore) {
        ColumnWriteStoreImpl memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        return columnWriter;
    }

    private ColumnReader getColumnReader(MemPageStore memPageStore, ColumnDescriptor path, MessageType schema) {
        return new ColumnReadStoreImpl((PageReadStore)memPageStore, new DummyRecordConverter(schema).getRootConverter(), schema).getColumnReader(path);
    }

    @Test
    public void testMemColumnBinary() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required binary bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreImpl memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        columnWriter.write(Binary.fromString((String)"42"), 0, 0);
        columnWriter.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((Object)columnReader.getBinary().toStringUsingUTF8(), (Object)"42");
            columnReader.consume();
            ++i;
        }
    }

    @Test
    public void testMemColumnSeveralPages() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required int64 bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreImpl memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        for (int i = 0; i < 2000; ++i) {
            columnWriter.write(42L, 0, 0);
        }
        columnWriter.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getLong(), (long)42L);
            columnReader.consume();
            ++i;
        }
    }

    @Test
    public void testMemColumnSeveralPagesRepeated() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { repeated group foo { repeated int64 bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreImpl memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        int[] rs = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2};
        int[] ds = new int[]{0, 1, 2, 0, 1, 2, 0, 1, 2};
        for (int i = 0; i < 837; ++i) {
            int r = rs[i % rs.length];
            int d = ds[i % ds.length];
            LOG.debug((Object)("write i: " + i));
            if (d == 2) {
                columnWriter.write((long)i, r, d);
                continue;
            }
            columnWriter.writeNull(r, d);
        }
        columnWriter.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        int j = 0;
        while ((long)j < columnReader.getTotalValueCount()) {
            int r = rs[i % rs.length];
            int d = ds[i % ds.length];
            LOG.debug((Object)("read i: " + i));
            Assert.assertEquals((String)("r row " + i), (long)r, (long)columnReader.getCurrentRepetitionLevel());
            Assert.assertEquals((String)("d row " + i), (long)d, (long)columnReader.getCurrentDefinitionLevel());
            if (d == 2) {
                Assert.assertEquals((String)("data row " + i), (long)i, (long)columnReader.getLong());
            }
            columnReader.consume();
            ++i;
            ++j;
        }
    }

    private ColumnWriteStoreImpl newColumnWriteStoreImpl(MemPageStore memPageStore) {
        return new ColumnWriteStoreImpl((PageWriteStore)memPageStore, 2048, 2048, 2048, false);
    }
}

